/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.dts.DtsBundle;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.lang.psi.DtsValue;
import com.intellij.dts.util.DtsTextRangeKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001aM\u0010\u0011\u001a\u00020\t*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0015\u0010\u0013\u001a\u00110\u0003\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a8\u0006\u001c"}, d2={"firstNotMatching", "", "str", "", "rx", "Lkotlin/text/Regex;", "callback", "Lkotlin/Function1;", "", "", "propertyValueRange", "Lcom/intellij/openapi/util/TextRange;", "property", "Lcom/intellij/dts/lang/psi/DtsProperty;", "elementInspectionRange", "element", "Lcom/intellij/psi/PsiElement;", "registerProblem", "Lcom/intellij/codeInspection/ProblemsHolder;", "bundleKey", "Lorg/jetbrains/annotations/PropertyKey;", "resourceBundle", "messages.DtsBundle", "bundleParam", "", "rangeInElement", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsInspectionsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsInspectionsUtil.kt\ncom/intellij/dts/inspections/DtsInspectionsUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class DtsInspectionsUtilKt {
    public static final boolean firstNotMatching(@NotNull String str, @NotNull Regex rx, @NotNull Function1<? super Character, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)rx, (String)"rx");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char c : cArray) {
            if (rx.matches((CharSequence)String.valueOf(c))) continue;
            callback.invoke((Object)Character.valueOf(c));
            return true;
        }
        return false;
    }

    @Nullable
    public static final TextRange propertyValueRange(@NotNull DtsProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        List<DtsValue> values = property.getDtsValues();
        if (values.isEmpty()) {
            return null;
        }
        TextRange valuesRange = new TextRange(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)CollectionsKt.first(values))), PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)CollectionsKt.last(values))));
        TextRange textRange = property.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return DtsTextRangeKt.relativeTo(valuesRange, textRange);
    }

    private static final TextRange elementInspectionRange(PsiElement element) {
        if (!(element instanceof DtsStatement)) {
            return null;
        }
        TextRange textRange = DtsPsiUtilKt.getDtsAnnotationTarget((DtsStatement)element).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextRange textRange2 = ((DtsStatement)element).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRange(...)");
        return DtsTextRangeKt.relativeTo(textRange, textRange2);
    }

    public static final void registerProblem(@NotNull ProblemsHolder $this$registerProblem, @NotNull PsiElement element, @NotNull String bundleKey, @Nullable Object bundleParam, @Nullable TextRange rangeInElement, @Nullable LocalQuickFix fix) {
        TextRange textRange;
        LocalQuickFix[] fixes;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$registerProblem, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)bundleKey, (String)"bundleKey");
        InspectionManager manager = InspectionManager.getInstance((Project)element.getProject());
        Object object = bundleParam;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            Object[] objectArray2 = new Object[]{it};
            objectArray = objectArray2;
        } else {
            objectArray = new Object[]{};
        }
        Object[] params = objectArray;
        LocalQuickFix localQuickFix = fix;
        if (localQuickFix != null) {
            LocalQuickFix it = localQuickFix;
            boolean bl = false;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{it};
            v3 = localQuickFixArray;
        } else {
            v3 = fixes = new LocalQuickFix[]{};
        }
        if ((textRange = rangeInElement) == null) {
            textRange = DtsInspectionsUtilKt.elementInspectionRange(element);
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(element, textRange, DtsBundle.Companion.message(bundleKey, Arrays.copyOf(params, params.length)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, $this$registerProblem.isOnTheFly(), Arrays.copyOf(fixes, fixes.length));
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        ProblemDescriptor descriptor = problemDescriptor;
        $this$registerProblem.registerProblem(descriptor);
    }

    public static /* synthetic */ void registerProblem$default(ProblemsHolder problemsHolder, PsiElement psiElement, String string, Object object, TextRange textRange, LocalQuickFix localQuickFix, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            textRange = null;
        }
        if ((n & 0x10) != 0) {
            localQuickFix = null;
        }
        DtsInspectionsUtilKt.registerProblem(problemsHolder, psiElement, string, object, textRange, localQuickFix);
    }
}

