/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.formatting;

import com.intellij.dts.lang.DtsTokenSets;
import com.intellij.dts.lang.psi.DtsArray;
import com.intellij.dts.lang.psi.DtsContainer;
import com.intellij.dts.lang.psi.DtsNodeContent;
import com.intellij.dts.lang.psi.DtsProperty;
import com.intellij.dts.lang.psi.DtsPropertyContent;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.lang.psi.DtsValue;
import com.intellij.dts.settings.DtsCodeStyleSettings;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00112\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u0010H$J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\u0010H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "<init>", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "getSettings", "()Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "getWrap", "Lcom/intellij/formatting/Wrap;", "parent", "Lcom/intellij/formatting/Block;", "child", "Lcom/intellij/lang/ASTNode;", "getAlignment", "Lcom/intellij/formatting/Alignment;", "Lcom/intellij/psi/PsiElement;", "Companion", "Null", "Container", "PropertyContent", "Array", "intellij.dts"})
public abstract class DtsWrappingBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DtsCodeStyleSettings settings;
    @NotNull
    private static final TokenSet NO_WRAP;

    public DtsWrappingBuilder(@NotNull DtsCodeStyleSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
        this.settings = settings2;
    }

    @NotNull
    protected final DtsCodeStyleSettings getSettings() {
        return this.settings;
    }

    @Nullable
    public final Wrap getWrap(@Nullable Block parent, @NotNull ASTNode child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        PsiElement parentElement = ASTBlock.getPsiElement((Block)parent);
        PsiElement psiElement = child.getPsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement childElement = psiElement;
        if (NO_WRAP.contains(child.getElementType())) {
            return null;
        }
        return this.getWrap(parentElement, childElement);
    }

    @Nullable
    public final Alignment getAlignment(@Nullable Block parent, @NotNull ASTNode child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        PsiElement parentElement = ASTBlock.getPsiElement((Block)parent);
        PsiElement psiElement = child.getPsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement childElement = psiElement;
        if (DtsTokenSets.INSTANCE.getComments().contains(child.getElementType())) {
            return null;
        }
        return this.getAlignment(parentElement, childElement);
    }

    @Nullable
    protected abstract Wrap getWrap(@Nullable PsiElement var1, @NotNull PsiElement var2);

    @Nullable
    protected abstract Alignment getAlignment(@Nullable PsiElement var1, @NotNull PsiElement var2);

    static {
        SpreadBuilder spreadBuilder = new SpreadBuilder(3);
        spreadBuilder.addSpread((Object)DtsTokenSets.INSTANCE.getComments().getTypes());
        spreadBuilder.add((Object)DtsTypes.PP_STATEMENT);
        spreadBuilder.add((Object)DtsTypes.PP_INACTIVE);
        TokenSet tokenSet = TokenSet.create((IElementType[])((IElementType[])spreadBuilder.toArray((Object[])new IElementType[spreadBuilder.size()])));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        NO_WRAP = tokenSet;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n \b*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Array;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "<init>", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "wrap", "Lcom/intellij/formatting/Wrap;", "kotlin.jvm.PlatformType", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "Lcom/intellij/formatting/Alignment;", "getWrap", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getAlignment", "intellij.dts"})
    private static final class Array
    extends DtsWrappingBuilder {
        private final Wrap wrap;
        private final Alignment alignment;

        public Array(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
            this.wrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
            this.alignment = Alignment.createAlignment();
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (parent instanceof DtsArray && child instanceof DtsValue) {
                return this.wrap;
            }
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this.getSettings().ALIGN_PROPERTY_VALUES && parent instanceof DtsArray && child instanceof DtsValue) {
                return this.alignment;
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Companion;", "", "<init>", "()V", "NO_WRAP", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "childBuilder", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "parent", "Lcom/intellij/formatting/Block;", "current", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DtsWrappingBuilder childBuilder(@NotNull CodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            CustomCodeStyleSettings customCodeStyleSettings = settings2.getCustomSettings(DtsCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            return new Null((DtsCodeStyleSettings)customCodeStyleSettings);
        }

        @NotNull
        public final DtsWrappingBuilder childBuilder(@Nullable Block parent, @NotNull DtsWrappingBuilder current) {
            Intrinsics.checkNotNullParameter((Object)current, (String)"current");
            PsiElement element = ASTBlock.getPsiElement((Block)parent);
            if (element instanceof DtsContainer) {
                return new Container(current.getSettings());
            }
            IElementType iElementType = ASTBlock.getElementType((Block)parent);
            return Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.PROPERTY_CONTENT) ? (DtsWrappingBuilder)new PropertyContent(current.getSettings()) : (Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.CELL_ARRAY) || Intrinsics.areEqual((Object)iElementType, (Object)DtsTypes.BYTE_ARRAY) ? (DtsWrappingBuilder)new Array(current.getSettings()) : current);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n \b*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Container;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "<init>", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "wrap", "Lcom/intellij/formatting/Wrap;", "kotlin.jvm.PlatformType", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "Lcom/intellij/formatting/Alignment;", "getWrap", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getAlignment", "intellij.dts"})
    private static final class Container
    extends DtsWrappingBuilder {
        private final Wrap wrap;
        private final Alignment alignment;

        public Container(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
            this.wrap = Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true);
            this.alignment = Alignment.createAlignment((boolean)true, (Alignment.Anchor)Alignment.Anchor.LEFT);
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (parent instanceof DtsNodeContent) {
                return this.wrap;
            }
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this.getSettings().ALIGN_PROPERTY_ASSIGNMENT && parent instanceof DtsProperty && Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)child), (Object)DtsTypes.ASSIGN)) {
                return this.alignment;
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0014J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$Null;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "<init>", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "getWrap", "Lcom/intellij/formatting/Wrap;", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getAlignment", "Lcom/intellij/formatting/Alignment;", "intellij.dts"})
    private static final class Null
    extends DtsWrappingBuilder {
        public Null(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n \b*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/dts/formatting/DtsWrappingBuilder$PropertyContent;", "Lcom/intellij/dts/formatting/DtsWrappingBuilder;", "settings", "Lcom/intellij/dts/settings/DtsCodeStyleSettings;", "<init>", "(Lcom/intellij/dts/settings/DtsCodeStyleSettings;)V", "wrap", "Lcom/intellij/formatting/Wrap;", "kotlin.jvm.PlatformType", "Lcom/intellij/formatting/Wrap;", "alignment", "Lcom/intellij/formatting/Alignment;", "Lcom/intellij/formatting/Alignment;", "getWrap", "parent", "Lcom/intellij/psi/PsiElement;", "child", "getAlignment", "intellij.dts"})
    private static final class PropertyContent
    extends DtsWrappingBuilder {
        private final Wrap wrap;
        private final Alignment alignment;

        public PropertyContent(@NotNull DtsCodeStyleSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)((Object)settings2), (String)"settings");
            super(settings2);
            this.wrap = Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)false);
            this.alignment = Alignment.createAlignment((boolean)true);
        }

        @Override
        @Nullable
        protected Wrap getWrap(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (parent instanceof DtsPropertyContent && child instanceof DtsValue) {
                return this.wrap;
            }
            return null;
        }

        @Override
        @Nullable
        protected Alignment getAlignment(@Nullable PsiElement parent, @NotNull PsiElement child) {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            if (this.getSettings().ALIGN_PROPERTY_VALUES && parent instanceof DtsPropertyContent && child instanceof DtsValue) {
                return this.alignment;
            }
            return null;
        }
    }
}

