/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.documentation;

import com.intellij.dts.documentation.DtsDocumentationHtmlBuilder;
import com.intellij.dts.documentation.DtsDocumentationTarget;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsPsiUtilKt;
import com.intellij.dts.lang.psi.DtsRefNode;
import com.intellij.dts.util.DtsTreeUtil;
import com.intellij.dts.zephyr.binding.DtsZephyrBinding;
import com.intellij.dts.zephyr.binding.DtsZephyrBindingProvider;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/dts/documentation/DtsNodeDocumentationTarget;", "Lcom/intellij/dts/documentation/DtsDocumentationTarget;", "node", "Lcom/intellij/dts/lang/psi/DtsNode;", "<init>", "(Lcom/intellij/dts/lang/psi/DtsNode;)V", "createPointer", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "nodeNameTarget", "buildDocumentation", "", "html", "Lcom/intellij/dts/documentation/DtsDocumentationHtmlBuilder;", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsNodeDocumentationTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsNodeDocumentationTarget.kt\ncom/intellij/dts/documentation/DtsNodeDocumentationTarget\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,39:1\n1#2:40\n*E\n"})
public final class DtsNodeDocumentationTarget
extends DtsDocumentationTarget {
    @NotNull
    private final DtsNode node;

    public DtsNodeDocumentationTarget(@NotNull DtsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Project project = node.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project);
        this.node = node;
    }

    @NotNull
    public Pointer<? extends DocumentationTarget> createPointer() {
        SmartPsiElementPointer propertyPtr = SmartPointersKt.createSmartPointer((PsiElement)this.node);
        return () -> DtsNodeDocumentationTarget.createPointer$lambda$1(propertyPtr);
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.Companion.builder(DtsPsiUtilKt.getDtsPresentableText(this.node)).icon(this.node.getIcon(0)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    private final DtsNode nodeNameTarget(DtsNode node) {
        if (!(node instanceof DtsRefNode)) {
            return node;
        }
        DtsNode dtsNode = DtsPsiUtilKt.getDtsReferenceTarget((DtsNode.Ref)node);
        if (dtsNode == null) {
            dtsNode = node;
        }
        return dtsNode;
    }

    @Override
    protected void buildDocumentation(@NotNull DtsDocumentationHtmlBuilder html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.buildNodeName(html, this.nodeNameTarget(this.node));
        DtsNode dtsNode = DtsTreeUtil.INSTANCE.findParentNode(this.node);
        if (dtsNode != null) {
            DtsNode parent = dtsNode;
            boolean bl = false;
            this.buildDeclaredIn(html, parent);
        }
        DtsZephyrBinding dtsZephyrBinding = DtsZephyrBindingProvider.Companion.bindingFor(this.node, false);
        if (dtsZephyrBinding == null) {
            return;
        }
        DtsZephyrBinding binding = dtsZephyrBinding;
        this.buildNodeBinding(html, binding);
    }

    private static final DtsNodeDocumentationTarget createPointer$lambda$1(SmartPsiElementPointer $propertyPtr) {
        DtsNodeDocumentationTarget dtsNodeDocumentationTarget;
        DtsNode dtsNode = (DtsNode)$propertyPtr.dereference();
        if (dtsNode != null) {
            DtsNode it = dtsNode;
            boolean bl = false;
            dtsNodeDocumentationTarget = new DtsNodeDocumentationTarget(it);
        } else {
            dtsNodeDocumentationTarget = null;
        }
        return dtsNodeDocumentationTarget;
    }
}

