/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.clion;

import com.intellij.dts.clion.impl.DtsCMakeModelConfigurationDataProvider;
import com.intellij.dts.settings.DtsSettings;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.FlowPreview;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0019B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dts/clion/DtsZephyrCMakeSync;", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspaceListener;", "Lcom/intellij/dts/settings/DtsSettings$ChangeListener;", "Lcom/intellij/execution/ExecutionTargetListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "alarm", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "syncSettings", "reloadingFinished", "canceled", "", "settingsChanged", "settings", "Lcom/intellij/dts/settings/DtsSettings;", "activeTargetChanged", "newTarget", "Lcom/intellij/execution/ExecutionTarget;", "Companion", "intellij.dts"})
@FlowPreview
public final class DtsZephyrCMakeSync
implements CMakeWorkspaceListener,
DtsSettings.ChangeListener,
ExecutionTargetListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableSharedFlow<Unit> alarm;
    @NotNull
    private static final String ZEPHYR_BOARD_PATH_VARIABLE = "BOARD_DIR";
    @NotNull
    private static final String ZEPHYR_ROOT_PATH_VARIABLE = "ZEPHYR_BASE";
    @NotNull
    private static final Logger logger;

    public DtsZephyrCMakeSync(@NotNull Project project, @NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.project = project;
        this.alarm = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        BuildersKt.launch$default((CoroutineScope)parentScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DtsZephyrCMakeSync this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.alarm), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ DtsZephyrCMakeSync this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.this$0.syncSettings();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void syncSettings() {
        String rootPath;
        CMakeConfigurator cMakeConfigurator;
        DtsSettings settings2 = DtsSettings.Companion.of(this.project);
        if (!settings2.getZephyrCMakeSync()) {
            return;
        }
        CMakeModelConfigurationData activeConfig = DtsCMakeModelConfigurationDataProvider.Companion.getFirstCMakeModelConfigurationData(this.project);
        if (activeConfig == null) {
            return;
        }
        try {
            cMakeConfigurator = activeConfig.getCacheConfigurator();
        }
        catch (Exception e) {
            logger.debug("failed to get cmake cache configurator", (Throwable)e);
            return;
        }
        CMakeConfigurator cache = cMakeConfigurator;
        CMakeVariable cMakeVariable = cache.findVariable(ZEPHYR_BOARD_PATH_VARIABLE);
        String boardPath = cMakeVariable != null ? cMakeVariable.getValue() : null;
        CMakeVariable cMakeVariable2 = cache.findVariable(ZEPHYR_ROOT_PATH_VARIABLE);
        String string = rootPath = cMakeVariable2 != null ? cMakeVariable2.getValue() : null;
        if (Intrinsics.areEqual((Object)settings2.getZephyrRoot(), (Object)rootPath) && Intrinsics.areEqual((Object)settings2.getZephyrBoard(), (Object)boardPath)) {
            return;
        }
        settings2.update((Function1<? super DtsSettings.State, Unit>)((Function1)arg_0 -> DtsZephyrCMakeSync.syncSettings$lambda$0(rootPath, boardPath, arg_0)));
    }

    public void reloadingFinished(boolean canceled) {
        if (canceled) {
            return;
        }
        this.alarm.tryEmit((Object)Unit.INSTANCE);
    }

    @Override
    public void settingsChanged(@NotNull DtsSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        this.alarm.tryEmit((Object)Unit.INSTANCE);
    }

    public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
        Intrinsics.checkNotNullParameter((Object)newTarget, (String)"newTarget");
        this.alarm.tryEmit((Object)Unit.INSTANCE);
    }

    private static final Unit syncSettings$lambda$0(String $rootPath, String $boardPath, DtsSettings.State $this$update) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        String string = $rootPath;
        if (string == null) {
            string = "";
        }
        $this$update.setZephyrRoot(string);
        String string2 = $boardPath;
        if (string2 == null) {
            string2 = "";
        }
        $this$update.setZephyrBoard(string2);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(DtsZephyrCMakeSync.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DtsZephyrCMakeSync.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/dts/clion/DtsZephyrCMakeSync$Companion;", "", "<init>", "()V", "ZEPHYR_BOARD_PATH_VARIABLE", "", "ZEPHYR_ROOT_PATH_VARIABLE", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.dts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

