/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.api;

import com.intellij.dts.api.DtsFileVisitor;
import com.intellij.dts.api.DtsFileVisitorKt;
import com.intellij.dts.lang.DtsFile;
import com.intellij.dts.lang.psi.DtsCompilerDirective;
import com.intellij.dts.lang.psi.DtsEntry;
import com.intellij.dts.lang.psi.DtsNode;
import com.intellij.dts.lang.psi.DtsPHandle;
import com.intellij.dts.lang.psi.DtsRefNode;
import com.intellij.dts.lang.psi.DtsRootNode;
import com.intellij.dts.lang.psi.DtsStatement;
import com.intellij.dts.lang.psi.DtsTypes;
import com.intellij.dts.lang.psi.FileInclude;
import com.intellij.dts.lang.psi.PsiFileInclude;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H$\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001d\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u001f\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0002\u0010!J'\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lcom/intellij/dts/api/Walker;", "", "visitor", "Lcom/intellij/dts/api/DtsFileVisitor;", "<init>", "(Lcom/intellij/dts/api/DtsFileVisitor;)V", "getVisitor", "()Lcom/intellij/dts/api/DtsFileVisitor;", "visited", "", "Lcom/intellij/psi/PsiFile;", "getVisited", "()Ljava/util/Set;", "walkContent", "", "file", "Lcom/intellij/dts/lang/DtsFile;", "maxOffset", "", "(Lcom/intellij/dts/lang/DtsFile;Ljava/lang/Integer;)V", "alreadyVisited", "", "walkFile", "walkInclude", "include", "Lcom/intellij/dts/lang/psi/FileInclude;", "walkCompilerDirective", "directive", "Lcom/intellij/dts/lang/psi/DtsCompilerDirective;", "(Lcom/intellij/dts/lang/psi/DtsCompilerDirective;Ljava/lang/Integer;)V", "walkEntry", "entry", "Lcom/intellij/dts/lang/psi/DtsEntry;", "(Lcom/intellij/dts/lang/psi/DtsEntry;Ljava/lang/Integer;)V", "walkChild", "child", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/dts/lang/DtsFile;Lcom/intellij/psi/PsiElement;Ljava/lang/Integer;)V", "intellij.dts"})
@SourceDebugExtension(value={"SMAP\nDtsFileVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsFileVisitor.kt\ncom/intellij/dts/api/Walker\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n19#2:139\n1#3:140\n*S KotlinDebug\n*F\n+ 1 DtsFileVisitor.kt\ncom/intellij/dts/api/Walker\n*L\n70#1:139\n*E\n"})
abstract class Walker {
    @NotNull
    private final DtsFileVisitor visitor;
    @NotNull
    private final Set<PsiFile> visited;

    public Walker(@NotNull DtsFileVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        this.visitor = visitor2;
        this.visited = new LinkedHashSet();
    }

    @NotNull
    public final DtsFileVisitor getVisitor() {
        return this.visitor;
    }

    @NotNull
    public final Set<PsiFile> getVisited() {
        return this.visited;
    }

    protected abstract void walkContent(@NotNull DtsFile var1, @Nullable Integer var2);

    private final boolean alreadyVisited(DtsFile file) {
        return !this.visited.add((PsiFile)file);
    }

    public final void walkFile(@NotNull DtsFile file, @Nullable Integer maxOffset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.alreadyVisited(file)) {
            return;
        }
        boolean walkContent = this.visitor.visit(file);
        if (!walkContent) {
            return;
        }
        this.walkContent(file, maxOffset);
    }

    protected final void walkInclude(@NotNull DtsFile file, @NotNull FileInclude include) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)include, (String)"include");
        this.visitor.visitInclude(file, include);
        PsiFile psiFile = include.resolve((PsiFile)file);
        if (psiFile == null) {
            return;
        }
        PsiFile target = psiFile;
        if (!(target instanceof DtsFile)) {
            return;
        }
        this.walkFile((DtsFile)target, null);
    }

    private final void walkCompilerDirective(DtsCompilerDirective directive, Integer maxOffset) {
        if (!Intrinsics.areEqual((Object)directive.getDtsDirectiveType(), (Object)DtsTypes.DELETE_NODE)) {
            return;
        }
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(directive.getDtsDirectiveArgs());
        if (psiElement == null) {
            return;
        }
        PsiElement arg = psiElement;
        if (!(arg instanceof DtsPHandle) || DtsFileVisitorKt.afterMaxOffset(arg, maxOffset)) {
            return;
        }
        PsiReference psiReference = ((DtsPHandle)arg).getReference();
        PsiElement $this$asSafely$iv = psiReference != null ? psiReference.resolve() : null;
        boolean $i$f$asSafely = false;
        PsiElement psiElement2 = $this$asSafely$iv;
        if (!(psiElement2 instanceof DtsNode)) {
            psiElement2 = null;
        }
        DtsNode dtsNode = (DtsNode)psiElement2;
        if (dtsNode == null) {
            return;
        }
        DtsNode target = dtsNode;
        this.visitor.visitDeleteNode(target);
    }

    private final void walkEntry(DtsEntry entry, Integer maxOffset) {
        DtsStatement statement = entry.getDtsStatement();
        if (statement instanceof DtsRootNode) {
            this.visitor.visitRootNode((DtsRootNode)statement, maxOffset);
        } else if (statement instanceof DtsRefNode) {
            this.visitor.visitRefNode((DtsRefNode)statement, maxOffset);
        } else if (statement instanceof DtsCompilerDirective) {
            this.walkCompilerDirective((DtsCompilerDirective)statement, maxOffset);
        }
    }

    protected final void walkChild(@NotNull DtsFile file, @NotNull PsiElement child, @Nullable Integer maxOffset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        if (DtsFileVisitorKt.afterMaxOffset(child, maxOffset)) {
            return;
        }
        if (child instanceof PsiFileInclude) {
            FileInclude fileInclude = ((PsiFileInclude)child).getFileInclude();
            if (fileInclude != null) {
                FileInclude include = fileInclude;
                boolean bl = false;
                this.walkInclude(file, include);
            }
        }
        if (child instanceof DtsEntry) {
            this.walkEntry((DtsEntry)child, maxOffset);
        }
    }
}

