/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dts.api;

import com.intellij.dts.util.DtsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u0000J\u0006\u0010\u000f\u001a\u00020\u0000J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dts/api/DtsPath;", "", "absolut", "", "segments", "", "", "<init>", "(ZLjava/util/List;)V", "getAbsolut", "()Z", "getSegments", "()Ljava/util/List;", "relativize", "other", "parent", "name", "nameWithoutUnit", "toString", "component1", "component2", "copy", "equals", "hashCode", "", "Companion", "intellij.dts"})
public final class DtsPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean absolut;
    @NotNull
    private final List<String> segments;
    @NotNull
    private static final DtsPath root = new DtsPath(true, CollectionsKt.emptyList());

    public DtsPath(boolean absolut, @NotNull List<String> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        this.absolut = absolut;
        this.segments = segments;
    }

    public final boolean getAbsolut() {
        return this.absolut;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    @Nullable
    public final DtsPath relativize(@NotNull DtsPath other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.segments.size() < this.segments.size()) {
            return null;
        }
        int n = ((Collection)this.segments).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)this.segments.get(i), (Object)other.segments.get(i))) continue;
            return null;
        }
        return new DtsPath(false, CollectionsKt.slice(other.segments, (IntRange)RangesKt.until((int)this.segments.size(), (int)other.segments.size())));
    }

    @NotNull
    public final DtsPath parent() {
        return new DtsPath(this.absolut, CollectionsKt.dropLast(this.segments, (int)1));
    }

    @Nullable
    public final String name() {
        return (String)CollectionsKt.lastOrNull(this.segments);
    }

    @Nullable
    public final String nameWithoutUnit() {
        String string = this.name();
        if (string == null) {
            return null;
        }
        String name = string;
        return (String)DtsUtil.INSTANCE.splitName(name).getFirst();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.segments, (CharSequence)"/", (CharSequence)(this.absolut ? "/" : ""), null, (int)0, null, null, (int)60, null);
    }

    public final boolean component1() {
        return this.absolut;
    }

    @NotNull
    public final List<String> component2() {
        return this.segments;
    }

    @NotNull
    public final DtsPath copy(boolean absolut, @NotNull List<String> segments) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        return new DtsPath(absolut, segments);
    }

    public static /* synthetic */ DtsPath copy$default(DtsPath dtsPath, boolean bl, List list, int n, Object object) {
        if ((n & 1) != 0) {
            bl = dtsPath.absolut;
        }
        if ((n & 2) != 0) {
            list = dtsPath.segments;
        }
        return dtsPath.copy(bl, list);
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.absolut);
        result = result * 31 + ((Object)this.segments).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DtsPath)) {
            return false;
        }
        DtsPath dtsPath = (DtsPath)other;
        if (this.absolut != dtsPath.absolut) {
            return false;
        }
        return Intrinsics.areEqual(this.segments, dtsPath.segments);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dts/api/DtsPath$Companion;", "", "<init>", "()V", "root", "Lcom/intellij/dts/api/DtsPath;", "getRoot", "()Lcom/intellij/dts/api/DtsPath;", "from", "path", "", "intellij.dts"})
    @SourceDebugExtension(value={"SMAP\nDtsPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtsPath.kt\ncom/intellij/dts/api/DtsPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n774#2:49\n865#2,2:50\n*S KotlinDebug\n*F\n+ 1 DtsPath.kt\ncom/intellij/dts/api/DtsPath$Companion\n*L\n17#1:49\n17#1:50,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DtsPath getRoot() {
            return root;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DtsPath from(@NotNull String path) {
            List list;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object = new char[]{'/'};
            CharSequence charSequence = StringsKt.trim((String)path, (char[])object);
            object = new char[]{'/'};
            object = StringsKt.split$default((CharSequence)charSequence, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl = StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null);
            boolean $i$f$filter = false;
            void var4_5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = ((CharSequence)it).length() > 0;
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = list = (List)destination$iv$iv;
            boolean bl4 = bl;
            return new DtsPath(bl4, list2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

