/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import java.io.File;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageToolVersionMatcher;", "", "<init>", "()V", "match", "", "toolName", "toolCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getToolVersion", "Lcom/intellij/openapi/util/Version;", "tool", "getCompilerVersion", "Companion", "intellij.clion.coverage"})
@SourceDebugExtension(value={"SMAP\nCMakeCoverageToolVersionMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeCoverageToolVersionMatcher.kt\ncom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageToolVersionMatcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class CMakeCoverageToolVersionMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Regex VERSION_PATTERN = new Regex("^.*?([\\d]+\\.[\\d]+\\.?[\\d]*).*", RegexOption.MULTILINE);

    @Nullable
    public final String match(@NotNull String toolName, @NotNull GeneralCommandLine toolCommandLine, @NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        Version compilerVersion;
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)toolCommandLine, (String)"toolCommandLine");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Version toolVersion = this.getToolVersion(toolCommandLine, environment);
        if (toolVersion == null) {
            CidrCoverageLogKt.getCidrCoverageLog().info("Cannot match tool/compiler versions: tool version is null");
        }
        if ((compilerVersion = this.getCompilerVersion(configuration, environment)) == null) {
            CidrCoverageLogKt.getCidrCoverageLog().info("Cannot match tool/compiler versions: compiler version is null");
        }
        if (toolVersion != null && compilerVersion != null && !Intrinsics.areEqual((Object)toolVersion, (Object)compilerVersion)) {
            Object[] objectArray = new Object[]{toolName, toolVersion.toString(), compilerVersion.toString()};
            return CidrCoverageBundle.message((String)"coverage.tool.version.mismatch", (Object[])objectArray);
        }
        return null;
    }

    private final Version getToolVersion(GeneralCommandLine tool, CidrToolEnvironment environment) {
        String[] stringArray = new String[]{"--version"};
        ProcessOutput out = environment.getHostMachine().runProcess(tool.withParameters(stringArray), 500);
        boolean bl = false;
        Pattern[] patternArray = new Pattern[]{VERSION_PATTERN.toPattern()};
        return VersionUtil.parseVersion((String)out.getStdout(), (Pattern[])patternArray);
    }

    @Nullable
    public final Version getCompilerVersion(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        GCCCompiler compiler;
        String string;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        OCCompilerSettings oCCompilerSettings = CMakeCoverageUtil.Companion.getMostRelevantCompilerSettings(configuration);
        if (oCCompilerSettings == null) {
            return null;
        }
        OCCompilerSettings compilerSettings = oCCompilerSettings;
        OCCompilerKind compilerKind = compilerSettings.getCompilerKind();
        File compilerExecutable = compilerSettings.getCompilerExecutable();
        File compilerWorkingDirectory = compilerSettings.getCompilerWorkingDir();
        if ((Intrinsics.areEqual((Object)compilerKind, (Object)ClangCompilerKind.INSTANCE) || Intrinsics.areEqual((Object)compilerKind, (Object)AppleClangCompilerKind.INSTANCE) || Intrinsics.areEqual((Object)compilerKind, (Object)GCCCompilerKind.INSTANCE)) && compilerExecutable != null && compilerWorkingDirectory != null && (string = (compiler = new GCCCompiler(compilerExecutable, compilerWorkingDirectory, environment, (TempFilesPool)TempFilesPool.INSTANCE)).readVersion(VERSION_PATTERN.toPattern())) != null) {
            String it = string;
            boolean bl = false;
            Pattern[] patternArray = new Pattern[]{VERSION_PATTERN.toPattern()};
            return VersionUtil.parseVersion((String)it, (Pattern[])patternArray);
        }
        CidrCoverageLogKt.getCidrCoverageLog().info("Cannot get compiler version: compilerExecutable/compilerWorkingDirectory is not found or it's not clang/gcc");
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageToolVersionMatcher$Companion;", "", "<init>", "()V", "VERSION_PATTERN", "Lkotlin/text/Regex;", "intellij.clion.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

