/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.coverage.CoverageOptions;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.tools.ToolsBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.jetbrains.cidr.cpp.execution.coverage.CLionCoverageSettings;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageSettings;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0012\u0010\u001c\u001a\u00020\u00052\b\b\u0001\u0010\u001d\u001a\u00020\u001aH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CLionCoverageOptions;", "Lcom/intellij/coverage/CoverageOptions;", "<init>", "()V", "gcovExecutableTextField", "Lcom/intellij/ui/components/JBTextField;", "llvmCovExecutableTextField", "llvmProfdataExecutableTextField", "branchCoverageCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "commonCoverageSettings", "Lcom/jetbrains/cidr/execution/coverage/CidrCoverageSettings;", "clionCoverageSettings", "Lcom/jetbrains/cidr/cpp/execution/coverage/CLionCoverageSettings;", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "apply", "", "reset", "createTextFieldWithBrowseButton", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "Lcom/intellij/ui/dsl/builder/Row;", "toolName", "", "textField", "createExecutableField", "toolPath", "intellij.clion.coverage"})
public final class CLionCoverageOptions
extends CoverageOptions {
    @Nullable
    private JBTextField gcovExecutableTextField;
    @Nullable
    private JBTextField llvmCovExecutableTextField;
    @Nullable
    private JBTextField llvmProfdataExecutableTextField;
    @Nullable
    private JBCheckBox branchCoverageCheckBox;
    @NotNull
    private final CidrCoverageSettings commonCoverageSettings = CidrCoverageSettings.Companion.getInstance();
    @NotNull
    private final CLionCoverageSettings clionCoverageSettings = CLionCoverageSettings.Companion.getInstance();

    @Nullable
    public JComponent createComponent() {
        this.gcovExecutableTextField = this.createExecutableField(this.clionCoverageSettings.getGcovExecutablePath());
        this.llvmCovExecutableTextField = this.createExecutableField(this.clionCoverageSettings.getLlvmCovExecutablePath());
        this.llvmProfdataExecutableTextField = this.createExecutableField(this.clionCoverageSettings.getLlvmProfdataExecutablePath());
        return (JComponent)BuilderKt.panel(arg_0 -> CLionCoverageOptions.createComponent$lambda$4(this, arg_0)).withBorder((Border)IdeBorderFactory.createTitledBorder((String)ToolsBundle.message((String)"tools.settings", (Object[])new Object[0])));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        JBTextField jBTextField = this.gcovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField);
        if (!Intrinsics.areEqual((Object)jBTextField.getText(), (Object)this.clionCoverageSettings.getGcovExecutablePath())) return true;
        JBTextField jBTextField2 = this.llvmCovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField2);
        if (!Intrinsics.areEqual((Object)jBTextField2.getText(), (Object)this.clionCoverageSettings.getLlvmCovExecutablePath())) return true;
        JBTextField jBTextField3 = this.llvmProfdataExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField3);
        if (!Intrinsics.areEqual((Object)jBTextField3.getText(), (Object)this.clionCoverageSettings.getLlvmProfdataExecutablePath())) return true;
        JBCheckBox jBCheckBox = this.branchCoverageCheckBox;
        Intrinsics.checkNotNull((Object)jBCheckBox);
        if (jBCheckBox.isSelected() == this.commonCoverageSettings.getBranchCoverage()) return false;
        return true;
    }

    public void apply() {
        JBTextField jBTextField = this.gcovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField);
        this.clionCoverageSettings.setGcovExecutablePath(jBTextField.getText());
        JBTextField jBTextField2 = this.llvmCovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField2);
        this.clionCoverageSettings.setLlvmCovExecutablePath(jBTextField2.getText());
        JBTextField jBTextField3 = this.llvmProfdataExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField3);
        this.clionCoverageSettings.setLlvmProfdataExecutablePath(jBTextField3.getText());
        JBCheckBox jBCheckBox = this.branchCoverageCheckBox;
        Intrinsics.checkNotNull((Object)jBCheckBox);
        this.commonCoverageSettings.setBranchCoverage(jBCheckBox.isSelected());
    }

    public void reset() {
        JBTextField jBTextField = this.gcovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField);
        jBTextField.setText(this.clionCoverageSettings.getGcovExecutablePath());
        JBTextField jBTextField2 = this.llvmCovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField2);
        jBTextField2.setText(this.clionCoverageSettings.getLlvmCovExecutablePath());
        JBTextField jBTextField3 = this.llvmProfdataExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField3);
        jBTextField3.setText(this.clionCoverageSettings.getLlvmProfdataExecutablePath());
        JBCheckBox jBCheckBox = this.branchCoverageCheckBox;
        Intrinsics.checkNotNull((Object)jBCheckBox);
        jBCheckBox.setSelected(this.commonCoverageSettings.getBranchCoverage());
    }

    private final Cell<TextFieldWithBrowseButton> createTextFieldWithBrowseButton(Row $this$createTextFieldWithBrowseButton, @NlsSafe String toolName, JBTextField textField) {
        Object[] objectArray = new Object[]{toolName};
        BrowseFilesListener listener = new BrowseFilesListener((JTextField)textField, FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(CidrCoverageBundle.message((String)"tool.executable.path", (Object[])objectArray)));
        return $this$createTextFieldWithBrowseButton.cell((JComponent)new TextFieldWithBrowseButton((JTextField)textField, (ActionListener)listener)).align((Align)AlignX.FILL.INSTANCE);
    }

    private final JBTextField createExecutableField(@Nls String toolPath) {
        JBTextField textField = new JBTextField(toolPath);
        textField.getEmptyText().setText(CidrCoverageBundle.message((String)"specify.tool.path.placeholder", (Object[])new Object[0]));
        return textField;
    }

    private static final Unit createComponent$lambda$4$lambda$0(CLionCoverageOptions this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrCoverageBundle.message((String)"show.branch.coverage.checkbox", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.branchCoverageCheckBox = (JBCheckBox)Cell.comment$default((Cell)ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)this$0.commonCoverageSettings.getBranchCoverage()), (String)CidrCoverageBundle.message((String)"show.branch.coverage.hint", (Object[])new Object[0]), (int)0, null, (int)6, null).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$4$lambda$1(CLionCoverageOptions this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBTextField jBTextField = this$0.gcovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField);
        this$0.createTextFieldWithBrowseButton($this$row, "gcov", jBTextField);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$4$lambda$2(CLionCoverageOptions this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBTextField jBTextField = this$0.llvmCovExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField);
        this$0.createTextFieldWithBrowseButton($this$row, "llvm-cov", jBTextField);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$4$lambda$3(CLionCoverageOptions this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JBTextField jBTextField = this$0.llvmProfdataExecutableTextField;
        Intrinsics.checkNotNull((Object)jBTextField);
        this$0.createTextFieldWithBrowseButton($this$row, "llvm-profdata", jBTextField);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$4(CLionCoverageOptions this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> CLionCoverageOptions.createComponent$lambda$4$lambda$0(this$0, arg_0), (int)1, null);
        String string = CidrCoverageBundle.message((String)"gcov.binary.row.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> CLionCoverageOptions.createComponent$lambda$4$lambda$1(this$0, arg_0));
        String string2 = CidrCoverageBundle.message((String)"llvm.cov.binary.row.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$panel.row(string2, arg_0 -> CLionCoverageOptions.createComponent$lambda$4$lambda$2(this$0, arg_0));
        String string3 = CidrCoverageBundle.message((String)"llvm.profdata.binary.row.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        $this$panel.row(string3, arg_0 -> CLionCoverageOptions.createComponent$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

