/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.BitHacksKt;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/utils/UUIDUtils;", "", "<init>", "()V", "parseCurlyBracketsValue", "Ljava/util/UUID;", "value", "", "createFromString", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nUUIDUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UUIDUtils.kt\ncom/jetbrains/rider/utils/UUIDUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,38:1\n14#2:39\n*S KotlinDebug\n*F\n+ 1 UUIDUtils.kt\ncom/jetbrains/rider/utils/UUIDUtils\n*L\n14#1:39\n*E\n"})
public final class UUIDUtils {
    @NotNull
    public static final UUIDUtils INSTANCE = new UUIDUtils();

    private UUIDUtils() {
    }

    @NotNull
    public final UUID parseCurlyBracketsValue(@NotNull String value) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            uUID = UUID.fromString(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)value, (CharSequence)"{"), (CharSequence)"}"));
        }
        catch (Exception ex) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(UUIDUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)ex);
            uUID = new UUID(0L, 0L);
        }
        return uUID;
    }

    @NotNull
    public final UUID createFromString(@Nullable String value) {
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            return new UUID(0L, 0L);
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        MessageDigest sha1 = messageDigest;
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] sha1Bytes = sha1.digest(byArray);
        byte[] byArray2 = new byte[]{sha1Bytes[3], sha1Bytes[2], sha1Bytes[1], sha1Bytes[0], sha1Bytes[5], sha1Bytes[4], sha1Bytes[7], sha1Bytes[6], sha1Bytes[8], sha1Bytes[9], sha1Bytes[10], sha1Bytes[11], sha1Bytes[12], sha1Bytes[13], sha1Bytes[14], sha1Bytes[15]};
        byte[] data2 = byArray2;
        return new UUID(BitHacksKt.parseLong((byte[])data2, (int)0), BitHacksKt.parseLong((byte[])data2, (int)8));
    }
}

