/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.utils.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J8\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010\u0014\u001a\u0002H\u00132\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\b\u0018H\u0004\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u00020\u00172\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010 \u001a\u00020\u0003H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00010\tj\b\u0012\u0004\u0012\u00020\u0001`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000ej\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/utils/Tag;", "Lcom/jetbrains/rider/utils/Element;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "attributes", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getAttributes", "()Ljava/util/HashMap;", "initTag", "T", "tag", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/jetbrains/rider/utils/Element;Lkotlin/jvm/functions/Function1;)Lcom/jetbrains/rider/utils/Element;", "render", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "renderAttributes", "toString", "intellij.rider.rdclient.dotnet"})
public abstract class Tag
implements Element {
    @NotNull
    private final String name;
    @NotNull
    private final ArrayList<Element> children;
    @NotNull
    private final HashMap<String, String> attributes;

    public Tag(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.children = new ArrayList();
        this.attributes = new HashMap();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ArrayList<Element> getChildren() {
        return this.children;
    }

    @NotNull
    public final HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    @NotNull
    protected final <T extends Element> T initTag(@NotNull T tag, @NotNull Function1<? super T, Unit> init2) {
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        init2.invoke(tag);
        this.children.add(tag);
        return tag;
    }

    @Override
    public void render(@NotNull StringBuilder builder, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        builder.append(indent + "<" + this.name + this.renderAttributes() + ">\n");
        Iterator<Element> iterator2 = this.children.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Element> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Element c;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            c.render(builder, indent + "  ");
        }
        builder.append(indent + "</" + this.name + ">\n");
    }

    private final String renderAttributes() {
        StringBuilder builder = new StringBuilder();
        Iterator<String> iterator2 = this.attributes.keySet().iterator();
        while (iterator2.hasNext()) {
            String a;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            builder.append(" " + a + "=\"" + this.attributes.get(a) + "\"");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.render(builder, "");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

