/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.utils;

import com.jetbrains.rider.utils.UUIDUtils;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/utils/ProjectTypeGuidGuesser;", "", "<init>", "()V", "Companion", "intellij.rider.rdclient.dotnet"})
public final class ProjectTypeGuidGuesser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/utils/ProjectTypeGuidGuesser$Companion;", "", "<init>", "()V", "calculateTypeGuid", "Ljava/util/UUID;", "projectPath", "Ljava/nio/file/Path;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UUID calculateTypeGuid(@NotNull Path projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            return switch (PathsKt.getExtension((Path)projectPath)) {
                case "csproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{FAE04EC0-301F-11D3-BF4B-00C04F79EFBC}");
                case "vbproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{F184B08F-C81C-45F6-A57F-5ABD9991F28F}");
                case "shproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{D954291E-2A0B-460D-934E-DC6B0785DB48}");
                case "xproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{8BB2217D-0F2D-49D1-97BC-3654ED321F3B}");
                case "vcxproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}");
                case "msbuildproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{13B669BE-BB05-4DDF-9536-439F39A36129}");
                case "isproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{6141683F-8A12-4E36-9623-2EB02B2C2303}");
                case "njsproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{9092AA53-FB77-4645-B42D-1CCCA6BD08BD}");
                case "esproj" -> UUIDUtils.INSTANCE.parseCurlyBracketsValue("{54A90642-561A-4BB1-A94E-469ADEE60C69}");
                default -> new UUID(0L, 0L);
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

