/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.idea;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/util/idea/TimeLogger;", "", "<init>", "()V", "start", "", "sections", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/util/idea/TimeLogger$Section;", "Lkotlin/collections/ArrayList;", "section", "R", "name", "", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "complete", "Section", "intellij.rider.rdclient.dotnet"})
public final class TimeLogger {
    private final long start = System.currentTimeMillis();
    @NotNull
    private final ArrayList<Section> sections = new ArrayList();

    public final <R> R section(@NotNull String name, @NotNull Function0<? extends R> action2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        long startMillis = System.currentTimeMillis();
        Object result2 = action2.invoke();
        long endMillis = System.currentTimeMillis();
        this.sections.add(new Section(name, endMillis - startMillis));
        return (R)result2;
    }

    @NotNull
    public final String complete(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        long end = System.currentTimeMillis();
        long total = end - this.start;
        String time = new SimpleDateFormat("HH:mm:ss:SS").format(new Date());
        StringBuilder sectionTimes = new StringBuilder();
        Iterator<Section> iterator2 = this.sections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Section> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Section section;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            sectionTimes.append("\t" + section.getName() + " for " + section.getTime() + " ms");
            if (total > 0L) {
                int p = (int)((float)section.getTime() / (float)total * (float)100);
                sectionTimes.append(" " + p + "%");
            }
            Intrinsics.checkNotNullExpressionValue((Object)sectionTimes.append('\n'), (String)"append(...)");
        }
        return time + " " + name + " for " + total + " ms, details:\n" + sectionTimes;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/util/idea/TimeLogger$Section;", "", "name", "", "time", "", "<init>", "(Ljava/lang/String;J)V", "getName", "()Ljava/lang/String;", "getTime", "()J", "intellij.rider.rdclient.dotnet"})
    private static final class Section {
        @NotNull
        private final String name;
        private final long time;

        public Section(@NotNull String name, long time) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.time = time;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getTime() {
            return this.time;
        }
    }
}

