/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui;

import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RowIcon;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rider.ui.RiderColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00042\u00020\u0001:\u0005\u0004\u0005\u0006\u0007\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/ui/RiderUI;", "", "<init>", "()V", "Companion", "CompositeIcon", "CommonPalette", "VsPalette", "VerticalScrollPanelWrapper", "intellij.rider.rdclient.dotnet"})
public final class RiderUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Color HeaderBackgroundColor;
    @NotNull
    private static final Color UsualBackgroundColor;
    private static final int MediumHeaderHeight;

    static {
        Color color = JBUI.CurrentTheme.ToolWindow.headerBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"headerBackground(...)");
        HeaderBackgroundColor = color;
        Color color2 = UIUtil.getListBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListBackground(...)");
        UsualBackgroundColor = color2;
        MediumHeaderHeight = 30;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$CommonPalette;", "", "<init>", "()V", "Companion", "intellij.rider.rdclient.dotnet"})
    public static final class CommonPalette {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final RiderColor white;
        @NotNull
        private static final RiderColor red;
        @NotNull
        private static final RiderColor lightGreen;

        static {
            Color color = Color.white;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"white");
            white = new RiderColor(color);
            red = new RiderColor(0x7F0000, 0xFF553F);
            lightGreen = new RiderColor(25600, 0x90EE90);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$CommonPalette$Companion;", "", "<init>", "()V", "white", "Lcom/jetbrains/rider/ui/RiderColor;", "getWhite", "()Lcom/jetbrains/rider/ui/RiderColor;", "gray", "Lcom/intellij/ui/JBColor;", "getGray", "()Lcom/intellij/ui/JBColor;", "red", "getRed", "lightGreen", "getLightGreen", "getTableBgColor", "Ljava/awt/Color;", "row", "", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RiderColor getWhite() {
                return white;
            }

            @NotNull
            public final JBColor getGray() {
                Color color = JBUI.CurrentTheme.TabbedPane.DISABLED_TEXT_COLOR;
                JBColor jBColor = color instanceof JBColor ? (JBColor)color : null;
                if (jBColor == null) {
                    Color color2 = Color.lightGray;
                    Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"lightGray");
                    Gray gray = Gray._100;
                    Intrinsics.checkNotNullExpressionValue((Object)gray, (String)"_100");
                    jBColor = new RiderColor(color2, (Color)gray);
                }
                return jBColor;
            }

            @NotNull
            public final RiderColor getRed() {
                return red;
            }

            @NotNull
            public final RiderColor getLightGreen() {
                return lightGreen;
            }

            @NotNull
            public final Color getTableBgColor(int row) {
                Color color;
                if (row % 2 == 0) {
                    Color color2 = UIUtil.getDecoratedRowColor();
                    color = color2;
                    Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDecoratedRowColor(...)");
                } else {
                    color = RiderUI.Companion.getUsualBackgroundColor();
                }
                return color;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0015\u001a\u00020\u00162\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b\u001aJ\u001f\u0010\u001b\u001a\u00020\u00162\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b\u001aJ\u001f\u0010\u001c\u001a\u00020\u001d2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b\u001aJ\u001f\u0010\u001e\u001a\u00020\u001d2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\"J(\u0010#\u001a\u00020$2\b\b\u0001\u0010!\u001a\u00020\"2\b\u0010%\u001a\u0004\u0018\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(J\u001e\u0010#\u001a\u00020$2\b\b\u0001\u0010!\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020-2\b\b\u0003\u0010/\u001a\u00020\"J\u000e\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\u0005J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000205J*\u00107\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u00108\u001a\u00020\u00122\b\b\u0002\u00109\u001a\u0002052\b\b\u0002\u0010:\u001a\u000205J\u0016\u0010;\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010<\u001a\u00020\u0012J8\u0010=\u001a\u00020\u0019\"\u0006\b\u0000\u0010>\u0018\u00012\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H>0@2\u0014\b\u0004\u0010A\u001a\u000e\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020B0\u0018H\u0086\b\u00f8\u0001\u0000J@\u0010C\u001a\u00020\u0019\"\n\b\u0000\u0010>\u0018\u0001*\u00020D2\u0006\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020\u00122\u0014\b\u0004\u0010H\u001a\u000e\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020\u00190\u0018H\u0086\b\u00f8\u0001\u0000J6\u0010I\u001a\u00020\u0019\"\n\b\u0000\u0010>\u0018\u0001*\u00020D2\u0006\u0010E\u001a\u00020F2\u0014\b\u0004\u0010H\u001a\u000e\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020\u00190\u0018H\u0086\b\u00f8\u0001\u0000JF\u0010J\u001a\u00020\u0019\"\n\b\u0000\u0010>\u0018\u0001*\u00020+2\u0006\u0010K\u001a\u0002H>2\u001f\b\u0004\u0010'\u001a\u0019\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020\u00190L\u00a2\u0006\u0002\b\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJF\u0010O\u001a\u00020\u0019\"\n\b\u0000\u0010>\u0018\u0001*\u00020+2\u0006\u0010K\u001a\u0002H>2\u001f\b\u0004\u0010'\u001a\u0019\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020\u00190L\u00a2\u0006\u0002\b\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJF\u0010P\u001a\u00020\u0019\"\n\b\u0000\u0010>\u0018\u0001*\u00020+2\u0006\u0010K\u001a\u0002H>2\u001f\b\u0004\u0010'\u001a\u0019\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u00020Q\u0012\u0004\u0012\u00020\u00190L\u00a2\u0006\u0002\b\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u000e\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UJ$\u0010V\u001a\u00020\u00192\u0006\u0010T\u001a\u00020+2\u0006\u0010W\u001a\u00020\"2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00190(J,\u0010V\u001a\u00020\u00192\u0006\u0010T\u001a\u00020+2\u0006\u0010Y\u001a\u00020\"2\u0006\u0010W\u001a\u00020\"2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00190(J>\u0010Z\u001a\u00020\u0019\"\u0004\b\u0000\u0010[2\f\u0010?\u001a\b\u0012\u0004\u0012\u0002H[0@2\u0006\u0010W\u001a\u00020\"2\u001a\u0010A\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H[0\\\u0012\u0006\u0012\u0004\u0018\u00010B0\u0018J\u000e\u0010]\u001a\u00020\u00192\u0006\u0010K\u001a\u00020+J$\u0010^\u001a\u0004\u0018\u00010&2\b\u0010_\u001a\u0004\u0018\u00010&2\b\u0010`\u001a\u0004\u0018\u00010&2\u0006\u0010a\u001a\u000205R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006b"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$Companion;", "", "<init>", "()V", "HeaderBackgroundColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "getHeaderBackgroundColor", "()Ljava/awt/Color;", "UsualBackgroundColor", "getUsualBackgroundColor", "HeaderFont", "Ljava/awt/Font;", "getHeaderFont", "()Ljava/awt/Font;", "BigFont", "getBigFont", "MediumHeaderHeight", "", "getMediumHeaderHeight", "()I", "headerPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "init", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "borderPanel", "boxPanel", "Ljavax/swing/JPanel;", "flowPanel", "checkBox", "Ljavax/swing/JCheckBox;", "title", "", "menuItem", "Ljavax/swing/JMenuItem;", "icon", "Ljavax/swing/Icon;", "handler", "Lkotlin/Function0;", "updateParentHeight", "component", "Ljavax/swing/JComponent;", "createLabel", "Ljavax/swing/JLabel;", "createHeaderLabel", "text", "toHtml", "color", "getTextColor", "Lcom/jetbrains/rider/ui/RiderColor;", "isSelected", "", "isFocused", "setHeight", "height", "keepWidth", "scale", "setWidth", "width", "addPopupHandler", "T", "list", "Lcom/intellij/ui/components/JBList;", "createPopup", "Ljavax/swing/JPopupMenu;", "addClickHandler", "Ljavax/swing/tree/MutableTreeNode;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "count", "clickHandler", "addDoubleClickHandler", "onMouseClicked", "comp", "Lkotlin/Function2;", "Ljava/awt/event/MouseEvent;", "(Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function2;)V", "onMouseDoubleClicked", "onFocusGained", "Ljava/awt/event/FocusEvent;", "verticalScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "c", "Ljava/awt/Component;", "overrideKeyStroke", "stroke", "action", "key", "addKeyboardPopupHandler", "E", "", "updateScroller", "combineIcons", "icon1", "icon2", "horizontal", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderUI.kt\ncom/jetbrains/rider/ui/RiderUI$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n130#1:308\n141#1:309\n1#2:307\n*S KotlinDebug\n*F\n+ 1 RiderUI.kt\ncom/jetbrains/rider/ui/RiderUI$Companion\n*L\n144#1:308\n144#1:309\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getHeaderBackgroundColor() {
            return HeaderBackgroundColor;
        }

        @NotNull
        public final Color getUsualBackgroundColor() {
            return UsualBackgroundColor;
        }

        @NotNull
        public final Font getHeaderFont() {
            Font it = UIUtil.getListFont();
            boolean bl = false;
            Font font = it.deriveFont(1, it.getSize2D());
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"let(...)");
            return font;
        }

        @NotNull
        public final Font getBigFont() {
            Font it = UIUtil.getListFont();
            boolean bl = false;
            Font font = it.deriveFont(it.getStyle(), (float)((double)it.getSize2D() * 1.3));
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"let(...)");
            return font;
        }

        public final int getMediumHeaderHeight() {
            return MediumHeaderHeight;
        }

        @NotNull
        public final BorderLayoutPanel headerPanel(@NotNull Function1<? super BorderLayoutPanel, Unit> init2) {
            Intrinsics.checkNotNullParameter(init2, (String)"init");
            BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel(){
                {
                    this.setBorder((Border)new JBEmptyBorder(2, 8, 2, 12));
                }

                public Color getBackground() {
                    return RiderUI.Companion.getHeaderBackgroundColor();
                }
            };
            init2.invoke((Object)borderLayoutPanel);
            return borderLayoutPanel;
        }

        @NotNull
        public final BorderLayoutPanel borderPanel(@NotNull Function1<? super BorderLayoutPanel, Unit> init2) {
            Intrinsics.checkNotNullParameter(init2, (String)"init");
            BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel(){

                public Color getBackground() {
                    return RiderUI.Companion.getUsualBackgroundColor();
                }
            };
            init2.invoke((Object)borderLayoutPanel);
            return borderLayoutPanel;
        }

        @NotNull
        public final JPanel boxPanel(@NotNull Function1<? super JPanel, Unit> init2) {
            Intrinsics.checkNotNullParameter(init2, (String)"init");
            JPanel jPanel = new JPanel(){
                {
                    this.setLayout(new BoxLayout(this, 1));
                }

                public Color getBackground() {
                    return RiderUI.Companion.getUsualBackgroundColor();
                }
            };
            init2.invoke((Object)jPanel);
            return jPanel;
        }

        @NotNull
        public final JPanel flowPanel(@NotNull Function1<? super JPanel, Unit> init2) {
            Intrinsics.checkNotNullParameter(init2, (String)"init");
            JPanel jPanel = new JPanel(){
                {
                    this.setLayout(new FlowLayout(0));
                }

                public Color getBackground() {
                    return RiderUI.Companion.getUsualBackgroundColor();
                }
            };
            init2.invoke((Object)jPanel);
            return jPanel;
        }

        @NotNull
        public final JCheckBox checkBox(@Nls @NotNull String title) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            return new JCheckBox(title){

                public Color getBackground() {
                    return RiderUI.Companion.getUsualBackgroundColor();
                }
            };
        }

        @NotNull
        public final JMenuItem menuItem(@Nls @NotNull String title, @Nullable Icon icon, @NotNull Function0<Unit> handler) {
            JMenuItem jMenuItem;
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            if (icon != null) {
                JMenuItem jMenuItem2;
                JMenuItem $this$menuItem_u24lambda_u243 = jMenuItem2 = new JMenuItem(title, icon);
                boolean bl = false;
                $this$menuItem_u24lambda_u243.addActionListener(arg_0 -> Companion.menuItem$lambda$3$lambda$2(handler, arg_0));
                return jMenuItem2;
            }
            JMenuItem $this$menuItem_u24lambda_u245 = jMenuItem = new JMenuItem(title);
            boolean bl = false;
            $this$menuItem_u24lambda_u245.addActionListener(arg_0 -> Companion.menuItem$lambda$5$lambda$4(handler, arg_0));
            return jMenuItem;
        }

        @NotNull
        public final JMenuItem menuItem(@Nls @NotNull String title, @NotNull Function0<Unit> handler) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            return this.menuItem(title, null, handler);
        }

        public final void updateParentHeight(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            if (component.getParent() != null) {
                component.getParent().setMaximumSize(new Dimension(Integer.MAX_VALUE, component.getMaximumSize().height));
            }
        }

        @NotNull
        public final JLabel createLabel() {
            JLabel jLabel;
            JLabel $this$createLabel_u24lambda_u246 = jLabel = new JLabel();
            boolean bl = false;
            $this$createLabel_u24lambda_u246.setFont(UIUtil.getLabelFont());
            return jLabel;
        }

        @NotNull
        public final JLabel createHeaderLabel(@NlsContexts.Label @NotNull String text) {
            JLabel jLabel;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            JLabel $this$createHeaderLabel_u24lambda_u247 = jLabel = new JLabel(text);
            boolean bl = false;
            $this$createHeaderLabel_u24lambda_u247.setFont(Companion.getHeaderFont());
            return jLabel;
        }

        public static /* synthetic */ JLabel createHeaderLabel$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = "";
            }
            return companion.createHeaderLabel(string);
        }

        @NotNull
        public final String toHtml(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            String string = "#%02x%02x%02x";
            Object[] objectArray = new Object[]{color.getRed(), color.getGreen(), color.getBlue()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }

        @NotNull
        public final RiderColor getTextColor(boolean isSelected, boolean isFocused) {
            RiderColor riderColor;
            if (isSelected) {
                Color color = UIUtil.getListSelectionForeground((boolean)isFocused);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListSelectionForeground(...)");
                riderColor = new RiderColor(color);
            } else {
                Color color = UIUtil.getListForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getListForeground(...)");
                riderColor = new RiderColor(color);
            }
            return riderColor;
        }

        public final void setHeight(@NotNull JComponent component, int height, boolean keepWidth, boolean scale) {
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            int scaledHeight = scale ? JBUI.scale((int)height) : height;
            JComponent $this$setHeight_u24lambda_u248 = jComponent = component;
            boolean bl = false;
            $this$setHeight_u24lambda_u248.setPreferredSize(new Dimension(keepWidth ? $this$setHeight_u24lambda_u248.getPreferredSize().width : 0, scaledHeight));
            $this$setHeight_u24lambda_u248.setMinimumSize(new Dimension(keepWidth ? $this$setHeight_u24lambda_u248.getMinimumSize().width : 0, scaledHeight));
            $this$setHeight_u24lambda_u248.setMaximumSize(new Dimension(keepWidth ? $this$setHeight_u24lambda_u248.getMaximumSize().width : Integer.MAX_VALUE, scaledHeight));
        }

        public static /* synthetic */ void setHeight$default(Companion companion, JComponent jComponent, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                bl2 = true;
            }
            companion.setHeight(jComponent, n, bl, bl2);
        }

        public final void setWidth(@NotNull JComponent component, int width) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            int scaledWidth = JBUI.scale((int)width);
            component.setPreferredSize(new Dimension(scaledWidth, 0));
            component.setMinimumSize(new Dimension(scaledWidth, 0));
            component.setMaximumSize(new Dimension(scaledWidth, Integer.MAX_VALUE));
        }

        public final /* synthetic */ <T> void addPopupHandler(JBList<T> list2, Function1<? super T, ? extends JPopupMenu> createPopup2) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter(createPopup2, (String)"createPopup");
            boolean $i$f$addPopupHandler = false;
            list2.addMouseListener((MouseListener)new PopupHandler(list2, createPopup2){
                final /* synthetic */ JBList<T> $list;
                final /* synthetic */ Function1<T, JPopupMenu> $createPopup;
                {
                    this.$list = $list;
                    this.$createPopup = $createPopup;
                }

                public void invokePopup(Component comp, int x, int y) {
                    int index = this.$list.locationToIndex(new Point(x, y - 1));
                    if (index != -1) {
                        ListModel listModel2 = this.$list.getModel();
                        Intrinsics.checkNotNull((Object)listModel2, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<T of com.jetbrains.rider.ui.RiderUI.Companion.addPopupHandler>");
                        E element = ((DefaultListModel)listModel2).get(index);
                        if (element != null) {
                            JPopupMenu popup = (JPopupMenu)this.$createPopup.invoke(element);
                            popup.show((Component)this.$list, x, y);
                        }
                    }
                }
            });
        }

        public final /* synthetic */ <T extends MutableTreeNode> void addClickHandler(Tree tree, int count, Function1<? super T, Unit> clickHandler) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter(clickHandler, (String)"clickHandler");
            boolean $i$f$addClickHandler = false;
            Intrinsics.needClassReification();
            tree.addMouseListener((MouseListener)new MouseAdapter(count, tree, clickHandler){
                final /* synthetic */ int $count;
                final /* synthetic */ Tree $tree;
                final /* synthetic */ Function1<T, Unit> $clickHandler;
                {
                    this.$count = $count;
                    this.$tree = $tree;
                    this.$clickHandler = $clickHandler;
                }

                public void mouseClicked(MouseEvent e) {
                    TreePath path;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if ((e.getClickCount() == this.$count || this.$count == 0) && (path = this.$tree.getPathForLocation(e.getX(), e.getY())) != null) {
                        Object node = path.getLastPathComponent();
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                        if (node instanceof MutableTreeNode) {
                            this.$clickHandler.invoke(node);
                        }
                    }
                }
            });
        }

        public static /* synthetic */ void addClickHandler$default(Companion $this, Tree tree, int count, Function1 clickHandler, int n, Object object) {
            if ((n & 2) != 0) {
                count = 1;
            }
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)clickHandler, (String)"clickHandler");
            boolean $i$f$addClickHandler = false;
            Intrinsics.needClassReification();
            tree.addMouseListener((MouseListener)new /* invalid duplicate definition of identical inner class */);
        }

        public final /* synthetic */ <T extends MutableTreeNode> void addDoubleClickHandler(Tree tree, Function1<? super T, Unit> clickHandler) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter(clickHandler, (String)"clickHandler");
            boolean $i$f$addDoubleClickHandler = false;
            Companion companion = this;
            int count$iv = 2;
            boolean $i$f$addClickHandler = false;
            Intrinsics.needClassReification();
            tree.addMouseListener((MouseListener)new MouseAdapter(count$iv, tree, clickHandler){
                final /* synthetic */ int $count;
                final /* synthetic */ Tree $tree;
                final /* synthetic */ Function1 $clickHandler;
                {
                    this.$count = $count;
                    this.$tree = $tree;
                    this.$clickHandler = $clickHandler;
                }

                public void mouseClicked(MouseEvent e) {
                    TreePath path;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if ((e.getClickCount() == this.$count || this.$count == 0) && (path = this.$tree.getPathForLocation(e.getX(), e.getY())) != null) {
                        Object node = path.getLastPathComponent();
                        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
                        if (node instanceof MutableTreeNode) {
                            this.$clickHandler.invoke(node);
                        }
                    }
                }
            });
        }

        public final /* synthetic */ <T extends JComponent> void onMouseClicked(T comp, Function2<? super T, ? super MouseEvent, Unit> handler) {
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            boolean $i$f$onMouseClicked = false;
            ((Component)comp).addMouseListener(new MouseAdapter(handler, comp){
                final /* synthetic */ Function2<T, MouseEvent, Unit> $handler;
                final /* synthetic */ T $comp;
                {
                    this.$handler = $handler;
                    this.$comp = $comp;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$handler.invoke(this.$comp, (Object)e);
                }
            });
        }

        public final /* synthetic */ <T extends JComponent> void onMouseDoubleClicked(T comp, Function2<? super T, ? super MouseEvent, Unit> handler) {
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            boolean $i$f$onMouseDoubleClicked = false;
            ((Component)comp).addMouseListener(new MouseAdapter(handler, comp){
                final /* synthetic */ Function2<T, MouseEvent, Unit> $handler;
                final /* synthetic */ T $comp;
                {
                    this.$handler = $handler;
                    this.$comp = $comp;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getClickCount() == 2) {
                        this.$handler.invoke(this.$comp, (Object)e);
                    }
                }
            });
        }

        public final /* synthetic */ <T extends JComponent> void onFocusGained(T comp, Function2<? super T, ? super FocusEvent, Unit> handler) {
            Intrinsics.checkNotNullParameter(comp, (String)"comp");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            boolean $i$f$onFocusGained = false;
            ((Component)comp).addFocusListener(new FocusAdapter(handler, comp){
                final /* synthetic */ Function2<T, FocusEvent, Unit> $handler;
                final /* synthetic */ T $comp;
                {
                    this.$handler = $handler;
                    this.$comp = $comp;
                }

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$handler.invoke(this.$comp, (Object)e);
                }
            });
        }

        @NotNull
        public final JBScrollPane verticalScrollPane(@NotNull Component c) {
            JBScrollPane jBScrollPane;
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            JBScrollPane $this$verticalScrollPane_u24lambda_u249 = jBScrollPane = new JBScrollPane((Component)new VerticalScrollPanelWrapper(c), 20, 31);
            boolean bl = false;
            $this$verticalScrollPane_u24lambda_u249.setBorder(BorderFactory.createEmptyBorder());
            $this$verticalScrollPane_u24lambda_u249.getViewport().setBackground(Companion.getUsualBackgroundColor());
            return jBScrollPane;
        }

        public final void overrideKeyStroke(@NotNull JComponent c, @NotNull String stroke, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            this.overrideKeyStroke(c, stroke, stroke, action2);
        }

        public final void overrideKeyStroke(@NotNull JComponent c, @NotNull String key, @NotNull String stroke, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            InputMap inputMap = c.getInputMap(0);
            inputMap.put(KeyStroke.getKeyStroke(stroke), key);
            c.getActionMap().put(key, new AbstractAction(action2){
                final /* synthetic */ Function0<Unit> $action;
                {
                    this.$action = $action;
                }

                public void actionPerformed(ActionEvent arg) {
                    Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
                    this.$action.invoke();
                }
            });
        }

        public final <E> void addKeyboardPopupHandler(@NotNull JBList<E> list2, @NotNull String stroke, @NotNull Function1<? super List<? extends E>, ? extends JPopupMenu> createPopup2) {
            Intrinsics.checkNotNullParameter(list2, (String)"list");
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            Intrinsics.checkNotNullParameter(createPopup2, (String)"createPopup");
            Function0 action2 = () -> Companion.addKeyboardPopupHandler$lambda$11(list2, createPopup2);
            this.overrideKeyStroke((JComponent)list2, "jlist:" + stroke, stroke, (Function0<Unit>)action2);
        }

        public final void updateScroller(@NotNull JComponent comp) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                JScrollPane scrollPane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)comp);
                if (scrollPane == null) break block1;
                scrollPane.revalidate();
                scrollPane.repaint();
                Container container = scrollPane.getParent();
                if (container != null) {
                    Container container2;
                    Container $this$updateScroller_u24lambda_u2412 = container2 = container;
                    boolean bl = false;
                    $this$updateScroller_u24lambda_u2412.revalidate();
                    $this$updateScroller_u24lambda_u2412.repaint();
                }
            }
        }

        @Nullable
        public final Icon combineIcons(@Nullable Icon icon1, @Nullable Icon icon2, boolean horizontal) {
            if (icon1 == null && icon2 == null) {
                return null;
            }
            if (icon1 == null || icon2 == null) {
                Icon icon = icon1;
                if (icon == null) {
                    icon = icon2;
                }
                return icon;
            }
            if (horizontal) {
                Icon[] iconArray = new Icon[]{icon1, icon2};
                return (Icon)new RowIcon(iconArray);
            }
            return new CompositeIcon(icon1, icon2, horizontal);
        }

        private static final void menuItem$lambda$3$lambda$2(Function0 $handler, ActionEvent it) {
            $handler.invoke();
        }

        private static final void menuItem$lambda$5$lambda$4(Function0 $handler, ActionEvent it) {
            $handler.invoke();
        }

        private static final void addKeyboardPopupHandler$lambda$11$lambda$10(JPopupMenu $popup) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = new MenuElement[2];
            menuElementArray[0] = $popup;
            MenuElement[] menuElementArray2 = $popup.getSubElements();
            Intrinsics.checkNotNullExpressionValue((Object)menuElementArray2, (String)"getSubElements(...)");
            menuElementArray[1] = ArraysKt.first((Object[])menuElementArray2);
            menuSelectionManager.setSelectedPath(menuElementArray);
        }

        private static final Unit addKeyboardPopupHandler$lambda$11(JBList $list, Function1 $createPopup) {
            if ($list.getSelectedIndex() >= 0) {
                List list2 = $list.getSelectedValuesList();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSelectedValuesList(...)");
                JPopupMenu popup = (JPopupMenu)$createPopup.invoke((Object)list2);
                if (popup != null) {
                    MenuElement[] menuElementArray = popup.getSubElements();
                    Intrinsics.checkNotNullExpressionValue((Object)menuElementArray, (String)"getSubElements(...)");
                    if (ArraysKt.any((Object[])menuElementArray)) {
                        Point point = JBPopupFactory.getInstance().guessBestPopupLocation((JComponent)$list).getPoint((Component)$list);
                        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                        Point location = point;
                        popup.show((Component)$list, location.x, location.y);
                        ApplicationKt.getApplication().invokeLater(() -> Companion.addKeyboardPopupHandler$lambda$11$lambda$10(popup));
                    }
                }
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$CompositeIcon;", "Ljavax/swing/Icon;", "icon1", "icon2", "horizontal", "", "<init>", "(Ljavax/swing/Icon;Ljavax/swing/Icon;Z)V", "getIcon1", "()Ljavax/swing/Icon;", "getIcon2", "getHorizontal", "()Z", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "intellij.rider.rdclient.dotnet"})
    private static final class CompositeIcon
    implements Icon {
        @NotNull
        private final Icon icon1;
        @NotNull
        private final Icon icon2;
        private final boolean horizontal;

        public CompositeIcon(@NotNull Icon icon1, @NotNull Icon icon2, boolean horizontal) {
            Intrinsics.checkNotNullParameter((Object)icon1, (String)"icon1");
            Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon2");
            this.icon1 = icon1;
            this.icon2 = icon2;
            this.horizontal = horizontal;
        }

        @NotNull
        public final Icon getIcon1() {
            return this.icon1;
        }

        @NotNull
        public final Icon getIcon2() {
            return this.icon2;
        }

        public final boolean getHorizontal() {
            return this.horizontal;
        }

        @Override
        public void paintIcon(@Nullable Component c, @Nullable Graphics g, int x, int y) {
            this.icon1.paintIcon(c, g, x, y);
            if (this.horizontal) {
                this.icon2.paintIcon(c, g, x + this.icon1.getIconWidth(), y);
            } else {
                this.icon2.paintIcon(c, g, x, y + this.icon2.getIconWidth());
            }
        }

        @Override
        public int getIconWidth() {
            return this.horizontal ? this.icon1.getIconWidth() + this.icon2.getIconWidth() : Math.max(this.icon1.getIconWidth(), this.icon2.getIconWidth());
        }

        @Override
        public int getIconHeight() {
            return this.horizontal ? Math.max(this.icon1.getIconHeight(), this.icon2.getIconHeight()) : this.icon1.getIconHeight() + this.icon2.getIconHeight();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0016\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J \u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\r\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$VerticalScrollPanelWrapper;", "Ljavax/swing/JPanel;", "Ljavax/swing/Scrollable;", "content", "Ljava/awt/Component;", "<init>", "(Ljava/awt/Component;)V", "getPreferredScrollableViewportSize", "Ljava/awt/Dimension;", "kotlin.jvm.PlatformType", "()Ljava/awt/Dimension;", "getScrollableUnitIncrement", "", "visibleRect", "Ljava/awt/Rectangle;", "orientation", "direction", "getScrollableBlockIncrement", "getScrollableTracksViewportWidth", "", "getScrollableTracksViewportHeight", "getBackground", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider.rdclient.dotnet"})
    private static final class VerticalScrollPanelWrapper
    extends JPanel
    implements Scrollable {
        public VerticalScrollPanelWrapper(@NotNull Component content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.setLayout(new BoxLayout(this, 1));
            this.add(content);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
            Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(@NotNull Rectangle visibleRect, int orientation, int direction) {
            Intrinsics.checkNotNullParameter((Object)visibleRect, (String)"visibleRect");
            return 100;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        @NotNull
        public Color getBackground() {
            return Companion.getUsualBackgroundColor();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$VsPalette;", "", "<init>", "()V", "Companion", "intellij.rider.rdclient.dotnet"})
    public static final class VsPalette {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final RiderColor default = new RiderColor(0x323232, 0xC4C4C4);
        @NotNull
        private static final RiderColor statusBlue = new RiderColor(1810914, 2861800);
        @NotNull
        private static final RiderColor modifierBlue = new RiderColor(21404, 8175359);
        @NotNull
        private static final RiderColor modifierGreen = new RiderColor(3705396, 9293709);
        @NotNull
        private static final RiderColor modifierRed = new RiderColor(10561037, 15893350);
        @NotNull
        private static final RiderColor custom03 = new RiderColor(6565517, 11698387);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/ui/RiderUI$VsPalette$Companion;", "", "<init>", "()V", "default", "Lcom/jetbrains/rider/ui/RiderColor;", "getDefault", "()Lcom/jetbrains/rider/ui/RiderColor;", "statusBlue", "getStatusBlue", "modifierBlue", "getModifierBlue", "modifierGreen", "getModifierGreen", "modifierRed", "getModifierRed", "custom03", "getCustom03", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final RiderColor getDefault() {
                return default;
            }

            @NotNull
            public final RiderColor getStatusBlue() {
                return statusBlue;
            }

            @NotNull
            public final RiderColor getModifierBlue() {
                return modifierBlue;
            }

            @NotNull
            public final RiderColor getModifierGreen() {
                return modifierGreen;
            }

            @NotNull
            public final RiderColor getModifierRed() {
                return modifierRed;
            }

            @NotNull
            public final RiderColor getCustom03() {
                return custom03;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

