/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.spellChecker.RiderFrontendInspectionTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002!\"B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fJ\u001b\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0016\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService;", "TTarget", "Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myPerDocumentServices", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Document;", "Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets;", "myPerDocumentAlarms", "Lcom/intellij/util/SingleAlarm;", "myLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "startForDocument", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "addOrUpdate", "range", "(Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;)V", "remove", "id", "", "scheduleDaemonRestart", "getTargets", "", "Lcom/intellij/openapi/util/TextRange;", "DocumentTargets", "Point", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderFrontendInspectionTargetsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n24#2:203\n72#3,2:204\n72#3,2:207\n1#4:206\n1#4:209\n*S KotlinDebug\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService\n*L\n100#1:203\n103#1:204,2\n125#1:207,2\n103#1:206\n125#1:209\n*E\n"})
public abstract class RiderFrontendInspectionTargetsService<TTarget extends RiderFrontendInspectionTarget>
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentMap<Document, DocumentTargets<TTarget>> myPerDocumentServices;
    @NotNull
    private final ConcurrentMap<Document, SingleAlarm> myPerDocumentAlarms;
    @NotNull
    private final Logger myLogger;

    public RiderFrontendInspectionTargetsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myPerDocumentServices = new ConcurrentHashMap();
        this.myPerDocumentAlarms = new ConcurrentHashMap();
        RiderFrontendInspectionTargetsService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(RiderFrontendInspectionTargetsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.myLogger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void startForDocument(@NotNull Lifetime lifetime, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        ConcurrentMap<Document, DocumentTargets<TTarget>> $this$getOrPut$iv = this.myPerDocumentServices;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(document);
        if (object == null) {
            boolean bl = false;
            lifetime.onTermination(() -> RiderFrontendInspectionTargetsService.startForDocument$lambda$1$lambda$0(this, document));
            DocumentTargets default$iv = new DocumentTargets(lifetime);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(document, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
    }

    public final void addOrUpdate(@NotNull Document document, @NotNull TTarget range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        DocumentTargets documentTargets = (DocumentTargets)this.myPerDocumentServices.get(document);
        if (documentTargets == null) {
            return;
        }
        DocumentTargets service = documentTargets;
        service.add(range);
        this.scheduleDaemonRestart(document, service.getLifetime());
    }

    public final void remove(@NotNull Document document, long id) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        DocumentTargets documentTargets = (DocumentTargets)this.myPerDocumentServices.get(document);
        if (documentTargets == null) {
            return;
        }
        DocumentTargets service = documentTargets;
        service.remove(id);
        this.scheduleDaemonRestart(document, service.getLifetime());
    }

    private final void scheduleDaemonRestart(Document document, Lifetime lifetime) {
        this.myLogger.trace("Scheduling restart");
        ConcurrentMap<Document, SingleAlarm> $this$getOrPut$iv = this.myPerDocumentAlarms;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(document);
        if (object == null) {
            boolean bl = false;
            SingleAlarm.Companion companion = SingleAlarm.Companion;
            Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
            SingleAlarm default$iv = companion.pooledThreadSingleAlarm(500, disposable, () -> RiderFrontendInspectionTargetsService.scheduleDaemonRestart$lambda$4$lambda$3(this, document));
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(document, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        SingleAlarm.cancelAndRequest$default((SingleAlarm)((SingleAlarm)object), (boolean)false, (int)1, null);
    }

    @Nullable
    public final List<TTarget> getTargets(@NotNull Document document, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if ((SingleAlarm)this.myPerDocumentAlarms.get(document) == null) {
            return null;
        }
        DocumentTargets documentTargets = (DocumentTargets)this.myPerDocumentServices.get(document);
        return documentTargets != null ? documentTargets.getAtRange(range) : null;
    }

    private static final Unit startForDocument$lambda$1$lambda$0(RiderFrontendInspectionTargetsService this$0, Document $document) {
        this$0.myPerDocumentServices.remove($document);
        return Unit.INSTANCE;
    }

    private static final void scheduleDaemonRestart$lambda$4$lambda$3$lambda$2(RiderFrontendInspectionTargetsService this$0, Document $document) {
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this$0.project);
        PsiFile psiFile = psiDocumentManager.getPsiFile($document);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        this$0.myLogger.trace("Restarting daemon");
        DaemonCodeAnalyzer.getInstance((Project)this$0.project).restart(psiFile2);
        this$0.myLogger.trace("Daemon restarted");
    }

    private static final Unit scheduleDaemonRestart$lambda$4$lambda$3(RiderFrontendInspectionTargetsService this$0, Document $document) {
        ApplicationKt.getApplication().runReadAction(() -> RiderFrontendInspectionTargetsService.scheduleDaemonRestart$lambda$4$lambda$3$lambda$2(this$0, $document));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u0013\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets;", "TTarget", "Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "idToTarget", "Ljava/util/concurrent/ConcurrentMap;", "", "lock", "targetsSet", "Ljava/util/TreeSet;", "Lcom/intellij/openapi/util/Segment;", "remove", "", "id", "add", "target", "(Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTarget;)V", "getAtRange", "", "range", "Lcom/intellij/openapi/util/TextRange;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderFrontendInspectionTargetsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1557#2:203\n1628#2,3:204\n*S KotlinDebug\n*F\n+ 1 RiderFrontendInspectionTargetsService.kt\ncom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$DocumentTargets\n*L\n191#1:203\n191#1:204,3\n*E\n"})
    private static final class DocumentTargets<TTarget extends RiderFrontendInspectionTarget> {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final ConcurrentMap<Long, TTarget> idToTarget;
        @NotNull
        private final Object lock;
        @NotNull
        private final TreeSet<Segment> targetsSet;

        public DocumentTargets(@NotNull Lifetime lifetime) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            this.lifetime = lifetime;
            this.idToTarget = new ConcurrentHashMap();
            this.lock = new Object();
            this.targetsSet = new TreeSet((arg_0, arg_1) -> DocumentTargets.targetsSet$lambda$1(DocumentTargets::targetsSet$lambda$0, arg_0, arg_1));
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void remove(long id) {
            RiderFrontendInspectionTarget value = (RiderFrontendInspectionTarget)this.idToTarget.remove(id);
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (value != null) {
                    this.targetsSet.remove(value);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void add(@NotNull TTarget target) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            RiderFrontendInspectionTarget replacedValue = (RiderFrontendInspectionTarget)this.idToTarget.put(((RiderFrontendInspectionTarget)target).getId(), target);
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (replacedValue != null) {
                    this.targetsSet.remove(replacedValue);
                }
                boolean bl2 = this.targetsSet.add((Segment)target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<TTarget> getAtRange(@NotNull TextRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            List result2 = new ArrayList();
            Object object = this.lock;
            synchronized (object) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Segment segment;
                boolean bl = false;
                Iterator<Segment> iterator2 = this.targetsSet.subSet(new Point(0), true, new Point(range.getStartOffset()), false).descendingIterator();
                Intrinsics.checkNotNullExpressionValue(iterator2, (String)"descendingIterator(...)");
                Object object2 = iterator2;
                while (object2.hasNext() && range.intersects(segment = object2.next())) {
                    Intrinsics.checkNotNull((Object)segment, (String)"null cannot be cast to non-null type TTarget of com.jetbrains.rider.spellChecker.RiderFrontendInspectionTargetsService.DocumentTargets");
                    result2.add((RiderFrontendInspectionTarget)segment);
                }
                NavigableSet<Segment> navigableSet = this.targetsSet.subSet(new Point(range.getStartOffset()), true, new Point(range.getEndOffset()), false);
                Intrinsics.checkNotNullExpressionValue(navigableSet, (String)"subSet(...)");
                object2 = navigableSet;
                List list2 = result2;
                boolean $i$f$map = false;
                void var8_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Segment segment2 = (Segment)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type TTarget of com.jetbrains.rider.spellChecker.RiderFrontendInspectionTargetsService.DocumentTargets");
                    collection.add((RiderFrontendInspectionTarget)it);
                }
                boolean bl3 = list2.addAll((List)destination$iv$iv);
            }
            return result2;
        }

        private static final int targetsSet$lambda$0(Segment a, Segment b) {
            return a.getStartOffset() != b.getStartOffset() ? Intrinsics.compare((int)a.getStartOffset(), (int)b.getStartOffset()) : (a.getEndOffset() != b.getEndOffset() ? Intrinsics.compare((int)a.getEndOffset(), (int)b.getEndOffset()) : (a instanceof RiderFrontendInspectionTarget && b instanceof RiderFrontendInspectionTarget ? Intrinsics.compare((long)((RiderFrontendInspectionTarget)a).getId(), (long)((RiderFrontendInspectionTarget)b).getId()) : 0));
        }

        private static final int targetsSet$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/spellChecker/RiderFrontendInspectionTargetsService$Point;", "Lcom/intellij/openapi/util/Segment;", "from", "", "<init>", "(I)V", "getFrom", "()I", "getStartOffset", "getEndOffset", "intellij.rider.rdclient.dotnet"})
    private static final class Point
    implements Segment {
        private final int from;

        public Point(int from) {
            this.from = from;
        }

        public final int getFrom() {
            return this.from;
        }

        public int getStartOffset() {
            return this.from;
        }

        public int getEndOffset() {
            return this.from;
        }
    }
}

