/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.spellChecker;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.Consumer;
import com.jetbrains.rider.model.SpellCheckerTargetType;
import com.jetbrains.rider.spellChecker.RiderSpellCheckingTarget;
import com.jetbrains.rider.spellChecker.RiderSpellCheckingTargetsService;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016J$\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J#\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy;", "Lcom/intellij/spellchecker/tokenizer/SuppressibleSpellcheckingStrategy;", "Lcom/intellij/openapi/project/DumbAware;", "language", "Lcom/intellij/lang/Language;", "<init>", "(Lcom/intellij/lang/Language;)V", "elementFitsScope", "", "element", "Lcom/intellij/psi/PsiElement;", "scope", "", "Lcom/intellij/spellchecker/inspections/SpellCheckingInspection$SpellCheckingScope;", "getTokenizer", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "", "isSuppressedFor", "name", "", "getSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "TargetsDrivenTokenizer", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nBackendLanguageSpellcheckingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLanguageSpellcheckingStrategy.kt\ncom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,86:1\n31#2,2:87\n*S KotlinDebug\n*F\n+ 1 BackendLanguageSpellcheckingStrategy.kt\ncom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy\n*L\n34#1:87,2\n*E\n"})
public abstract class BackendLanguageSpellcheckingStrategy
extends SuppressibleSpellcheckingStrategy
implements DumbAware {
    @NotNull
    private final Language language;

    public BackendLanguageSpellcheckingStrategy(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        this.language = language;
    }

    public boolean elementFitsScope(@NotNull PsiElement element, @Nullable Set<SpellCheckingInspection.SpellCheckingScope> scope) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    @NotNull
    public Tokenizer<?> getTokenizer(@Nullable PsiElement element, @NotNull Set<? extends SpellCheckingInspection.SpellCheckingScope> scope) {
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        if (element == null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        if (element.getFirstChild() != null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(element.getContainingFile());
        if (document == null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        Document document2 = document;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<RiderSpellCheckingTargetsService> serviceClass$iv = RiderSpellCheckingTargetsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RiderSpellCheckingTargetsService service = (RiderSpellCheckingTargetsService)((Object)object);
        TextRange textRange = element.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        List<RiderSpellCheckingTarget> list2 = service.getTargets(document2, textRange);
        if (list2 == null) {
            Tokenizer tokenizer = SuppressibleSpellcheckingStrategy.EMPTY_TOKENIZER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"EMPTY_TOKENIZER");
            return tokenizer;
        }
        List<RiderSpellCheckingTarget> targets = list2;
        return new TargetsDrivenTokenizer(targets, scope);
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@NotNull PsiElement element, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(this.language);
        if (suppressor != null) {
            SuppressQuickFix[] suppressQuickFixArray = suppressor.getSuppressActions(element, name);
            Intrinsics.checkNotNullExpressionValue((Object)suppressQuickFixArray, (String)"getSuppressActions(...)");
            return suppressQuickFixArray;
        }
        return new SuppressQuickFix[0];
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer;", "Lcom/intellij/spellchecker/tokenizer/Tokenizer;", "Lcom/intellij/psi/PsiElement;", "targets", "", "Lcom/jetbrains/rider/spellChecker/RiderSpellCheckingTarget;", "scope", "", "Lcom/intellij/spellchecker/inspections/SpellCheckingInspection$SpellCheckingScope;", "<init>", "(Ljava/util/List;Ljava/util/Set;)V", "tokenize", "", "element", "consumer", "Lcom/intellij/spellchecker/tokenizer/TokenConsumer;", "getHighlightingRange", "Lcom/intellij/openapi/util/TextRange;", "offset", "", "textRange", "DummySplitter", "intellij.rider.rdclient.dotnet"})
    public static final class TargetsDrivenTokenizer
    extends Tokenizer<PsiElement> {
        @NotNull
        private final List<RiderSpellCheckingTarget> targets;
        @NotNull
        private final Set<SpellCheckingInspection.SpellCheckingScope> scope;

        public TargetsDrivenTokenizer(@NotNull List<RiderSpellCheckingTarget> targets, @NotNull Set<? extends SpellCheckingInspection.SpellCheckingScope> scope) {
            Intrinsics.checkNotNullParameter(targets, (String)"targets");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            this.targets = targets;
            this.scope = scope;
        }

        public void tokenize(@NotNull PsiElement element, @NotNull TokenConsumer consumer2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)consumer2, (String)"consumer");
            String text = element.getText();
            TextRange elementRange = element.getTextRange();
            for (RiderSpellCheckingTarget target : this.targets) {
                if (target.getTargetType() == SpellCheckerTargetType.IDENTIFIER && !this.scope.contains(SpellCheckingInspection.SpellCheckingScope.Code) || target.getTargetType() == SpellCheckerTargetType.LITERAL && !this.scope.contains(SpellCheckingInspection.SpellCheckingScope.Literals) || target.getTargetType() == SpellCheckerTargetType.COMMENT && !this.scope.contains(SpellCheckingInspection.SpellCheckingScope.Comments)) continue;
                for (RangeMarker wordRangeMarker : target.getWordsRangeMarkers()) {
                    TextRange wordRangeInElement;
                    TextRange wordRange;
                    if (RangeMarkersKt.getAsTextRange((RangeMarker)wordRangeMarker) == null || !elementRange.contains(wordRange)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)wordRange.shiftLeft(PsiTreeUtilKt.getStartOffset((PsiElement)element)), (String)"shiftLeft(...)");
                    consumer2.consumeToken(element, text, target.getTargetType() == SpellCheckerTargetType.IDENTIFIER, 0, wordRangeInElement, (Splitter)DummySplitter.Companion.getINSTANCE());
                }
            }
        }

        @NotNull
        public TextRange getHighlightingRange(@Nullable PsiElement element, int offset, @Nullable TextRange textRange) {
            TextRange textRange2 = super.getHighlightingRange(element, offset, textRange);
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getHighlightingRange(...)");
            return textRange2;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter;", "Lcom/intellij/spellchecker/inspections/Splitter;", "<init>", "()V", "split", "", "text", "", "range", "Lcom/intellij/openapi/util/TextRange;", "consumer", "Lcom/intellij/util/Consumer;", "Companion", "intellij.rider.rdclient.dotnet"})
        public static final class DummySplitter
        implements Splitter {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private static final DummySplitter INSTANCE = new DummySplitter();

            public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer2) {
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
                consumer2.consume((Object)range);
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter;", "getINSTANCE", "()Lcom/jetbrains/rider/spellChecker/BackendLanguageSpellcheckingStrategy$TargetsDrivenTokenizer$DummySplitter;", "intellij.rider.rdclient.dotnet"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final DummySplitter getINSTANCE() {
                    return INSTANCE;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

