/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree.renderers;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.rd.ide.model.CodeStyleBoolOption;
import com.jetbrains.rd.ide.model.CodeStyleEnumOption;
import com.jetbrains.rd.ide.model.CodeStyleFlaggedEnumOption;
import com.jetbrains.rd.ide.model.CodeStyleGroupOption;
import com.jetbrains.rd.ide.model.CodeStyleNumericOption;
import com.jetbrains.rd.ide.model.CodeStyleOptionBase;
import com.jetbrains.rd.ide.model.CodeStyleOrderedCollectionOption;
import com.jetbrains.rd.ide.model.CodeStyleStringOption;
import com.jetbrains.rider.model.EnumWithValue;
import com.jetbrains.rider.settings.tree.CodeStyleTreeNode;
import com.jetbrains.rider.settings.tree.RendererDecorator;
import com.jetbrains.rider.settings.tree.renderers.BoolRenderer;
import com.jetbrains.rider.settings.tree.renderers.CodeStyleOrderedCollectionRenderer;
import com.jetbrains.rider.settings.tree.renderers.Common;
import com.jetbrains.rider.settings.tree.renderers.EnumRenderer;
import com.jetbrains.rider.settings.tree.renderers.FlaggedEnumRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J8\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u00182\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/settings/tree/renderers/NodeValueRenderer;", "Ljavax/swing/table/TableCellRenderer;", "<init>", "()V", "myBoolPresenter", "Lcom/jetbrains/rider/settings/tree/renderers/BoolRenderer;", "myEnumPresenter", "Lcom/jetbrains/rider/settings/tree/renderers/EnumRenderer;", "myFlaggedEnumRenderer", "Lcom/jetbrains/rider/settings/tree/renderers/FlaggedEnumRenderer;", "myNumericLabel", "Ljavax/swing/JLabel;", "myStringLabel", "myOrderedCollectionRenderer", "Lcom/jetbrains/rider/settings/tree/renderers/CodeStyleOrderedCollectionRenderer;", "myEmptyLabel", "Ljavax/swing/JPanel;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "getRendererWithoutBackground", "option", "Lcom/jetbrains/rd/ide/model/CodeStyleOptionBase;", "isEnabled", "isHighlighted", "tooltip", "", "intellij.rider.rdclient.dotnet"})
public final class NodeValueRenderer
implements TableCellRenderer {
    @NotNull
    private final BoolRenderer myBoolPresenter = new BoolRenderer();
    @NotNull
    private final EnumRenderer myEnumPresenter = new EnumRenderer();
    @NotNull
    private final FlaggedEnumRenderer myFlaggedEnumRenderer = new FlaggedEnumRenderer();
    @NotNull
    private final JLabel myNumericLabel = new JLabel();
    @NotNull
    private final JLabel myStringLabel = new JLabel();
    @NotNull
    private final CodeStyleOrderedCollectionRenderer myOrderedCollectionRenderer = new CodeStyleOrderedCollectionRenderer();
    @NotNull
    private final JPanel myEmptyLabel = new JPanel();

    public NodeValueRenderer() {
        RendererDecorator decorator2 = new RendererDecorator();
        decorator2.decorate(this.myNumericLabel);
        this.myNumericLabel.setOpaque(true);
        decorator2.decorate(this.myStringLabel);
        this.myStringLabel.setOpaque(true);
        decorator2.decorate(this.myEmptyLabel);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@Nullable JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isEnabled = true;
        boolean isHighlighted = false;
        String tooltip = null;
        Intrinsics.checkNotNull((Object)table2, (String)"null cannot be cast to non-null type com.intellij.ui.treeStructure.treetable.TreeTable");
        Object object = ((TreeTable)table2).getTree().getPathForRow(row).getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
        CodeStyleOptionBase option = null;
        if (node instanceof CodeStyleTreeNode) {
            isEnabled = ((CodeStyleTreeNode)node).isEnabled();
            option = ((CodeStyleTreeNode)node).getModel();
            isHighlighted = ((CodeStyleTreeNode)node).isHighlighted();
            tooltip = ((CodeStyleTreeNode)node).tooltip();
        }
        if (!((TreeTable)table2).isEnabled()) {
            isEnabled = false;
        }
        Component res = this.getRendererWithoutBackground(option, value, isEnabled, isHighlighted, tooltip);
        if (!isHighlighted) {
            res.setBackground(((TreeTable)table2).getBackground());
        }
        return res;
    }

    private final Component getRendererWithoutBackground(CodeStyleOptionBase option, Object value, boolean isEnabled, boolean isHighlighted, @NlsContexts.Tooltip String tooltip) {
        if (option instanceof CodeStyleBoolOption) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this.myBoolPresenter.reset((Boolean)value, isEnabled, isHighlighted, tooltip);
            return (Component)((Object)this.myBoolPresenter);
        }
        if (option instanceof CodeStyleEnumOption) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.EnumWithValue");
            this.myEnumPresenter.reset(((EnumWithValue)value).getPresentation(), isEnabled, isHighlighted, tooltip);
            return (Component)((Object)this.myEnumPresenter);
        }
        if (option instanceof CodeStyleFlaggedEnumOption) {
            this.myFlaggedEnumRenderer.reset((CodeStyleFlaggedEnumOption)option, isEnabled, isHighlighted, tooltip);
            return (Component)((Object)this.myFlaggedEnumRenderer);
        }
        if (option instanceof CodeStyleNumericOption) {
            this.myNumericLabel.setText(String.valueOf(value));
            this.myNumericLabel.setEnabled(isEnabled);
            if (isHighlighted) {
                this.myNumericLabel.setBackground(Common.Resources.getHighlightedBackgroundColor());
                if (tooltip != null) {
                    this.myNumericLabel.setToolTipText(tooltip);
                }
            }
            return this.myNumericLabel;
        }
        if (option instanceof CodeStyleStringOption) {
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
            this.myStringLabel.setText((String)value);
            this.myStringLabel.setEnabled(isEnabled);
            if (isHighlighted) {
                this.myStringLabel.setBackground(Common.Resources.getHighlightedBackgroundColor());
                if (tooltip != null) {
                    this.myNumericLabel.setToolTipText(tooltip);
                }
            }
            return this.myStringLabel;
        }
        if (option instanceof CodeStyleOrderedCollectionOption) {
            this.myOrderedCollectionRenderer.reset((CodeStyleOrderedCollectionOption)option, isEnabled, isHighlighted, tooltip);
            return (Component)((Object)this.myOrderedCollectionRenderer);
        }
        if (option instanceof CodeStyleGroupOption) {
            return this.myEmptyLabel;
        }
        return this.myEmptyLabel;
    }
}

