/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.tree.editors;

import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.rd.ide.model.CodeStyleNumericOption;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.settings.tree.renderers.Common;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0005J\"\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0001\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/settings/tree/editors/IntOptionEditor;", "Ljavax/swing/JTextField;", "<init>", "()V", "myMinValue", "", "myMaxValue", "presentableValue", "", "getPresentableValue", "()Ljava/lang/Object;", "validateAndGetIntOption", "setMinValue", "", "minValue", "setMaxValue", "maxValue", "reset", "option", "Lcom/jetbrains/rd/ide/model/CodeStyleNumericOption;", "isHighlighted", "", "tooltip", "", "intellij.rider.rdclient.dotnet"})
public final class IntOptionEditor
extends JTextField {
    private int myMinValue;
    private int myMaxValue;

    @NotNull
    public final Object getPresentableValue() {
        return this.validateAndGetIntOption();
    }

    private final int validateAndGetIntOption() {
        try {
            int value = Integer.parseInt(this.getText());
            if (value < this.myMinValue) {
                return this.myMinValue;
            }
            if (value > this.myMaxValue) {
                return this.myMaxValue;
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            return this.myMinValue;
        }
    }

    public final void setMinValue(int minValue) {
        this.myMinValue = minValue;
    }

    public final void setMaxValue(int maxValue) {
        this.myMaxValue = maxValue;
    }

    public final void reset(@NotNull CodeStyleNumericOption option, boolean isHighlighted, @NlsContexts.Tooltip @Nullable String tooltip) {
        Intrinsics.checkNotNullParameter((Object)((Object)option), (String)"option");
        if (isHighlighted) {
            this.setBackground(Common.Resources.getHighlightedBackgroundColor());
        }
        if (tooltip != null) {
            this.setToolTipText(tooltip);
        }
        this.setText(String.valueOf(((Number)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)option.getValue()))).intValue()));
        this.setMinValue(option.getMin());
        this.setMaxValue(option.getMax());
    }
}

