/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.model.NamingStyleKinds;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.naming.MutableNamingRule;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingStyleKindsConverter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/settings/naming/NamingRuleEditor;", "Ljavax/swing/JPanel;", "myConverter", "Lcom/jetbrains/rider/settings/naming/NamingStyleKindsConverter;", "myNamingChangeTracker", "Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;", "<init>", "(Lcom/jetbrains/rider/settings/naming/NamingStyleKindsConverter;Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;)V", "myPrefixTextField", "Ljavax/swing/JTextField;", "mySuffixTextField", "myStyleComboBox", "Ljavax/swing/JComboBox;", "", "setupFromRule", "", "rule", "Lcom/jetbrains/rider/settings/naming/MutableNamingRule;", "handleDataChanged", "setIsEnabled", "value", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNamingRuleEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingRuleEditor.kt\ncom/jetbrains/rider/settings/naming/NamingRuleEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,116:1\n1557#2:117\n1628#2,3:118\n37#3,2:121\n*S KotlinDebug\n*F\n+ 1 NamingRuleEditor.kt\ncom/jetbrains/rider/settings/naming/NamingRuleEditor\n*L\n45#1:117\n45#1:118,3\n47#1:121,2\n*E\n"})
public final class NamingRuleEditor
extends JPanel {
    @NotNull
    private final NamingStyleKindsConverter myConverter;
    @NotNull
    private final NamingChangeTracker myNamingChangeTracker;
    @NotNull
    private final JTextField myPrefixTextField;
    @NotNull
    private JTextField mySuffixTextField;
    @NotNull
    private JComboBox<String> myStyleComboBox;

    /*
     * WARNING - void declaration
     */
    public NamingRuleEditor(@NotNull NamingStyleKindsConverter myConverter, @NotNull NamingChangeTracker myNamingChangeTracker) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        GridBagConstraints gridBagConstraints;
        Intrinsics.checkNotNullParameter((Object)myConverter, (String)"myConverter");
        Intrinsics.checkNotNullParameter((Object)myNamingChangeTracker, (String)"myNamingChangeTracker");
        this.myConverter = myConverter;
        this.myNamingChangeTracker = myNamingChangeTracker;
        this.myPrefixTextField = new JTextField(RiderSettingsBundle.Companion.message("NamingRuleEditor.text.select.a.rule.to.edit", new Object[0]));
        this.mySuffixTextField = new JTextField(RiderSettingsBundle.Companion.message("NamingRuleEditor.text.select.a.rule.to.edit", new Object[0]));
        this.setLayout(new GridBagLayout());
        this.setAlignmentX(0.0f);
        GridBagConstraints $this$_init__u24lambda_u240 = gridBagConstraints = new GridBagConstraints();
        boolean bl = false;
        $this$_init__u24lambda_u240.gridx = 0;
        $this$_init__u24lambda_u240.gridy = 0;
        $this$_init__u24lambda_u240.weightx = 0.0;
        $this$_init__u24lambda_u240.weighty = 0.0;
        $this$_init__u24lambda_u240.anchor = 13;
        $this$_init__u24lambda_u240.fill = 0;
        GridBagConstraints constraints = gridBagConstraints;
        JLabel prefixDescriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("NamingRuleEditor.label.prefix", new Object[0]) + " ");
        JLabel suffixDescriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("NamingRuleEditor.label.suffix", new Object[0]) + " ");
        JLabel styleDescriptionLabel = new JLabel(RiderSettingsBundle.Companion.message("NamingRuleEditor.label.style", new Object[0]) + " ");
        this.add((Component)prefixDescriptionLabel, constraints);
        int n = constraints.gridy;
        constraints.gridy = n + 1;
        this.add((Component)suffixDescriptionLabel, constraints);
        n = constraints.gridy;
        constraints.gridy = n + 1;
        this.add((Component)styleDescriptionLabel, constraints);
        Object object = (Iterable)NamingStyleKinds.getEntries();
        NamingRuleEditor namingRuleEditor = this;
        boolean $i$f$map = false;
        void var9_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NamingStyleKinds namingStyleKinds = (NamingStyleKinds)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.myConverter.convert((NamingStyleKinds)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        namingRuleEditor.myStyleComboBox = (JComboBox)new ComboBox(objectArray);
        this.setBorder((Border)JBUI.Borders.empty());
        Object $this$_init__u24lambda_u242 = object = constraints;
        boolean bl3 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u242).gridy = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u242).gridx = 1;
        ((GridBagConstraints)$this$_init__u24lambda_u242).weightx = 1.0;
        ((GridBagConstraints)$this$_init__u24lambda_u242).fill = 2;
        this.add((Component)this.myPrefixTextField, constraints);
        int n2 = constraints.gridy;
        constraints.gridy = n2 + 1;
        this.add((Component)this.mySuffixTextField, constraints);
        n2 = constraints.gridy;
        constraints.gridy = n2 + 1;
        this.add((Component)this.myStyleComboBox, constraints);
        this.myPrefixTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handleDataChanged();
            }
        });
        this.mySuffixTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.handleDataChanged();
            }
        });
        this.myStyleComboBox.addActionListener(arg_0 -> NamingRuleEditor._init_$lambda$3(this, arg_0));
        this.setIsEnabled(false);
    }

    public final void setupFromRule(@NotNull MutableNamingRule rule) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        if (!Intrinsics.areEqual((Object)this.myPrefixTextField.getText(), (Object)rule.getPrefix())) {
            this.myPrefixTextField.setText(rule.getPrefix());
        }
        if (!Intrinsics.areEqual((Object)this.mySuffixTextField.getText(), (Object)rule.getSuffix())) {
            this.mySuffixTextField.setText(rule.getSuffix());
        }
        String selectedRuleKind = this.myConverter.convert(rule.getKind());
        if (!Intrinsics.areEqual((Object)this.myStyleComboBox.getSelectedItem(), (Object)selectedRuleKind)) {
            this.myStyleComboBox.setSelectedItem(selectedRuleKind);
        }
        this.setIsEnabled(true);
    }

    private final void handleDataChanged() {
        NamingStyleKinds namingStyleKinds;
        if (this.myNamingChangeTracker.isIgnored()) {
            return;
        }
        if (this.myStyleComboBox.getSelectedItem() == null) {
            namingStyleKinds = NamingStyleKinds.AaBb;
        } else {
            Object object = this.myStyleComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object);
            namingStyleKinds = this.myConverter.convertBack(object.toString());
        }
        NamingStyleKinds namingStyleKind = namingStyleKinds;
        Function3<String, String, NamingStyleKinds, Unit> function3 = this.myNamingChangeTracker.getUpdateFromRuleEditor();
        String string = this.myPrefixTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.mySuffixTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        function3.invoke((Object)string, (Object)string2, (Object)namingStyleKind);
    }

    private final void setIsEnabled(boolean value) {
        this.myPrefixTextField.setEnabled(value);
        this.mySuffixTextField.setEnabled(value);
        this.myStyleComboBox.setEnabled(value);
    }

    private static final void _init_$lambda$3(NamingRuleEditor this$0, ActionEvent it) {
        this$0.handleDataChanged();
    }
}

