/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.naming;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ItemRemovable;
import com.jetbrains.rider.model.NamingPolicy;
import com.jetbrains.rider.model.NamingRule;
import com.jetbrains.rider.model.NamingStyleKinds;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.naming.MutableNamingRule;
import com.jetbrains.rider.settings.naming.NamingChangeTracker;
import com.jetbrains.rider.settings.naming.NamingRuleEditor;
import com.jetbrains.rider.settings.naming.NamingStyleKindsConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/settings/naming/NamingPolicyEditor;", "Ljavax/swing/JPanel;", "myNamingChangeTracker", "Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;", "<init>", "(Lcom/jetbrains/rider/settings/naming/NamingChangeTracker;)V", "myInspectionsEnabledCheckBox", "Ljavax/swing/JCheckBox;", "myRules", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/settings/naming/MutableNamingRule;", "Lkotlin/collections/ArrayList;", "myRulesTable", "Lcom/intellij/ui/table/JBTable;", "myRulesTableSelectionModel", "Ljavax/swing/ListSelectionModel;", "createActionWrapper", "table", "changeRules", "", "from", "", "to", "setSelection", "k", "convertToMutable", "rule", "Lcom/jetbrains/rider/model/NamingRule;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nNamingPolicyEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1863#2,2:289\n1872#2,3:291\n*S KotlinDebug\n*F\n+ 1 NamingPolicyEditor.kt\ncom/jetbrains/rider/settings/naming/NamingPolicyEditor\n*L\n178#1:289,2\n188#1:291,3\n*E\n"})
public final class NamingPolicyEditor
extends JPanel {
    @NotNull
    private final NamingChangeTracker myNamingChangeTracker;
    @NotNull
    private final JCheckBox myInspectionsEnabledCheckBox;
    @NotNull
    private final ArrayList<MutableNamingRule> myRules;
    @NotNull
    private final JBTable myRulesTable;
    @NotNull
    private final ListSelectionModel myRulesTableSelectionModel;

    public NamingPolicyEditor(@NotNull NamingChangeTracker myNamingChangeTracker) {
        Intrinsics.checkNotNullParameter((Object)myNamingChangeTracker, (String)"myNamingChangeTracker");
        this.myNamingChangeTracker = myNamingChangeTracker;
        this.myInspectionsEnabledCheckBox = new JCheckBox();
        this.myRules = new ArrayList();
        NamingStyleKindsConverter styleConverter = new NamingStyleKindsConverter();
        NamingRuleEditor namingRuleEditor = new NamingRuleEditor(styleConverter, this.myNamingChangeTracker);
        this.setLayout(new BorderLayout());
        JPanel panelInspections = new JPanel();
        panelInspections.setLayout(new FlowLayout(0));
        this.myInspectionsEnabledCheckBox.setText(RiderSettingsBundle.Companion.message("NamingPolicyEditor.checkbox.enable.inspection", new Object[0]));
        this.myInspectionsEnabledCheckBox.setAlignmentX(0.0f);
        panelInspections.setAlignmentX(0.0f);
        panelInspections.add(this.myInspectionsEnabledCheckBox);
        this.add((Component)panelInspections, "Last");
        ItemRemovable model2 = new ItemRemovable(this, styleConverter){
            final /* synthetic */ NamingPolicyEditor this$0;
            final /* synthetic */ NamingStyleKindsConverter $styleConverter;
            {
                this.this$0 = $receiver;
                this.$styleConverter = $styleConverter;
            }

            public String getColumnName(int column) {
                return RiderSettingsBundle.Companion.message("NamingRulesTableModel.column.name.rules", new Object[0]);
            }

            public Class<String> getColumnClass(int column) {
                return String.class;
            }

            public int getColumnCount() {
                return 1;
            }

            public int getRowCount() {
                return NamingPolicyEditor.access$getMyRules$p(this.this$0).size();
            }

            public Object getValueAt(int row, int column) {
                E e = NamingPolicyEditor.access$getMyRules$p(this.this$0).get(row);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                MutableNamingRule pattern = (MutableNamingRule)e;
                String kind = this.$styleConverter.convert(pattern.getKind());
                Object rulePresentation = pattern.getPrefix() + kind + pattern.getSuffix();
                if (row == 0) {
                    Object[] objectArray = new Object[]{rulePresentation};
                    rulePresentation = RiderSettingsBundle.Companion.message("NamingRulesTableModel.default.wrapper.for.naming.rule", objectArray);
                }
                return rulePresentation;
            }

            public void removeRow(int index) {
                NamingPolicyEditor.access$getMyRules$p(this.this$0).remove(index);
                this.fireTableRowsDeleted(index, index);
            }
        };
        this.myRulesTable = new JBTable((TableModel)model2);
        this.myRulesTableSelectionModel = this.myRulesTable.getSelectionModel();
        this.myRulesTableSelectionModel.setSelectionMode(0);
        this.myRulesTableSelectionModel.addListSelectionListener(arg_0 -> NamingPolicyEditor._init_$lambda$1(this, namingRuleEditor, arg_0));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.add((Component)namingRuleEditor, "Last");
        innerPanel.add(this.createActionWrapper(this.myRulesTable));
        this.add(innerPanel);
        this.myInspectionsEnabledCheckBox.addActionListener(arg_0 -> NamingPolicyEditor._init_$lambda$2(this, arg_0));
        this.myInspectionsEnabledCheckBox.setEnabled(false);
        this.myNamingChangeTracker.setUpdateToPolicyEditor((Function1<? super NamingPolicy, Unit>)((Function1)arg_0 -> NamingPolicyEditor._init_$lambda$4(this, arg_0)));
        this.myNamingChangeTracker.setUpdateFromPolicyEditor((Function0<NamingPolicy>)((Function0)() -> NamingPolicyEditor._init_$lambda$6(this)));
        this.myNamingChangeTracker.setUpdateFromRuleEditor((Function3<? super String, ? super String, ? super NamingStyleKinds, Unit>)((Function3)(arg_0, arg_1, arg_2) -> NamingPolicyEditor._init_$lambda$7(this, arg_0, arg_1, arg_2)));
    }

    private final JPanel createActionWrapper(JBTable table2) {
        AnActionButtonRunnable addRuleAction = arg_0 -> NamingPolicyEditor.createActionWrapper$lambda$9(this, arg_0);
        AnActionButtonRunnable removeRuleAction = arg_0 -> NamingPolicyEditor.createActionWrapper$lambda$11(this, arg_0);
        AnActionButtonRunnable moveUpRuleAction = arg_0 -> NamingPolicyEditor.createActionWrapper$lambda$12(this, arg_0);
        AnActionButtonRunnable moveDownRuleAction = arg_0 -> NamingPolicyEditor.createActionWrapper$lambda$13(this, arg_0);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)table2)).setAddAction(addRuleAction).setAddActionUpdater(arg_0 -> NamingPolicyEditor.createActionWrapper$lambda$14(this, arg_0)).setRemoveAction(removeRuleAction).setRemoveActionUpdater(arg_0 -> NamingPolicyEditor.createActionWrapper$lambda$15(this, arg_0)).setMoveUpAction(moveUpRuleAction).setMoveDownAction(moveDownRuleAction).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final void changeRules(int from, int to) {
        this.myNamingChangeTracker.runWithoutChanges((Function0<Unit>)((Function0)() -> NamingPolicyEditor.changeRules$lambda$16(this, from, to)));
        this.myNamingChangeTracker.policyChangedInPolicyEditor();
    }

    private final void setSelection(int k) {
        this.myRulesTableSelectionModel.setSelectionInterval(k, k);
    }

    private final MutableNamingRule convertToMutable(NamingRule rule) {
        return new MutableNamingRule(rule.getKind(), rule.getPrefix(), rule.getSuffix());
    }

    private static final Unit lambda$1$lambda$0(NamingRuleEditor $namingRuleEditor, NamingPolicyEditor this$0, int $selectedIndex) {
        MutableNamingRule mutableNamingRule = this$0.myRules.get($selectedIndex);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
        $namingRuleEditor.setupFromRule(mutableNamingRule);
        TableUtil.updateScroller((JTable)((JTable)this$0.myRulesTable));
        TableUtil.scrollSelectionToVisible((JTable)((JTable)this$0.myRulesTable));
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(NamingPolicyEditor this$0, NamingRuleEditor $namingRuleEditor, ListSelectionEvent it) {
        int selectedIndex = this$0.myRulesTable.getSelectedRow();
        if (selectedIndex >= 0) {
            this$0.myNamingChangeTracker.runWithoutChanges((Function0<Unit>)((Function0)() -> NamingPolicyEditor.lambda$1$lambda$0($namingRuleEditor, this$0, selectedIndex)));
        }
    }

    private static final void _init_$lambda$2(NamingPolicyEditor this$0, ActionEvent it) {
        this$0.myNamingChangeTracker.policyChangedInPolicyEditor();
    }

    private static final Unit _init_$lambda$4(NamingPolicyEditor this$0, NamingPolicy namingPolicy) {
        if (namingPolicy != null) {
            int selectedRow = this$0.myRulesTable.getSelectedRow();
            this$0.myRulesTableSelectionModel.clearSelection();
            this$0.myInspectionsEnabledCheckBox.setSelected(namingPolicy.getEnableInspection());
            this$0.myRules.clear();
            this$0.myRules.add(this$0.convertToMutable(namingPolicy.getRule()));
            Iterable $this$forEach$iv = namingPolicy.getExtraRules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NamingRule it = (NamingRule)element$iv;
                boolean bl = false;
                this$0.myRules.add(this$0.convertToMutable(it));
            }
            this$0.setSelection(RangesKt.coerceIn((int)selectedRow, (int)0, (int)(((Collection)this$0.myRules).size() - 1)));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final NamingPolicy _init_$lambda$6(NamingPolicyEditor this$0) {
        boolean enableInspection = this$0.myInspectionsEnabledCheckBox.isSelected();
        ArrayList<NamingRule> extraRules = new ArrayList<NamingRule>();
        NamingRule mainRule = null;
        Iterable $this$forEachIndexed$iv = this$0.myRules;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MutableNamingRule mutableNamingRule = (MutableNamingRule)item$iv;
            int i = n;
            boolean bl = false;
            NamingRule rule = new NamingRule(it.getKind(), it.getPrefix(), it.getSuffix());
            if (i == 0) {
                mainRule = rule;
                continue;
            }
            extraRules.add(rule);
        }
        NamingRule namingRule = mainRule;
        Intrinsics.checkNotNull(namingRule);
        return new NamingPolicy(namingRule, (List<NamingRule>)extraRules, enableInspection);
    }

    private static final Unit _init_$lambda$7(NamingPolicyEditor this$0, String prefix, String suffix, NamingStyleKinds kind) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        int selectedRow = this$0.myRulesTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < ((Collection)this$0.myRules).size()) {
            MutableNamingRule mutableNamingRule = this$0.myRules.get(selectedRow);
            Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
            MutableNamingRule rule = mutableNamingRule;
            rule.setPrefix(prefix);
            rule.setSuffix(suffix);
            rule.setKind(kind);
            this$0.myNamingChangeTracker.policyChangedInPolicyEditor();
        }
        return Unit.INSTANCE;
    }

    private static final Unit createActionWrapper$lambda$9$lambda$8(NamingPolicyEditor this$0, Ref.IntRef $selectedRaw) {
        this$0.myRulesTableSelectionModel.clearSelection();
        MutableNamingRule newRule = new MutableNamingRule(NamingStyleKinds.AaBb, "", "");
        this$0.myRules.add(newRule);
        $selectedRaw.element = ((Collection)this$0.myRules).size() - 1;
        this$0.setSelection($selectedRaw.element);
        return Unit.INSTANCE;
    }

    private static final void createActionWrapper$lambda$9(NamingPolicyEditor this$0, AnActionButton it) {
        Ref.IntRef selectedRaw = new Ref.IntRef();
        selectedRaw.element = -1;
        this$0.myNamingChangeTracker.runWithoutChanges((Function0<Unit>)((Function0)() -> NamingPolicyEditor.createActionWrapper$lambda$9$lambda$8(this$0, selectedRaw)));
        this$0.myNamingChangeTracker.policyChangedInPolicyEditor();
    }

    private static final Unit createActionWrapper$lambda$11$lambda$10(NamingPolicyEditor this$0, Ref.IntRef $selectedRaw) {
        this$0.myRulesTableSelectionModel.clearSelection();
        this$0.myRules.remove($selectedRaw.element);
        if ($selectedRaw.element > 0) {
            $selectedRaw.element += -1;
            int cfr_ignored_0 = $selectedRaw.element;
        } else {
            $selectedRaw.element = 0;
        }
        this$0.setSelection($selectedRaw.element);
        return Unit.INSTANCE;
    }

    private static final void createActionWrapper$lambda$11(NamingPolicyEditor this$0, AnActionButton it) {
        if (((Collection)this$0.myRules).size() <= 1) {
            return;
        }
        Ref.IntRef selectedRaw = new Ref.IntRef();
        selectedRaw.element = this$0.myRulesTable.getSelectedRow();
        if (selectedRaw.element >= 0) {
            this$0.myNamingChangeTracker.runWithoutChanges((Function0<Unit>)((Function0)() -> NamingPolicyEditor.createActionWrapper$lambda$11$lambda$10(this$0, selectedRaw)));
            this$0.myNamingChangeTracker.policyChangedInPolicyEditor();
        }
    }

    private static final void createActionWrapper$lambda$12(NamingPolicyEditor this$0, AnActionButton it) {
        int selectedIndex = this$0.myRulesTable.getSelectedRow();
        if (selectedIndex > 0) {
            this$0.changeRules(selectedIndex, selectedIndex - 1);
        }
    }

    private static final void createActionWrapper$lambda$13(NamingPolicyEditor this$0, AnActionButton it) {
        int selectedIndex = this$0.myRulesTable.getSelectedRow();
        if (selectedIndex < ((Collection)this$0.myRules).size() - 1) {
            this$0.changeRules(selectedIndex, selectedIndex + 1);
        }
    }

    private static final boolean createActionWrapper$lambda$14(NamingPolicyEditor this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.myNamingChangeTracker.hasPolicyInEditor();
    }

    private static final boolean createActionWrapper$lambda$15(NamingPolicyEditor this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.myNamingChangeTracker.hasPolicyInEditor() && ((Collection)this$0.myRules).size() > 1;
    }

    private static final Unit changeRules$lambda$16(NamingPolicyEditor this$0, int $from, int $to) {
        MutableNamingRule mutableNamingRule = this$0.myRules.get($from);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule, (String)"get(...)");
        MutableNamingRule ruleI = mutableNamingRule;
        MutableNamingRule mutableNamingRule2 = this$0.myRules.get($to);
        Intrinsics.checkNotNullExpressionValue((Object)mutableNamingRule2, (String)"get(...)");
        MutableNamingRule ruleJ = mutableNamingRule2;
        this$0.myRules.set($to, ruleI);
        this$0.myRules.set($from, ruleJ);
        this$0.setSelection($to);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ArrayList access$getMyRules$p(NamingPolicyEditor $this) {
        return $this.myRules;
    }
}

