/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeStyle;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\"\u001a\u0004\u0018\u00010#J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/DialogPositionProvider;", "", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "size", "Ljava/awt/Dimension;", "myDocument", "Lcom/intellij/openapi/editor/Document;", "selectionStartOffset", "", "selectionEndOffset", "parent", "Ljava/awt/Component;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Ljava/awt/Dimension;Lcom/intellij/openapi/editor/Document;IILjava/awt/Component;)V", "getMyEditor", "()Lcom/intellij/openapi/editor/Editor;", "getSize", "()Ljava/awt/Dimension;", "getMyDocument", "()Lcom/intellij/openapi/editor/Document;", "getSelectionStartOffset", "()I", "getSelectionEndOffset", "getParent", "()Ljava/awt/Component;", "myEditorComponent", "Ljavax/swing/JComponent;", "myContentComponent", "mySelectionStartY", "mySelectionEndY", "myTextRangeMaxColumnX", "myEditorComponentWidth", "myEditorComponentHeight", "calculateLocation", "Ljava/awt/Point;", "getYMatchingDialogAndSelectionCenter", "dialogHeight", "calculateSelectedTextRectangle", "", "getMaxColumnInsideRange", "Lcom/intellij/openapi/editor/VisualPosition;", "startOffset", "endOffset", "Companion", "intellij.rider.rdclient.dotnet"})
public final class DialogPositionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Dimension size;
    @NotNull
    private final Document myDocument;
    private final int selectionStartOffset;
    private final int selectionEndOffset;
    @NotNull
    private final Component parent;
    @NotNull
    private final JComponent myEditorComponent;
    @NotNull
    private final JComponent myContentComponent;
    private int mySelectionStartY;
    private int mySelectionEndY;
    private int myTextRangeMaxColumnX;
    private final int myEditorComponentWidth;
    private final int myEditorComponentHeight;
    private static final int PREFERRED_PADDING = 100;

    public DialogPositionProvider(@NotNull Editor myEditor, @NotNull Dimension size, @NotNull Document myDocument, int selectionStartOffset, int selectionEndOffset, @NotNull Component parent) {
        Intrinsics.checkNotNullParameter((Object)myEditor, (String)"myEditor");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)myDocument, (String)"myDocument");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.myEditor = myEditor;
        this.size = size;
        this.myDocument = myDocument;
        this.selectionStartOffset = selectionStartOffset;
        this.selectionEndOffset = selectionEndOffset;
        this.parent = parent;
        this.myContentComponent = this.myEditor.getContentComponent();
        this.myEditorComponent = this.myEditor.getComponent();
        this.myEditorComponentWidth = this.myEditorComponent.getWidth();
        this.myEditorComponentHeight = this.myEditorComponent.getHeight();
    }

    @NotNull
    public final Editor getMyEditor() {
        return this.myEditor;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    @NotNull
    public final Document getMyDocument() {
        return this.myDocument;
    }

    public final int getSelectionStartOffset() {
        return this.selectionStartOffset;
    }

    public final int getSelectionEndOffset() {
        return this.selectionEndOffset;
    }

    @NotNull
    public final Component getParent() {
        return this.parent;
    }

    @Nullable
    public final Point calculateLocation() {
        this.calculateSelectedTextRectangle();
        int dialogWidth = this.size.width;
        int dialogHeight = this.size.height;
        int spaceIfPlacedOnTheRight = this.myEditorComponentWidth - (this.myTextRangeMaxColumnX + dialogWidth);
        Integer dialogX = null;
        Integer dialogY = null;
        if (spaceIfPlacedOnTheRight > -100) {
            int paddingFromText = spaceIfPlacedOnTheRight > 100 ? 100 : spaceIfPlacedOnTheRight / 2;
            dialogX = this.myTextRangeMaxColumnX + paddingFromText;
            dialogY = this.mySelectionEndY - this.mySelectionStartY > dialogHeight ? Integer.valueOf((this.myEditorComponentHeight - dialogHeight) / 2) : Integer.valueOf(this.getYMatchingDialogAndSelectionCenter(dialogHeight));
        } else if (this.mySelectionStartY > dialogHeight) {
            dialogX = (this.myEditorComponentWidth - dialogWidth) / 2;
            dialogY = this.mySelectionStartY - dialogHeight;
        } else if (this.mySelectionEndY + dialogHeight < this.myEditorComponentHeight) {
            dialogX = (this.myEditorComponentWidth - dialogWidth) / 2;
            dialogY = this.mySelectionEndY;
        }
        if (dialogX != null && dialogY != null) {
            Point location = new Point(dialogX, dialogY);
            SwingUtilities.convertPointToScreen(location, this.myEditor.getComponent());
            return location;
        }
        return null;
    }

    private final int getYMatchingDialogAndSelectionCenter(int dialogHeight) {
        int extraBottomSpace;
        int selectionCenter = (this.mySelectionStartY + this.mySelectionEndY) / 2;
        int dialogTop = selectionCenter - dialogHeight / 2;
        int dialogBottom = selectionCenter + dialogHeight / 2;
        if (dialogTop >= 0 && dialogBottom <= this.myEditorComponentHeight) {
            return dialogTop;
        }
        if (dialogTop < 0) {
            int extraTopSpace = -dialogTop;
            if (dialogBottom + extraTopSpace <= this.myEditorComponentHeight) {
                return 0;
            }
        } else if (dialogBottom > this.myEditorComponentHeight && dialogTop - (extraBottomSpace = dialogBottom - this.myEditorComponentHeight) >= 0) {
            return dialogTop - extraBottomSpace;
        }
        return 0;
    }

    private final void calculateSelectedTextRectangle() {
        VisualPosition maxColumnVp = this.getMaxColumnInsideRange(this.selectionStartOffset, this.selectionEndOffset);
        Point point = this.myEditor.visualPositionToXY(maxColumnVp);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
        Point maxColumnsPoint = point;
        Point point2 = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(this.selectionStartOffset));
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"visualPositionToXY(...)");
        Point selectionStart = point2;
        Point point3 = this.myEditor.visualPositionToXY(this.myEditor.offsetToVisualPosition(this.selectionEndOffset));
        Intrinsics.checkNotNullExpressionValue((Object)point3, (String)"visualPositionToXY(...)");
        Point selectionEnd = point3;
        selectionStart = SwingUtilities.convertPoint(this.myContentComponent, selectionStart, this.parent);
        selectionEnd = SwingUtilities.convertPoint(this.myContentComponent, selectionEnd, this.parent);
        maxColumnsPoint = SwingUtilities.convertPoint(this.myContentComponent, maxColumnsPoint, this.parent);
        this.mySelectionStartY = selectionStart.y;
        this.mySelectionEndY = selectionEnd.y;
        this.myTextRangeMaxColumnX = maxColumnsPoint.x;
    }

    private final VisualPosition getMaxColumnInsideRange(int startOffset, int endOffset) {
        int firstLine = this.myDocument.getLineNumber(startOffset);
        int lastLine = this.myDocument.getLineNumber(endOffset);
        VisualPosition positionWithMaxColumn = new VisualPosition(0, 0);
        int currentLine = firstLine;
        if (currentLine <= lastLine) {
            while (true) {
                VisualPosition position;
                int offset = this.myDocument.getLineEndOffset(currentLine);
                Intrinsics.checkNotNullExpressionValue((Object)this.myEditor.offsetToVisualPosition(offset), (String)"offsetToVisualPosition(...)");
                if (position.getColumn() > positionWithMaxColumn.getColumn()) {
                    positionWithMaxColumn = position;
                }
                if (currentLine == lastLine) break;
                ++currentLine;
            }
        }
        return positionWithMaxColumn;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/codeStyle/DialogPositionProvider$Companion;", "", "<init>", "()V", "PREFERRED_PADDING", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

