/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.options.newEditor.SettingsTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.model.SettingsLayerCollection;
import com.jetbrains.rider.settings.IRiderViewModelConfigurable;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.ReSharperConfigurableUtilKt;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.RiderSettingsDialogFactoryCookie;
import com.jetbrains.rider.settings.RiderSettingsTreeView;
import com.jetbrains.rider.settings.SaveToAction;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 B2\u00020\u0001:\u0001BB;\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB=\b\u0016\u0012\b\b\u0001\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0011B?\b\u0016\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0016BG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010\u0012\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0018\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u0019J\b\u0010*\u001a\u00020+H\u0002J \u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020.2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0018H\u0014J\n\u0010/\u001a\u0004\u0018\u000100H\u0014J\b\u00101\u001a\u00020\tH\u0014J\b\u00102\u001a\u000200H\u0014J\u0013\u00103\u001a\b\u0012\u0004\u0012\u00020&04H\u0014\u00a2\u0006\u0002\u00105J\u0012\u00106\u001a\u00020+2\b\u00107\u001a\u0004\u0018\u00010\u0005H\u0014J\u0015\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020&04H\u0014\u00a2\u0006\u0002\u00105J\b\u00109\u001a\u00020&H\u0014J\u0012\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010&H\u0014J\u001a\u0010=\u001a\u00020+2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010>\u001a\u00020\u001eH\u0002J\b\u0010?\u001a\u00020&H\u0002J\b\u0010@\u001a\u00020+H\u0016J\b\u0010A\u001a\u00020+H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006C"}, d2={"Lcom/jetbrains/rider/settings/RiderSettingsDialog;", "Lcom/intellij/openapi/options/newEditor/SettingsDialog;", "project", "Lcom/intellij/openapi/project/Project;", "key", "", "configurable", "Lcom/intellij/openapi/options/Configurable;", "showApplyButton", "", "showResetButton", "settingsViewModelHost", "Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/options/Configurable;ZZLcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "parent", "Ljava/awt/Component;", "(Ljava/awt/Component;Ljava/lang/String;Lcom/intellij/openapi/options/Configurable;ZZLcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "groups", "", "Lcom/intellij/openapi/options/ConfigurableGroup;", "filter", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;Lcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "parentComponent", "", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Component;Ljava/util/List;Lcom/intellij/openapi/options/Configurable;Ljava/lang/String;Lcom/jetbrains/rider/settings/SettingsViewModelHost;)V", "getSettingsViewModelHost", "()Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "mySingleConfigurable", "mySaveButton", "Lcom/intellij/ui/components/JBOptionButton;", "myNorthPanel", "Ljavax/swing/JPanel;", "myIdeaTip", "Ljavax/swing/JLabel;", "mySequentialLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "myOpenLayersDialogAction", "Ljavax/swing/Action;", "areReSharperSettingsEnabled", "getAreReSharperSettingsEnabled", "()Z", "initialize", "", "treeViewFactory", "Lcom/intellij/openapi/options/newEditor/SettingsTreeView;", "Lcom/intellij/openapi/options/newEditor/SettingsFilter;", "createNorthPanel", "Ljavax/swing/JComponent;", "shouldAddErrorNearButtons", "createSouthPanel", "createLeftSideActions", "", "()[Ljavax/swing/Action;", "setErrorText", "text", "createActions", "getOKAction", "createJButtonForAction", "Ljavax/swing/JButton;", "action", "updateSaveButton", "saveButton", "createOpenLayersAction", "doOKAction", "doCancelAction", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderSettingsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderSettingsDialog.kt\ncom/jetbrains/rider/settings/RiderSettingsDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,375:1\n1#2:376\n37#3,2:377\n37#3,2:383\n1557#4:379\n1628#4,3:380\n14#5:385\n*S KotlinDebug\n*F\n+ 1 RiderSettingsDialog.kt\ncom/jetbrains/rider/settings/RiderSettingsDialog\n*L\n235#1:377,2\n304#1:383,2\n296#1:379\n296#1:380,3\n67#1:385\n*E\n"})
public final class RiderSettingsDialog
extends SettingsDialog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsViewModelHost settingsViewModelHost;
    @Nullable
    private final Project project;
    @Nullable
    private final Configurable mySingleConfigurable;
    @Nullable
    private JBOptionButton mySaveButton;
    @Nullable
    private JPanel myNorthPanel;
    @Nullable
    private JLabel myIdeaTip;
    @NotNull
    private final SequentialLifetimes mySequentialLifetimes;
    @Nullable
    private Action myOpenLayersDialogAction;
    @NotNull
    private static final String saveButtonName = "&Save";
    @NotNull
    private static final Icon unlayeredSettingIcon;
    @NotNull
    private static final Logger logger;

    @NotNull
    public final SettingsViewModelHost getSettingsViewModelHost() {
        return this.settingsViewModelHost;
    }

    private final boolean getAreReSharperSettingsEnabled() {
        return this.mySingleConfigurable == null || ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper(this.mySingleConfigurable);
    }

    public RiderSettingsDialog(@Nullable Project project, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, key, configurable, showApplyButton, showResetButton);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySequentialLifetimes = new SequentialLifetimes(settingsViewModelHost.getCurrentDialogLifetime());
        this.mySingleConfigurable = configurable;
        JBOptionButton jBOptionButton = this.mySaveButton;
        if (jBOptionButton != null) {
            JBOptionButton it = jBOptionButton;
            boolean bl = false;
            this.updateSaveButton(configurable, it);
        }
        this.initialize();
    }

    public RiderSettingsDialog(@NotNull Component parent, @NotNull String key, @NotNull Configurable configurable, boolean showApplyButton, boolean showResetButton, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(parent, key, configurable, showApplyButton, showResetButton);
        this.project = null;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySequentialLifetimes = new SequentialLifetimes(settingsViewModelHost.getCurrentDialogLifetime());
        this.mySingleConfigurable = configurable;
        JBOptionButton jBOptionButton = this.mySaveButton;
        if (jBOptionButton != null) {
            JBOptionButton it = jBOptionButton;
            boolean bl = false;
            this.updateSaveButton(configurable, it);
        }
        this.initialize();
    }

    public RiderSettingsDialog(@NotNull Project project, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, groups, configurable, filter2);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySequentialLifetimes = new SequentialLifetimes(settingsViewModelHost.getCurrentDialogLifetime());
        this.mySingleConfigurable = null;
        this.initialize();
    }

    public RiderSettingsDialog(@NotNull Project project, @Nullable Component parentComponent, @NotNull List<? extends ConfigurableGroup> groups, @Nullable Configurable configurable, @Nullable String filter2, @NotNull SettingsViewModelHost settingsViewModelHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        Intrinsics.checkNotNullParameter((Object)settingsViewModelHost, (String)"settingsViewModelHost");
        super(project, parentComponent, groups, configurable, filter2);
        this.project = project;
        this.settingsViewModelHost = settingsViewModelHost;
        this.mySequentialLifetimes = new SequentialLifetimes(settingsViewModelHost.getCurrentDialogLifetime());
        this.mySingleConfigurable = null;
        this.initialize();
    }

    private final void initialize() {
        JRootPane rootPane = this.getPeer().getRootPane();
        if (rootPane != null && this.mySingleConfigurable != null) {
            rootPane.setMinimumSize((Dimension)new JBDimension(700, 700));
            rootPane.setPreferredSize((Dimension)new JBDimension(700, 700));
        }
        if (!this.getAreReSharperSettingsEnabled()) {
            logger.info("Entered frontend-only settings dialog with mySingleConfigurable = " + this.mySingleConfigurable);
            return;
        }
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default(IPermittedModalities.Companion, null, 1, null);
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Component component = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        permittedModalitiesImpl.allowPumpProtocolForComponent(component, disposable);
        Lifetime currentDialogLifetime = this.settingsViewModelHost.getCurrentDialogLifetime();
        currentDialogLifetime.onTermination(() -> RiderSettingsDialog.initialize$lambda$2(this));
        this.settingsViewModelHost.getCurrentDialog().view(currentDialogLifetime, (arg_0, arg_1) -> RiderSettingsDialog.initialize$lambda$4(this, arg_0, arg_1));
        SettingsLayer settingsLayer = this.settingsViewModelHost.getLayer();
        if (settingsLayer == null) {
            return;
        }
        SettingsLayer layer = settingsLayer;
        JPanel layerPanel = new JPanel();
        layerPanel.setBorder(JBUI.Borders.empty((int)5));
        JLabel labelWithPrefix = new JLabel(RiderSettingsBundle.Companion.message("RiderSettingsDialog.label.layer", new Object[0]));
        labelWithPrefix.setBorder(JBUI.Borders.empty((int)0));
        JLabel labelWithLayerName = new JLabel(layer.getDisplayName());
        labelWithLayerName.setFont(labelWithLayerName.getFont().deriveFont(1));
        labelWithLayerName.setBorder(JBUI.Borders.empty((int)0));
        JLabel labelWithText = new JLabel(layer.getOriginText());
        labelWithText.setForeground((Color)JBColor.GRAY);
        labelWithText.setBorder(JBUI.Borders.empty((int)0));
        layerPanel.add(labelWithPrefix);
        layerPanel.add(labelWithLayerName);
        layerPanel.add(labelWithText);
        JPanel jPanel = this.myNorthPanel;
        Intrinsics.checkNotNull((Object)jPanel);
        jPanel.add((Component)layerPanel, "West");
        if (OptionsUtilsHost.Companion.getLayer() != null) {
            Object[] objectArray = new Object[]{this.getTitle()};
            this.setTitle(RiderSettingsBundle.Companion.message("RiderSettingsDialog.dialog.title.layer", objectArray));
        }
    }

    @NotNull
    protected SettingsTreeView treeViewFactory(@NotNull SettingsFilter filter2, @NotNull List<? extends ConfigurableGroup> groups) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter(groups, (String)"groups");
        return new RiderSettingsTreeView(filter2, groups);
    }

    @Nullable
    protected JComponent createNorthPanel() {
        this.myNorthPanel = new JPanel(new BorderLayout());
        return this.myNorthPanel;
    }

    protected boolean shouldAddErrorNearButtons() {
        return true;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type javax.swing.JPanel");
        JPanel result2 = (JPanel)jComponent;
        Companion.enumerateChildTree(result2, (Function1<? super Component, Unit>)((Function1)arg_0 -> RiderSettingsDialog.createSouthPanel$lambda$5(this, arg_0)));
        return result2;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        block6: {
            block5: {
                if (!OptionsUtilsHost.Companion.getAllowManageLayer() || OptionsUtilsHost.Companion.getLayer() != null || RiderSettingsDialogFactoryCookie.Companion.getProject() == null) break block5;
                Project project = RiderSettingsDialogFactoryCookie.Companion.getProject();
                Intrinsics.checkNotNull((Object)project);
                if (!project.isDefault()) break block6;
            }
            return new Action[0];
        }
        if (this.myOpenLayersDialogAction == null) {
            this.myOpenLayersDialogAction = this.createOpenLayersAction();
        }
        if (this.myOpenLayersDialogAction == null) {
            return new Action[0];
        }
        Action[] actionArray = new Action[1];
        Intrinsics.checkNotNull((Object)this.myOpenLayersDialogAction);
        return actionArray;
    }

    protected void setErrorText(@Nullable String text) {
        block3: {
            JLabel jLabel = this.myIdeaTip;
            if (jLabel == null) {
                return;
            }
            JLabel tip = jLabel;
            tip.getParent().getParent().getParent().setVisible(text != null);
            JLabel jLabel2 = this.myIdeaTip;
            if (jLabel2 != null) {
                String string = text;
                if (string == null) {
                    string = "";
                }
                jLabel2.setText(string);
            }
            JLabel jLabel3 = this.myIdeaTip;
            if (jLabel3 == null) break block3;
            jLabel3.setIcon(unlayeredSettingIcon);
        }
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        String topic = this.getHelpId();
        if (topic != null) {
            actions.add(this.getHelpAction());
        }
        Collection $this$toTypedArray$iv = actions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Action[0]);
    }

    @NotNull
    protected Action getOKAction() {
        DialogWrapper.OkAction saveAction2 = new DialogWrapper.OkAction(this){};
        saveAction2.putValue("Name", (Object)saveButtonName);
        return (Action)saveAction2;
    }

    @NotNull
    protected JButton createJButtonForAction(@Nullable Action action2) {
        Object name;
        if (action2 instanceof DialogWrapper.DialogWrapperAction && Intrinsics.areEqual((Object)(name = ((DialogWrapper.DialogWrapperAction)action2).getValue("Name")), (Object)saveButtonName)) {
            SaveToAction saveToAction = new SaveToAction(this);
            JButton jButton = super.createJButtonForAction((Action)saveToAction);
            JBOptionButton jBOptionButton = jButton instanceof JBOptionButton ? (JBOptionButton)jButton : null;
            if (jBOptionButton == null) {
                throw new IllegalStateException("Should Option button".toString());
            }
            JBOptionButton optionsButton = jBOptionButton;
            this.tryAddOptionsListener((OptionsEditorColleague)new OptionsEditorColleague.Adapter(this, optionsButton){
                final /* synthetic */ RiderSettingsDialog this$0;
                final /* synthetic */ JBOptionButton $optionsButton;
                {
                    this.this$0 = $receiver;
                    this.$optionsButton = $optionsButton;
                }

                public Promise<? super Object> onSelected(Configurable configurable, Configurable oldConfigurable) {
                    RiderSettingsDialog.access$updateSaveButton(this.this$0, configurable, this.$optionsButton);
                    return Promises.resolvedPromise();
                }
            });
            if (this.mySingleConfigurable != null) {
                this.updateSaveButton(this.mySingleConfigurable, optionsButton);
            }
            this.mySaveButton = optionsButton;
            return (JButton)optionsButton;
        }
        JButton jButton = super.createJButtonForAction(action2);
        Intrinsics.checkNotNullExpressionValue((Object)jButton, (String)"createJButtonForAction(...)");
        return jButton;
    }

    private final void updateSaveButton(Configurable configurable, JBOptionButton saveButton2) {
        boolean isEditingSingleLayer = this.settingsViewModelHost.getLayer() != null;
        boolean isConfigurableFromReSharper = ReSharperConfigurableUtilKt.checkIsConfigurableFromReSharper(configurable);
        if (isConfigurableFromReSharper) {
            IRiderViewModelConfigurable iRiderViewModelConfigurable = ReSharperConfigurableUtilKt.unwrapReSharperConfigurable(configurable);
            if (iRiderViewModelConfigurable != null ? iRiderViewModelConfigurable.getContainsIdeaSettings() : false) {
                this.setErrorText(RiderSettingsBundle.Companion.message("RiderSettingsDialog.dialog.message.some.settings.ignore.layers.when.saving", new Object[0]));
            } else {
                this.setErrorText(null);
            }
        } else {
            this.mySequentialLifetimes.terminateCurrent();
            this.setErrorText(null);
            saveButton2.setOptions(null);
        }
        if (!isEditingSingleLayer && isConfigurableFromReSharper) {
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (settingsViewModelHost == null) {
                throw new IllegalStateException("host".toString());
            }
            SettingsViewModelHost settingsHost = settingsViewModelHost;
            OptionsDialog optionsDialogModel = (OptionsDialog)((Object)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)settingsHost.getSettingsViewModel().getOptionsDialog())));
            Action[] actionArray = new Action[1];
            String string = RiderSettingsBundle.Companion.message("RiderSettingsDialog.loading.layers", new Object[0]);
            actionArray[0] = new AbstractAction(string){

                public boolean isEnabled() {
                    return false;
                }

                public void actionPerformed(ActionEvent e) {
                }
            };
            saveButton2.setOptions(actionArray);
            optionsDialogModel.getSettingsLayerCollection().advise((Lifetime)this.mySequentialLifetimes.next(), arg_0 -> RiderSettingsDialog.updateSaveButton$lambda$7(saveButton2, settingsHost, arg_0));
        }
    }

    private final Action createOpenLayersAction() {
        Ref.ObjectRef dialog2 = new Ref.ObjectRef();
        dialog2.element = this;
        String string = RiderSettingsBundle.Companion.message("RiderSettingsDialog.button.manage.layers", new Object[0]);
        DialogWrapper.DialogWrapperAction openLayersDialogAction2 = new DialogWrapper.DialogWrapperAction(this, (Ref.ObjectRef<RiderSettingsDialog>)dialog2, string){
            final /* synthetic */ Ref.ObjectRef<RiderSettingsDialog> $dialog;
            {
                this.$dialog = $dialog;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                DataContext context2 = new DataContext(this.$dialog){
                    final /* synthetic */ Ref.ObjectRef<RiderSettingsDialog> $dialog;
                    {
                        this.$dialog = $dialog;
                    }

                    public Object getData(String dataId) {
                        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                        if (Intrinsics.areEqual((Object)dataId, (Object)CommonDataKeys.PROJECT.getName())) {
                            return RiderSettingsDialog.access$getProject$p((RiderSettingsDialog)((Object)this.$dialog.element));
                        }
                        return null;
                    }
                };
                AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"", null, (DataContext)context2);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
                AnActionEvent event = anActionEvent;
                AnAction action2 = ActionManager.getInstance().getAction("ShowLayersDialog");
                ((RiderSettingsDialog)((Object)this.$dialog.element)).doCancelAction();
                action2.actionPerformed(event);
            }
        };
        return (Action)openLayersDialogAction2;
    }

    public void doOKAction() {
        TableCellEditor editor;
        Container parent;
        Component focusOwner = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner instanceof JFormattedTextField) {
            ((JFormattedTextField)focusOwner).commitEdit();
        }
        Component component = focusOwner;
        Container container = parent = component != null ? component.getParent() : null;
        if (parent instanceof JTable && (editor = ((JTable)parent).getCellEditor()) != null && !editor.stopCellEditing()) {
            throw new ConfigurationException(RiderSettingsBundle.Companion.message("RiderSettingsDialog.dialog.message.editing.cannot.be.stopped", new Object[0]));
        }
        super.doOKAction();
        if (this.getAreReSharperSettingsEnabled()) {
            this.settingsViewModelHost.ok();
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        if (this.getAreReSharperSettingsEnabled()) {
            this.settingsViewModelHost.cancel();
        }
    }

    private static final Unit initialize$lambda$2(RiderSettingsDialog this$0) {
        if (!this$0.isDisposed()) {
            super.doCancelAction();
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$4$lambda$3(RiderSettingsDialog this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Settings settings = (Settings)Settings.KEY.getData((DataProvider)this$0);
        if (settings == null) {
            return Unit.INSTANCE;
        }
        Settings settings2 = settings;
        settings2.select(settings2.find(it));
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$4(RiderSettingsDialog this$0, Lifetime dialogLifetime, OptionsDialog dialog2) {
        Intrinsics.checkNotNullParameter((Object)dialogLifetime, (String)"dialogLifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)dialog2), (String)"dialog");
        dialog2.getSelectPage().advise(dialogLifetime, arg_0 -> RiderSettingsDialog.initialize$lambda$4$lambda$3(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createSouthPanel$lambda$5(RiderSettingsDialog this$0, Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof JLabel) {
            this$0.myIdeaTip = (JLabel)it;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit updateSaveButton$lambda$7(JBOptionButton $saveButton, SettingsViewModelHost $settingsHost, SettingsLayerCollection layerCollection) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)layerCollection), (String)"layerCollection");
        Iterable $this$map$iv = layerCollection.getLayers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SettingsLayer settingsLayer = (SettingsLayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getDisplayName();
            collection.add(new AbstractAction((SettingsLayer)it, $settingsHost, string){
                private final String layerName;
                final /* synthetic */ SettingsViewModelHost $settingsHost;
                {
                    this.$settingsHost = $settingsHost;
                    super($super_call_param$1);
                    this.layerName = $it.getDisplayName();
                }

                public void actionPerformed(ActionEvent e) {
                    this.$settingsHost.saveTo(this.layerName);
                }
            });
        }
        List layerActions2 = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = layerActions2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $saveButton.setOptions(thisCollection$iv.toArray(new Action[0]));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateSaveButton(RiderSettingsDialog $this, Configurable configurable, JBOptionButton saveButton2) {
        $this.updateSaveButton(configurable, saveButton2);
    }

    public static final /* synthetic */ Project access$getProject$p(RiderSettingsDialog $this) {
        return $this.project;
    }

    static {
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        unlayeredSettingIcon = icon;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderSettingsDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderSettingsDialog.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000e0\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/settings/RiderSettingsDialog$Companion;", "", "<init>", "()V", "saveButtonName", "", "getSaveButtonName", "()Ljava/lang/String;", "unlayeredSettingIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getUnlayeredSettingIcon", "()Ljavax/swing/Icon;", "enumerateChildTree", "", "Ljava/awt/Container;", "lambda", "Lkotlin/Function1;", "Ljava/awt/Component;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getSaveButtonName() {
            return saveButtonName;
        }

        @NotNull
        public final Icon getUnlayeredSettingIcon() {
            return unlayeredSettingIcon;
        }

        public final void enumerateChildTree(@NotNull Container $this$enumerateChildTree, @NotNull Function1<? super Component, Unit> lambda) {
            Intrinsics.checkNotNullParameter((Object)$this$enumerateChildTree, (String)"<this>");
            Intrinsics.checkNotNullParameter(lambda, (String)"lambda");
            int i = 0;
            int n = $this$enumerateChildTree.getComponentCount() - 1;
            if (i <= n) {
                while (true) {
                    Component child = $this$enumerateChildTree.getComponent(i);
                    Intrinsics.checkNotNull((Object)child);
                    lambda.invoke((Object)child);
                    if (child instanceof Container) {
                        this.enumerateChildTree((Container)child, lambda);
                    }
                    if (i == n) break;
                    ++i;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

