/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.popup.WizardPopup;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.services.popups.nova.PopupMenus;
import com.jetbrains.rider.services.popups.nova.PopupViewModel;
import com.jetbrains.rider.services.popups.nova.layouter.HackPopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.LayoutResult;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterKt;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouterSource;
import java.awt.Component;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus;", "Lcom/jetbrains/rider/services/popups/nova/PopupMenus;", "<init>", "()V", "showPopup", "", "viewModel", "Lcom/jetbrains/rider/services/popups/nova/PopupViewModel;", "popup", "Lcom/intellij/ui/popup/WizardPopup;", "showNoItemsBanner", "showErrorHint", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.rdclient.dotnet"})
@ApiStatus.Internal
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nUiPopupMenus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiPopupMenus.kt\ncom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n14#2:72\n*S KotlinDebug\n*F\n+ 1 UiPopupMenus.kt\ncom/jetbrains/rider/services/popups/nova/ui/UiPopupMenus\n*L\n61#1:72\n*E\n"})
public class UiPopupMenus
extends PopupMenus {
    @Override
    protected void showPopup(@NotNull PopupViewModel viewModel, @NotNull WizardPopup popup) {
        Component owner;
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        PopupLayouterSource popupLayouterSource = viewModel.getPopupLayouterSource();
        Intrinsics.checkNotNull((Object)popupLayouterSource);
        PopupLayouter layouter = popupLayouterSource.createLayouter(viewModel.getLifetime());
        if (layouter instanceof HackPopupLayouter) {
            popup.showInBestPositionFor(((HackPopupLayouter)layouter).getDataContext());
            return;
        }
        if (layouter.getProject().isDefault()) {
            viewModel.terminateModel();
            return;
        }
        IOptProperty<Dimension> iOptProperty = layouter.getSize();
        Dimension dimension = popup.getPreferredContentSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredContentSize(...)");
        iOptProperty.set((Object)dimension);
        LayoutResult layoutResult = (LayoutResult)layouter.getLayout().getValue();
        if (layoutResult == null) {
            UiPopupMenus $this$showPopup_u24lambda_u240 = this;
            boolean bl = false;
            viewModel.terminateModel();
            return;
        }
        LayoutResult layoutResult2 = layoutResult;
        Component component = WindowManagerEx.getInstanceEx().getFocusedComponent(layouter.getProject());
        if (component == null) {
            IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(layouter.getProject());
            component = ideFrame != null ? ideFrame.getComponent() : null;
        }
        if ((owner = component) == null) {
            viewModel.terminateModel();
            return;
        }
        try {
            popup.show(owner, PopupLayouterKt.getLocation((LayoutResult)layoutResult2).x, PopupLayouterKt.getLocation((LayoutResult)layoutResult2).y, true);
        }
        catch (Throwable t) {
            viewModel.terminateModel();
            throw t;
        }
    }

    @Override
    protected void showNoItemsBanner(@NotNull PopupViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(arg_0 -> UiPopupMenus.showNoItemsBanner$lambda$1(this, viewModel, arg_0));
    }

    protected final void showErrorHint(@NotNull Editor editor, @NotNull PopupViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        HintManager hintManager = HintManager.getInstance();
        String string = viewModel.getNoItemsBannerText();
        if (string == null) {
            string = "No items to show";
        }
        hintManager.showErrorHint(editor, string);
    }

    private static final void showNoItemsBanner$lambda$1(UiPopupMenus this$0, PopupViewModel $viewModel, DataContext dataContext) {
        Intrinsics.checkNotNull((Object)dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(UiPopupMenus.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("context is not editor");
            return;
        }
        this$0.showErrorHint(editor, $viewModel);
    }
}

