/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.layouter;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.ui.ScreenUtil;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"getScreenRectangle", "Ljava/awt/Rectangle;", "point", "Ljava/awt/Point;", "intellij.rider.rdclient.dotnet"})
public final class GutterMarkMenuLayoterKt {
    @NotNull
    public static final Rectangle getScreenRectangle(@NotNull Point point) {
        GraphicsDevice device;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (!SystemInfo.isWindows) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle((Point)point);
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
            return rectangle;
        }
        IdeFocusManager ideFocusManager = IdeFocusManager.findInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"findInstance(...)");
        IdeFocusManager instance = ideFocusManager;
        IdeFrame lastFocusedFrame = instance.getLastFocusedFrame();
        if (lastFocusedFrame instanceof IdeFrameEx && ((IdeFrameEx)lastFocusedFrame).isInFullScreen() && (device = ScreenUtil.getScreenDevice((Rectangle)new Rectangle(point, new Dimension(1, 1)))) != null && device.getDefaultConfiguration() != null) {
            Rectangle rectangle = device.getDefaultConfiguration().getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            return rectangle;
        }
        Rectangle rectangle = ScreenUtil.getScreenRectangle((Point)point);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getScreenRectangle(...)");
        return rectangle;
    }
}

