/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups.nova.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.jetbrains.ide.model.popups.RdButtonViewModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.util.List;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0007B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/services/popups/nova/impl/RiderToolbarButtonsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "buttons", "", "Lcom/jetbrains/ide/model/popups/RdButtonViewModel;", "<init>", "(Ljava/util/List;)V", "MyButtonAction", "intellij.rider.rdclient.dotnet"})
public final class RiderToolbarButtonsGroup
extends DefaultActionGroup {
    public RiderToolbarButtonsGroup(@NotNull List<RdButtonViewModel> buttons) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        for (RdButtonViewModel button : buttons) {
            IconModel iconModel = button.getIcon();
            Icon icon = iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
            this.add(new MyButtonAction(button, icon));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/services/popups/nova/impl/RiderToolbarButtonsGroup$MyButtonAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "button", "Lcom/jetbrains/ide/model/popups/RdButtonViewModel;", "icon", "Ljavax/swing/Icon;", "<init>", "(Lcom/jetbrains/ide/model/popups/RdButtonViewModel;Ljavax/swing/Icon;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rider.rdclient.dotnet"})
    private static final class MyButtonAction
    extends AnAction {
        @NotNull
        private final RdButtonViewModel button;

        public MyButtonAction(@NotNull RdButtonViewModel button, @Nullable Icon icon) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            super(button.getTooltip(), button.getTooltip(), icon);
            this.button = button;
            if (this.button.getShortcut() != null) {
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(this.button.getShortcut())));
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            InterfacesKt.fire((ISignal)this.button.getExecute());
            StackingPopupDispatcher.getInstance().closeActivePopup();
        }
    }
}

