/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.util.PopupUtilsKt;
import com.jetbrains.ide.model.popups.PopupInteractionModel;
import com.jetbrains.ide.model.popups.RdMousePositionContext;
import com.jetbrains.ide.model.popups.RdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItem;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItems;
import com.jetbrains.ide.model.popups.RdPopupSelection;
import com.jetbrains.ide.model.popups.RdPopupWindowContextBase;
import com.jetbrains.ide.model.popups.RdScreenPositionPopupWindowContext;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.util.idea.LifetimedProjectComponent;
import com.jetbrains.rider.services.popups.FrontendListPopupStep;
import com.jetbrains.rider.services.popups.FrontendPopupItem;
import com.jetbrains.rider.services.popups.FrontendPopupModelHostKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\tJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\bH\u0004J(\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J \u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J$\u0010 \u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/services/popups/FrontendPopupModelHost;", "Lcom/jetbrains/rdclient/util/idea/LifetimedProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "idToAnchor", "Ljava/util/HashMap;", "", "Ljavax/swing/JComponent;", "Lkotlin/collections/HashMap;", "registerAnchorComponent", "", "key", "anchor", "tryTakeAnchorComponent", "showPopup", "identity", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdPopupModel", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModel;", "interactionModel", "Lcom/jetbrains/ide/model/popups/PopupInteractionModel;", "showInBestPosition", "popup", "Lcom/intellij/ui/popup/list/ListPopupImpl;", "modelContext", "Lcom/jetbrains/ide/model/popups/RdPopupWindowContextBase;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "groupItemsWithSeparators", "modelItems", "", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModelItem;", "popupItems", "", "Lcom/jetbrains/rider/services/popups/FrontendPopupItem;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendPopupModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPopupModelHost.kt\ncom/jetbrains/rider/services/popups/FrontendPopupModelHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n68#2,4:210\n68#2,4:214\n*S KotlinDebug\n*F\n+ 1 FrontendPopupModelHost.kt\ncom/jetbrains/rider/services/popups/FrontendPopupModelHost\n*L\n44#1:210,4\n53#1:214,4\n*E\n"})
public abstract class FrontendPopupModelHost
extends LifetimedProjectComponent {
    @NotNull
    private final HashMap<String, JComponent> idToAnchor;

    public FrontendPopupModelHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.idToAnchor = new HashMap();
    }

    public final void registerAnchorComponent(@NotNull String key, @NotNull JComponent anchor) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Logger $this$trace$iv = FrontendPopupModelHostKt.access$getLogger$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("registerAnchorComponent {" + key + "}, anchor {" + anchor + "}@{" + anchor.hashCode() + "}");
            }
            JComponent jComponent = this.idToAnchor.put(key, anchor);
            if (jComponent == null) break block2;
            JComponent it = jComponent;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)anchor)) {
                FrontendPopupModelHostKt.access$getLogger$p().error("idToAnchor: already contains component: " + key + " and it differs from the passed one");
            }
        }
    }

    @Nullable
    protected final JComponent tryTakeAnchorComponent(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        JComponent result2 = this.idToAnchor.get(key);
        Logger $this$trace$iv = FrontendPopupModelHostKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            JComponent jComponent = result2;
            logger.trace("tryTakeAnchorComponent {" + key + "}, anchor {" + result2 + "}@{" + (jComponent != null ? Integer.valueOf(jComponent.hashCode()) : null) + "}");
        }
        if (result2 != null) {
            this.idToAnchor.remove(key);
        } else {
            FrontendPopupModelHostKt.access$getLogger$p().error("idToAnchor: failed to find component by key: " + key);
        }
        return result2;
    }

    protected void showPopup(int identity, @NotNull Lifetime lifetime, @NotNull RdPopupMenuModel rdPopupModel, @NotNull PopupInteractionModel interactionModel) {
        List modelItems;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)rdPopupModel, (String)"rdPopupModel");
        Intrinsics.checkNotNullParameter((Object)interactionModel, (String)"interactionModel");
        List popupItems = new ArrayList();
        RdPopupMenuModelItems rdPopupMenuModelItems = (RdPopupMenuModelItems)rdPopupModel.getItems().getValueOrNull();
        List list2 = modelItems = rdPopupMenuModelItems != null ? rdPopupMenuModelItems.getValue() : null;
        if (modelItems != null) {
            this.groupItemsWithSeparators(modelItems, popupItems);
        }
        FrontendListPopupStep popupStep = new FrontendListPopupStep(this.getProject(), rdPopupModel, popupItems, identity, interactionModel);
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
        Intrinsics.checkNotNull((Object)listPopup, (String)"null cannot be cast to non-null type com.intellij.ui.popup.list.ListPopupImpl");
        ListPopupImpl popup = (ListPopupImpl)listPopup;
        rdPopupModel.getItems().advise(lifetime, arg_0 -> FrontendPopupModelHost.showPopup$lambda$3(popup, this, arg_0));
        String string = rdPopupModel.getFooter();
        if (string != null) {
            String it = string;
            boolean bl = false;
            popup.setAdText(it, 2);
        }
        popup.addListSelectionListener(arg_0 -> FrontendPopupModelHost.showPopup$lambda$5(rdPopupModel, arg_0));
        DataManager.getInstance().getDataContextFromFocusAsync().onProcessed(arg_0 -> FrontendPopupModelHost.showPopup$lambda$7(arg_0 -> FrontendPopupModelHost.showPopup$lambda$6(this, popup, rdPopupModel, arg_0), arg_0));
    }

    private final void showInBestPosition(ListPopupImpl popup, RdPopupWindowContextBase modelContext, DataContext dataContext) {
        RdPopupWindowContextBase rdPopupWindowContextBase = modelContext;
        if (rdPopupWindowContextBase instanceof RdScreenPositionPopupWindowContext) {
            Component focusedComponent;
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            Component component = windowManager.getFocusedComponent(this.getProject());
            if (component == null) {
                component = windowManager.getMostRecentFocusedWindow();
            }
            if ((focusedComponent = component) != null) {
                popup.showInScreenCoordinates(focusedComponent, new Point(((RdScreenPositionPopupWindowContext)modelContext).getX(), ((RdScreenPositionPopupWindowContext)modelContext).getY()));
                return;
            }
        } else if (rdPopupWindowContextBase instanceof RdMousePositionContext) {
            Component focusedComponent;
            WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
            Component component = windowManager.getFocusedComponent(this.getProject());
            if (component == null) {
                component = windowManager.getMostRecentFocusedWindow();
            }
            if ((focusedComponent = component) != null) {
                return;
            }
        }
        RelativePoint relativePoint = PopupUtilsKt.getBestPopupPosition((DataContext)dataContext);
        popup.show(relativePoint);
    }

    private final void groupItemsWithSeparators(List<RdPopupMenuModelItem> modelItems, List<FrontendPopupItem> popupItems) {
        RdPopupMenuModelItem separator = null;
        for (RdPopupMenuModelItem modelItem : modelItems) {
            if (modelItem.isSeparator()) {
                separator = modelItem;
                continue;
            }
            popupItems.add(new FrontendPopupItem(modelItem, separator));
            separator = null;
        }
    }

    private static final Unit showPopup$lambda$3(ListPopupImpl $popup, FrontendPopupModelHost this$0, RdPopupMenuModelItems it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List newItems = it.getValue();
        List list2 = $popup.getListStep().getValues();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValues(...)");
        List values = list2;
        values.clear();
        this$0.groupItemsWithSeparators(newItems, TypeIntrinsics.asMutableList((Object)values));
        ListModel listModel2 = $popup.getList().getModel();
        Intrinsics.checkNotNull(listModel2, (String)"null cannot be cast to non-null type com.intellij.ui.popup.list.ListPopupModel<*>");
        ((ListPopupModel)listModel2).syncModel();
        JComponent jComponent = $popup.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContent(...)");
        JComponent content = jComponent;
        content.setPreferredSize(null);
        Dimension newSize = content.getPreferredSize();
        content.setPreferredSize(newSize);
        $popup.setSize(newSize);
        $popup.moveToFitScreen();
        return Unit.INSTANCE;
    }

    private static final void showPopup$lambda$5(RdPopupMenuModel $rdPopupModel, ListSelectionEvent it) {
        RdPopupMenuModelItems rdPopupMenuModelItems = (RdPopupMenuModelItems)$rdPopupModel.getItems().getValueOrNull();
        if (rdPopupMenuModelItems == null) {
            return;
        }
        int version = rdPopupMenuModelItems.getVersion();
        $rdPopupModel.getSelectedItem().set((Object)new RdPopupSelection(Integer.valueOf(it.getFirstIndex()), version));
    }

    private static final Unit showPopup$lambda$6(FrontendPopupModelHost this$0, ListPopupImpl $popup, RdPopupMenuModel $rdPopupModel, DataContext it) {
        if (it == null) {
            return Unit.INSTANCE;
        }
        this$0.showInBestPosition($popup, $rdPopupModel.getContext(), it);
        return Unit.INSTANCE;
    }

    private static final void showPopup$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

