/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.popups;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.ide.model.popups.PopupInteractionModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModel;
import com.jetbrains.ide.model.popups.RdPopupMenuModelItems;
import com.jetbrains.ide.model.uiautomation.BeRichText;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.RichAttributedTextModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.ui.ProtocolUIKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.RdFault;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.FrontendBundle;
import com.jetbrains.rdclient.ui.RichTextHtmlUtils;
import com.jetbrains.rider.services.popups.FrontendPopupItem;
import com.jetbrains.rider.services.popups.FrontendPopupModelHostKt;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0012\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/services/popups/FrontendListPopupStep;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/jetbrains/rider/services/popups/FrontendPopupItem;", "project", "Lcom/intellij/openapi/project/Project;", "popupModel", "Lcom/jetbrains/ide/model/popups/RdPopupMenuModel;", "items", "", "identity", "", "interactionModel", "Lcom/jetbrains/ide/model/popups/PopupInteractionModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/popups/RdPopupMenuModel;Ljava/util/List;ILcom/jetbrains/ide/model/popups/PopupInteractionModel;)V", "isItemChoosing", "", "isSelectable", "value", "getIconFor", "Ljavax/swing/Icon;", "getTextFor", "", "getSeparatorAbove", "Lcom/intellij/openapi/ui/popup/ListSeparator;", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "canceled", "", "releaseProtocolModel", "intellij.rider.rdclient.dotnet"})
public final class FrontendListPopupStep
extends BaseListPopupStep<FrontendPopupItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final RdPopupMenuModel popupModel;
    private final int identity;
    @NotNull
    private final PopupInteractionModel interactionModel;
    private boolean isItemChoosing;

    public FrontendListPopupStep(@NotNull Project project, @NotNull RdPopupMenuModel popupModel, @NotNull List<FrontendPopupItem> items, int identity, @NotNull PopupInteractionModel interactionModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)popupModel, (String)"popupModel");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)interactionModel, (String)"interactionModel");
        Object object = popupModel.getToolbar().getCaption().getValue();
        BeRichText beRichText = object instanceof BeRichText ? (BeRichText)object : null;
        super(beRichText != null && (beRichText = beRichText.getText()) != null && (beRichText = (RichTextModel)beRichText.getValueOrNull()) != null ? ProtocolUIKt.toSimpleText((RichTextModel)beRichText) : null, items);
        this.project = project;
        this.popupModel = popupModel;
        this.identity = identity;
        this.interactionModel = interactionModel;
    }

    public boolean isSelectable(@Nullable FrontendPopupItem value) {
        FrontendPopupItem frontendPopupItem = value;
        return frontendPopupItem != null && (frontendPopupItem = frontendPopupItem.getModel()) != null ? frontendPopupItem.isEnabled() : false;
    }

    @Nullable
    public Icon getIconFor(@Nullable FrontendPopupItem value) {
        FrontendPopupItem frontendPopupItem = value;
        return frontendPopupItem != null && (frontendPopupItem = frontendPopupItem.getModel()) != null && (frontendPopupItem = frontendPopupItem.getIcon()) != null ? UtilKt.fromModel((IconModel)frontendPopupItem) : null;
    }

    @NotNull
    public String getTextFor(@Nullable FrontendPopupItem value) {
        Object object = value;
        if (object == null || (object = ((FrontendPopupItem)object).getModel()) == null || (object = object.getText()) == null || (object = RichTextHtmlUtils.INSTANCE.highlightAttributedParts((RichAttributedTextModel)object)) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(@Nullable FrontendPopupItem value) {
        FrontendPopupItem frontendPopupItem = value;
        if (frontendPopupItem == null || (frontendPopupItem = frontendPopupItem.getSeparator()) == null) {
            return null;
        }
        FrontendPopupItem separator = frontendPopupItem;
        IconModel iconModel = separator.getIcon();
        return new ListSeparator(RichTextHtmlUtils.INSTANCE.highlightAttributedParts(separator.getText()), iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null);
    }

    @Nullable
    public PopupStep<?> onChosen(@NotNull FrontendPopupItem selectedValue, boolean finalChoice) {
        Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
        Object object = (RdPopupMenuModelItems)this.popupModel.getItems().getValueOrNull();
        if (object == null || (object = object.getValue()) == null) {
            throw new IllegalStateException("Selected item not found".toString());
        }
        int idx = object.indexOf(selectedValue.getModel());
        this.isItemChoosing = true;
        return this.doFinalStep(() -> FrontendListPopupStep.onChosen$lambda$1(this, idx));
    }

    public void canceled() {
        if (!this.isItemChoosing) {
            this.releaseProtocolModel();
        }
    }

    private final void releaseProtocolModel() {
        this.interactionModel.getPopups().remove((Object)this.identity);
    }

    private static final Unit onChosen$lambda$1$lambda$0(FrontendListPopupStep this$0, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof RdTaskResult.Fault) {
            RdFault error = ((RdTaskResult.Fault)it).getError();
            CharSequence charSequence = error.getReasonAsText();
            if (new Regex("\\.psi\\.|element|file", RegexOption.IGNORE_CASE).containsMatchIn(charSequence)) {
                Project project = this$0.project;
                String string = FrontendBundle.INSTANCE.message("error.failed.to.modify.document", new Object[0]);
                String string2 = this$0.getTitle();
                if (string2 == null) {
                    string2 = "";
                }
                Messages.showInfoMessage((Project)project, (String)string, (String)StringUtil.toTitleCase((String)string2));
            }
            FrontendPopupModelHostKt.access$getLogger$p().error((Throwable)error);
        }
        this$0.releaseProtocolModel();
        return Unit.INSTANCE;
    }

    private static final void onChosen$lambda$1(FrontendListPopupStep this$0, int $idx) {
        SourceExKt.adviseOnce((ISource)((ISource)this$0.popupModel.getExecuteItem().start((Object)$idx).getResult()), (Lifetime)Lifetime.Companion.getEternal(), arg_0 -> FrontendListPopupStep.onChosen$lambda$1$lambda$0(this$0, arg_0));
    }
}

