/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.EditMemorySettingsService;
import com.intellij.diagnostic.VMOptions;
import com.intellij.diagnostic.hprof.action.InternalNonuserInvokedHeapDumpSnapshotAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/services/LowMemoryDialogService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "alreadyShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "showDialog", "", "showDialogOnMainThread", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nLowMemoryDialogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LowMemoryDialogService.kt\ncom/jetbrains/rider/services/LowMemoryDialogService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,82:1\n37#2,2:83\n*S KotlinDebug\n*F\n+ 1 LowMemoryDialogService.kt\ncom/jetbrains/rider/services/LowMemoryDialogService\n*L\n61#1:83,2\n*E\n"})
public final class LowMemoryDialogService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean alreadyShown;

    public LowMemoryDialogService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.alreadyShown = new AtomicBoolean(false);
    }

    public final void showDialog() {
        if (!this.alreadyShown.compareAndSet(false, true)) {
            return;
        }
        ApplicationKt.getApplication().invokeLater(() -> LowMemoryDialogService.showDialog$lambda$0(this));
    }

    private final void showDialogOnMainThread() {
        String string;
        int current = VMOptions.readOption((VMOptions.MemoryKind)VMOptions.MemoryKind.HEAP, (boolean)true);
        String string2 = current == -1 ? DiagnosticBundle.message((String)"change.memory.unknown", (Object[])new Object[0]) : String.valueOf(current);
        Intrinsics.checkNotNull((Object)string2);
        String currentText = string2;
        int suggested = current > 0 ? current * 2 : Registry.Companion.intValue("max.suggested.heap.size");
        Object[] objectArray = new String[3];
        if (VMOptions.canWriteOptions()) {
            Object[] objectArray2 = new Object[]{suggested};
            string = RdClientDotnetBundle.INSTANCE.message("low.memory.dialog.increase", objectArray2);
        } else {
            String string3 = ApplicationBundle.message((String)"command.exit", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        objectArray[0] = string;
        objectArray[1] = RdClientDotnetBundle.INSTANCE.message("low.memory.dialog.analyze", new Object[0]);
        objectArray[2] = RdClientDotnetBundle.INSTANCE.message("low.memory.dialog.ignore", new Object[0]);
        List options = CollectionsKt.mutableListOf((Object[])objectArray);
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String solutionName = SolutionHostExtensionsKt.getSolutionName(this.project);
        Object[] objectArray3 = new Object[]{productName, solutionName, currentText};
        Collection $this$toTypedArray$iv = options;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        int dialogResult = MessagesEx.showDialog((String)RdClientDotnetBundle.INSTANCE.message("low.memory.dialog.message", objectArray3), (String)RdClientDotnetBundle.INSTANCE.message("low.memory.dialog.title", new Object[0]), (String[])thisCollection$iv.toArray(new String[0]), (int)0, (Icon)UIUtil.getErrorIcon());
        switch (dialogResult) {
            case 0: {
                if (VMOptions.canWriteOptions()) {
                    EditMemorySettingsService.getInstance().save(VMOptions.MemoryKind.HEAP, suggested);
                    com.jetbrains.rd.platform.util.ApplicationKt.getApplicationEx().restart(true);
                    break;
                }
                com.jetbrains.rd.platform.util.ApplicationKt.getApplicationEx().exit(true, true);
                break;
            }
            case 1: {
                AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"", null, (DataContext)DataContext.EMPTY_CONTEXT);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
                AnActionEvent e = anActionEvent;
                new InternalNonuserInvokedHeapDumpSnapshotAction().actionPerformed(e);
            }
        }
    }

    private static final void showDialog$lambda$0(LowMemoryDialogService this$0) {
        this$0.showDialogOnMainThread();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/services/LowMemoryDialogService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/services/LowMemoryDialogService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nLowMemoryDialogService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LowMemoryDialogService.kt\ncom/jetbrains/rider/services/LowMemoryDialogService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,82:1\n31#2,2:83\n*S KotlinDebug\n*F\n+ 1 LowMemoryDialogService.kt\ncom/jetbrains/rider/services/LowMemoryDialogService$Companion\n*L\n27#1:83,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LowMemoryDialogService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LowMemoryDialogService> serviceClass$iv = LowMemoryDialogService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LowMemoryDialogService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

