/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.BundleBase;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ReportFeedbackService;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.MathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.Url;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.dom.XmlElement;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.NetCoreRuntime;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.clrmd.ClrProcessThreadDumpUtilKt;
import com.jetbrains.rider.clrmd.CollectThreadDumpRequest;
import com.jetbrains.rider.cpp.DisableCppAction;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfiler;
import com.jetbrains.rider.diagnostics.dotnetSelfProfiling.DotnetSelfProfilingProcesses;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.model.SnapshotKind;
import com.jetbrains.rider.protocol.BackendCrashAnalyzer;
import com.jetbrains.rider.protocol.BackendCrashDiagnostics;
import com.jetbrains.rider.protocol.CriticalErrorApplicationTerminator;
import com.jetbrains.rider.protocol.LocaleHelper;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ReSharperProcess;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 K2\u00020\u0001:\u0004HIJKB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H&J\b\u0010\u0019\u001a\u00020\u0018H&J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH&J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001dH&J\u001c\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180!H\u0002J$\u0010\"\u001a\u00020\u001f2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180!2\u0006\u0010$\u001a\u00020%H\u0002J\u001c\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0)J\b\u0010*\u001a\u00020\u001fH\u0002J\u0006\u0010\u0013\u001a\u00020\u001fJ\u0016\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003J\u001d\u00100\u001a\u000701\u00a2\u0006\u0002\b22\u0006\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u0018H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020%H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0002J\u0006\u0010;\u001a\u00020\u001fJ\b\u0010<\u001a\u00020\u001fH\u0002J\u0010\u0010=\u001a\u00020\u001f2\u0006\u0010>\u001a\u00020?H\u0002J\n\u0010@\u001a\u0004\u0018\u00010\u0018H\u0002J\u000f\u0010A\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010BJ\n\u0010C\u001a\u0004\u0018\u00010\u0018H\u0002J\f\u0010D\u001a\u00020\u0018*\u00020EH\u0002J\f\u0010F\u001a\u00020\u0005*\u00020\u0018H\u0002J\b\u0010G\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010+\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0012\u0010-\u001a\u00020%X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010,\u00a8\u0006L"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "serverPort", "", "killedEbs", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;ILjava/lang/Long;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Ljava/lang/Long;", "resharperProcessHandler", "Lcom/intellij/execution/process/BaseOSProcessHandler;", "getResharperProcessHandler", "()Lcom/intellij/execution/process/BaseOSProcessHandler;", "setResharperProcessHandler", "(Lcom/intellij/execution/process/BaseOSProcessHandler;)V", "requestShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getRequestShutdown", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getDotNetPluginsXmlDescriptor", "", "getDotNetPluginsExtraDirs", "getExtraFlags", "", "getExtraEnvVars", "", "sanitizeEnvironment", "", "env", "", "prepareReSharperHostSystemDir", "environment", "isFirstReSharperHost", "", "waitFor", "async", "afterShutdown", "Lkotlin/Function0;", "copyReSharperSettings", "isInternal", "()Z", "isUnitTesting", "tryMoveDiagnosticReportToLogFolder", "pid", "createTemporaryLifetimedFile", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "prefix", "suffix", "getBackendLogConfig", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase$BackendLogConfiguration;", "isFirstRiderBackend", "patchBackendConfigFile", "Ljava/nio/file/Path;", "inputFile", "start", "contactSupport", "withBackendProfiling", "processBuilder", "Ljava/lang/ProcessBuilder;", "tryGetSnapshotKind", "getBucket", "()Ljava/lang/Integer;", "getOrGenerateDeviceId", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "asBucket", "getPathForBackendSettings", "PlaybackCrash", "BackendLogConfiguration", "VersionRecord", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/ReSharperProcessBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,923:1\n1#2:924\n216#3,2:925\n40#4,3:927\n24#5:930\n24#5:931\n24#5:934\n24#5:935\n14#5:949\n1310#6,2:932\n27#7,3:936\n30#7,7:941\n13#7:948\n1317#8,2:939\n*S KotlinDebug\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/ReSharperProcessBase\n*L\n517#1:925,2\n638#1:927,3\n646#1:930\n648#1:931\n655#1:934\n681#1:935\n834#1:949\n651#1:932,2\n239#1:936,3\n239#1:941,7\n834#1:948\n240#1:939,2\n*E\n"})
public abstract class ReSharperProcessBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    private final int serverPort;
    @Nullable
    private final Long killedEbs;
    public BaseOSProcessHandler resharperProcessHandler;
    @NotNull
    private final AtomicBoolean requestShutdown;
    @NotNull
    private static final Logger logger;
    private static int processIdIncrement;
    private static boolean shouldImportReSharperSettings;
    private static final long shutdownTimeout;
    @NotNull
    private static final Lazy<File> resharperHostConfigDir;
    @NotNull
    private static final Lazy<File> resharperHostSystemDir;
    @NotNull
    private static final Lazy<File> resharperHostSystemInvalidateFlag;

    public ReSharperProcessBase(@NotNull Lifetime lifetime, int serverPort, @Nullable Long killedEbs) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.serverPort = serverPort;
        this.killedEbs = killedEbs;
        this.requestShutdown = new AtomicBoolean(false);
    }

    public /* synthetic */ ReSharperProcessBase(Lifetime lifetime, int n, Long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = null;
        }
        this(lifetime, n, l);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final BaseOSProcessHandler getResharperProcessHandler() {
        BaseOSProcessHandler baseOSProcessHandler = this.resharperProcessHandler;
        if (baseOSProcessHandler != null) {
            return baseOSProcessHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resharperProcessHandler");
        return null;
    }

    public final void setResharperProcessHandler(@NotNull BaseOSProcessHandler baseOSProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)baseOSProcessHandler, (String)"<set-?>");
        this.resharperProcessHandler = baseOSProcessHandler;
    }

    @NotNull
    protected final AtomicBoolean getRequestShutdown() {
        return this.requestShutdown;
    }

    @NotNull
    public abstract String getDotNetPluginsXmlDescriptor();

    @NotNull
    public abstract String getDotNetPluginsExtraDirs();

    @NotNull
    public abstract List<String> getExtraFlags();

    @NotNull
    public abstract Map<String, String> getExtraEnvVars();

    private final void sanitizeEnvironment(Map<String, String> env) {
        env.remove("QODANA_LICENSE");
        env.remove("QODANA_TOKEN");
    }

    private final void prepareReSharperHostSystemDir(Map<String, String> environment, boolean isFirstReSharperHost) {
        File systemDir = (File)resharperHostSystemDir.getValue();
        if (isFirstReSharperHost && ((File)resharperHostSystemInvalidateFlag.getValue()).exists()) {
            logger.info("Found invalidate caches flag for R# host caches");
            logger.info("Erasing directory '" + systemDir + "'");
            try {
                if (!FileUtil.delete((File)systemDir)) {
                    logger.error("Directory '" + systemDir + "' wasn't fully deleted");
                }
            }
            catch (Throwable t) {
                logger.error("Unable to delete ReSharperHost caches directory '" + systemDir + "': " + t.getMessage(), t);
            }
        }
        systemDir.mkdirs();
        if (BundleBase.SHOW_LOCALIZED_MESSAGES) {
            environment.put("JET_I18N_DEBUG", "true");
        }
        environment.put("JET_LOCAL_APPDATA_DIR", FilesKt.resolve((File)systemDir, (String)"local").getAbsolutePath());
        environment.put("JET_ROAMING_APPDATA_DIR", FilesKt.resolve((File)systemDir, (String)"roaming").getAbsolutePath());
        environment.put("JET_TEMP_DIR", FilesKt.resolve((File)systemDir, (String)"temp").getAbsolutePath());
    }

    public final void waitFor(boolean async, @NotNull Function0<Unit> afterShutdown) {
        Intrinsics.checkNotNullParameter(afterShutdown, (String)"afterShutdown");
        Application app = ApplicationManager.getApplication();
        Function0 shutdownAction = () -> ReSharperProcessBase.waitFor$lambda$1(this, app, afterShutdown);
        if (async) {
            Future future = app.executeOnPooledThread(() -> ReSharperProcessBase.waitFor$lambda$2(shutdownAction));
            v1 = future;
            Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        } else {
            shutdownAction.invoke();
            v1 = Unit.INSTANCE;
        }
    }

    private final void copyReSharperSettings() {
        boolean isEnabled = SystemProperties.getBooleanProperty((String)"rider.enable.resharper.import", (boolean)true);
        if (!isEnabled) {
            logger.info("rider.enable.resharper.import is false, skip ReSharper setting import.");
            return;
        }
        if (PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode() || this.isUnitTesting()) {
            logger.info("Should not import resharper settings due to test environment");
            return;
        }
        if (!shouldImportReSharperSettings) {
            logger.info("Should not import resharper settings");
            return;
        }
        logger.info("Starting resharper settings import");
        if (!SystemInfo.isWindows) {
            return;
        }
        String globalSettingsStorageFile = "GlobalSettingsStorage.DotSettings";
        File riderGlobalSettingsStorage = FilesKt.resolve((File)((File)resharperHostConfigDir.getValue()), (String)globalSettingsStorageFile);
        if (riderGlobalSettingsStorage.exists()) {
            logger.info("Global settings file already exists for Rider => skipping copying resharper settings");
            return;
        }
        String appdata = System.getenv("APPDATA");
        if (appdata == null) {
            logger.error("%APPDATA% is not defined => skipping copying resharper settings");
            return;
        }
        String[] stringArray = new String[]{appdata, "JetBrains", "Shared", "vAny", globalSettingsStorageFile};
        String string = FileUtil.join((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        File resharperGlobalSettingsStorage = DocumentUtilKt.toIOFile(string);
        if (!resharperGlobalSettingsStorage.exists()) {
            logger.info("Global settings file (for ReSharper and .NET products) is not found at " + resharperGlobalSettingsStorage + " => skipping copying resharper settings");
            return;
        }
        try {
            FilesKt.copyTo$default((File)resharperGlobalSettingsStorage, (File)riderGlobalSettingsStorage, (boolean)false, (int)0, (int)4, null);
        }
        catch (Throwable t) {
            logger.error("Unable to copy resharper settings from " + resharperGlobalSettingsStorage + " to " + riderGlobalSettingsStorage, t);
        }
    }

    public final void requestShutdown() {
        this.requestShutdown.set(true);
    }

    public abstract boolean isInternal();

    public abstract boolean isUnitTesting();

    public final void tryMoveDiagnosticReportToLogFolder(long pid, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (!SystemInfo.isMac) {
            return;
        }
        HashSet scannedFiles = new HashSet();
        String pidStr = String.valueOf(pid);
        Regex pidRegex = new Regex("Process:\\s+dotnet\\s\\[(\\d+)]");
        File logDirectory = FilesKt.resolve((File)RiderEnvironment.INSTANCE.getLogDirectory(), (String)"DiagnosticReports");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ReSharperProcessBase.tryMoveDiagnosticReportToLogFolder$lambda$5(lifetime, scannedFiles, pidRegex, pidStr, logDirectory), (int)31, null);
    }

    private final File createTemporaryLifetimedFile(String prefix, String suffix) {
        File file;
        File it = file = FileUtil.createTempFile((String)prefix, (String)suffix);
        boolean bl = false;
        this.lifetime.onTermination(() -> ReSharperProcessBase.createTemporaryLifetimedFile$lambda$7$lambda$6(it));
        File file2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"also(...)");
        return file2;
    }

    private final BackendLogConfiguration getBackendLogConfig(boolean isFirstRiderBackend) {
        String envVar = System.getenv("RESHARPER_LOG_CONF");
        CharSequence charSequence = envVar;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Path path = Paths.get(envVar, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return new BackendLogConfiguration(true, path);
        }
        if (isFirstRiderBackend && PluginManagerCore.isRunningFromSources() && !this.isUnitTesting()) {
            Path backendLogConfigFile = this.patchBackendConfigFile(RiderEnvironment.INSTANCE.getBackendLogXmlPath());
            return new BackendLogConfiguration(false, backendLogConfigFile);
        }
        return new BackendLogConfiguration(true, RiderEnvironment.INSTANCE.getBackendLogXmlPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path patchBackendConfigFile(Path inputFile) {
        Object factory;
        try {
            factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = ((DocumentBuilderFactory)factory).newDocumentBuilder();
            Document document = builder.parse(inputFile.toFile());
            XPathFactory xPathFactory = XPathFactory.newInstance();
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)"file_verbose", (Object)"{env.RESHARPER_HOST_LOG_DIR}/backend.log"), TuplesKt.to((Object)"file_protocol", (Object)"{env.RESHARPER_HOST_LOG_DIR}/backend-protocol.log")};
            List appendersToReplace = CollectionsKt.listOf((Object[])objectArray);
            boolean anyReplaced = false;
            for (Object object : appendersToReplace) {
                Node node;
                String appenderName = (String)object.component1();
                String logFilePath = (String)object.component2();
                XPathExpression xPath = xPathFactory.newXPath().compile("/configuration/appender[@name='" + appenderName + "']/arg");
                Object object2 = xPath.evaluate(document, XPathConstants.NODE);
                Node node2 = node = object2 instanceof Node ? (Node)object2 : null;
                if (node == null) {
                    logger.warn("Cannot find file_verbose appender in config file \"" + inputFile + "\".");
                    continue;
                }
                node.setTextContent(logFilePath);
                anyReplaced = true;
            }
            if (!anyReplaced) {
                return inputFile;
            }
            factory = document;
        }
        catch (SAXParseException e) {
            logger.error("Unable to parse the log configuration at \"" + inputFile + "\".", (Throwable)e);
            return inputFile;
        }
        Object patchedContent = factory;
        File tempConfigFile = this.createTemporaryLifetimedFile("riderBackendLogConfig", ".xml");
        Closeable closeable = new FileOutputStream(tempConfigFile);
        Throwable throwable = null;
        try {
            Object object;
            FileOutputStream stream = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new OutputStreamWriter((OutputStream)stream, Charsets.UTF_8);
            Object object3 = null;
            try {
                Transformer transformer;
                OutputStreamWriter writer = (OutputStreamWriter)closeable2;
                boolean bl2 = false;
                Transformer $this$patchBackendConfigFile_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = transformer = TransformerFactory.newInstance().newTransformer();
                boolean bl3 = false;
                $this$patchBackendConfigFile_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setOutputProperty("omit-xml-declaration", "yes");
                $this$patchBackendConfigFile_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setOutputProperty("indent", "no");
                $this$patchBackendConfigFile_u24lambda_u2410_u24lambda_u249_u24lambda_u248.transform(new DOMSource((Node)patchedContent), new StreamResult(writer));
                object = transformer;
            }
            catch (Throwable throwable2) {
                try {
                    object3 = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)closeable2, object3);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object3);
            Object object4 = object;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        logger.info("Temporary backend configuration file emitted at \"" + tempConfigFile + "\".");
        Path path = tempConfigFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    public final void start() {
        String string;
        boolean overrideReSharperPaths;
        Object productCode;
        Object build2;
        Object object;
        String string2;
        Map<String, String> map;
        String string3;
        this.copyReSharperSettings();
        try {
            string3 = RiderEnvironment.INSTANCE.getRiderBackendExecutable().getPath();
        }
        catch (Exception ex) {
            ApplicationManager.getApplication().putUserData(ProtocolKeys.Companion.getProtocolManagerErrorKey(), (Object)ex.getMessage());
            logger.error((Throwable)ex);
            return;
        }
        String executable = string3;
        Intrinsics.checkNotNull((Object)executable);
        ProcessBuilder processBuilder = RiderEnvironment.INSTANCE.createProcessBuilderForAssembly(executable, new String[0]);
        if (Intrinsics.areEqual((Object)System.getProperty("dotcover.enabled"), (Object)"true")) {
            String dotcoverStuff = System.getProperty("dotcover.output.path");
            if (System.getProperty("dotcover.output.path") == null) {
                dotcoverStuff = FilesKt.resolve((File)RiderEnvironment.INSTANCE.getLogDirectory(), (String)"dotcover").getAbsolutePath();
            }
            reportFileNameTemplate = dotcoverStuff + File.separator + System.nanoTime();
            processBuilder.command().remove(0);
            processBuilder.command().add(System.getProperty("dotcover.exe.path"));
            processBuilder.command().add("cover");
            processBuilder.command().add("/TargetExecutable=" + executable);
            if (Intrinsics.areEqual((Object)System.getProperty("dotcover.report.type"), (Object)"dcvr")) {
                v0 = processBuilder.command().add("/Output=" + (String)reportFileNameTemplate + ".dcvr");
            } else {
                processBuilder.command().add("/Output=" + (String)reportFileNameTemplate + ".html");
                processBuilder.command().add("/ReportType=\"HTML\"");
                v0 = System.getProperty("dotcover.sources.search.paths") != null ? processBuilder.command().add("/SourcesSearchPaths=" + System.getProperty("dotcover.sources.search.paths")) : processBuilder.command().add("/SourcesSearchPaths=" + PathManager.getHomePath() + "\\..\\");
            }
            processBuilder.command().add("/LogFile=" + (String)reportFileNameTemplate + ".log");
            processBuilder.command().add("/LogLevel=Verbose");
            processBuilder.command().add("/ProcessFilters=+:JetBrains*");
            processBuilder.command().add("--");
        } else if (System.getenv("RESHARPER_HOST_DEBUG_SELF_CMD_LINE") != null) {
            processBuilder.command().add(0, "--");
            Iterator<Map.Entry<String, String>> debuggerWorkerCommandLine = System.getenv("RESHARPER_HOST_DEBUG_SELF_CMD_LINE");
            logger.info("RESHARPER_HOST_DEBUG_SELF_CMD_LINE: " + (String)((Object)debuggerWorkerCommandLine));
            List<String> list2 = processBuilder.command();
            Intrinsics.checkNotNull((Object)debuggerWorkerCommandLine);
            reportFileNameTemplate = new char[1];
            reportFileNameTemplate[0] = 10;
            list2.addAll(0, StringsKt.split$default((CharSequence)((CharSequence)((Object)debuggerWorkerCommandLine)), (char[])reportFileNameTemplate, (boolean)false, (int)0, (int)6, null));
        } else if (this.tryGetSnapshotKind() != null) {
            this.withBackendProfiling(processBuilder);
        }
        processBuilder.command().add("--Port=" + this.serverPort);
        if (this.isUnitTesting()) {
            processBuilder.command().add("--UnitTests");
        }
        if (PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode()) {
            processBuilder.command().add("--PerfTests");
        }
        if (this.isInternal()) {
            processBuilder.command().add("--Internal");
        }
        for (String flag : this.getExtraFlags()) {
            processBuilder.command().add(flag);
        }
        for (Map.Entry<String, String> envVar : this.getExtraEnvVars().entrySet()) {
            Map<String, String> map2;
            Intrinsics.checkNotNullExpressionValue(processBuilder.environment(), (String)"environment(...)");
            map = envVar.getKey();
            string2 = envVar.getValue();
            map2.put((String)((Object)map), string2);
        }
        File pluginXmlDescriptorFileName = this.createTemporaryLifetimedFile("AdditionalDeployedPackages", ".xml");
        String xml = this.getDotNetPluginsXmlDescriptor();
        FilesKt.writeText$default((File)pluginXmlDescriptorFileName, (String)xml, null, (int)2, null);
        String extraDirs = this.getDotNetPluginsExtraDirs();
        if (!Intrinsics.areEqual((Object)xml, (Object)"") || !Intrinsics.areEqual((Object)extraDirs, (Object)"")) {
            Map<String, String> map3 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"environment(...)");
            map = map3;
            string2 = "JET_ADDITIONAL_DEPLOYED_PACKAGES_FILE";
            String string4 = pluginXmlDescriptorFileName.getAbsolutePath();
            map.put(string2, string4);
            Map<String, String> map4 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map4, (String)"environment(...)");
            map = map4;
            map.put("RIDER_PLUGIN_ADDITIONAL_PROBING_PATHS", extraDirs);
        }
        int n = processIdIncrement;
        processIdIncrement = n + 1;
        int processId = n;
        boolean isFirstBackendProcess = processId == 0;
        BackendLogConfiguration backendLogConfiguration = this.getBackendLogConfig(isFirstBackendProcess);
        Map<String, String> map5 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map5, (String)"environment(...)");
        Map<String, String> map6 = map5;
        Map<String, String> map7 = "RESHARPER_LOG_CONF";
        Map<String, String> map8 = ((Object)backendLogConfiguration.getLogConfigurationFilePath()).toString();
        map6.put((String)((Object)map7), (String)((Object)map8));
        String overriddenReSharperSettingsDir = this.getPathForBackendSettings();
        Map<String, String> map9 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map9, (String)"environment(...)");
        map7 = map9;
        map7.put("RESHARPER_HOST_CONFIG_DIR", overriddenReSharperSettingsDir);
        Map<String, String> map10 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map10, (String)"environment(...)");
        map7 = map10;
        map8 = "RESHARPER_HOST_LOG_DIR";
        Map<String, String> map11 = RiderEnvironment.INSTANCE.getLogDirectory().getAbsolutePath();
        map7.put((String)((Object)map8), (String)((Object)map11));
        Map<String, String> map12 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map12, (String)"environment(...)");
        map7 = map12;
        map8 = "RESHARPER_HOST_PARENT_PROCESS_PID";
        map11 = String.valueOf(ProcessHandle.current().pid());
        map7.put((String)((Object)map8), (String)((Object)map11));
        if (!DisableCppAction.Companion.getEnabledCpp()) {
            Map<String, String> map13 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map13, (String)"environment(...)");
            map7 = map13;
            map8 = "RESHARPER_CPP_DISABLE";
            map11 = "True";
            map7.put((String)((Object)map8), (String)((Object)map11));
        }
        try {
            VersionRecord version = new VersionRecord();
            XmlElement xmlElement = ApplicationNamesInfo.initAndGetRawData();
            Intrinsics.checkNotNullExpressionValue((Object)xmlElement, (String)"initAndGetRawData(...)");
            version.loadState$intellij_rider_rdclient_dotnet(xmlElement);
            Map<String, String> map14 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map14, (String)"environment(...)");
            map8 = map14;
            map11 = "RESHARPER_REPORT_VERSION";
            object = version.getFullVersion();
            map8.put((String)((Object)map11), (String)object);
        }
        catch (Throwable version) {
            // empty catch block
        }
        try {
            boolean bl;
            BuildNumber buildNumber = ApplicationInfoImpl.getShadowInstance().getBuild();
            Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
            build2 = buildNumber;
            Map<String, String> map15 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map15, (String)"environment(...)");
            map8 = map15;
            map11 = "RESHARPER_FUS_BUILD";
            object = this.asBuildNumber((BuildNumber)build2);
            map8.put((String)((Object)map11), (String)object);
            String string5 = build2.getProductCode();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getProductCode(...)");
            productCode = string5;
            boolean bl2 = bl = ((String)productCode).length() < 10;
            if (_Assertions.ENABLED && !bl) {
                object = "Assertion failed";
                throw new AssertionError(object);
            }
            Map<String, String> map16 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map16, (String)"environment(...)");
            map11 = map16;
            map11.put("RESHARPER_FRONT_PRODUCT_CODE", (String)productCode);
        }
        catch (Throwable build2) {
            // empty catch block
        }
        try {
            String installationId;
            String deviceId;
            Object bucket;
            Map<String, String> map17 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map17, (String)"environment(...)");
            build2 = map17;
            productCode = "JET_HEADLESS_MODE";
            map11 = AppMode.isHeadless() ? "true" : "false";
            build2.put(productCode, map11);
            if (AppMode.isHeadless()) {
                Map<String, String> map18 = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map18, (String)"environment(...)");
                build2 = map18;
                productCode = "RESHARPER_FUS_HEADLESS";
                map11 = "true";
                build2.put(productCode, map11);
            }
            Map<String, String> map19 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map19, (String)"environment(...)");
            build2 = map19;
            productCode = "RESHARPER_FUS_SALT";
            map11 = Base64.getEncoder().encodeToString(EventLogConfiguration.Companion.getOrGenerateSaltFromPrefs("FUS"));
            build2.put(productCode, map11);
            Map<String, String> map20 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map20, (String)"environment(...)");
            build2 = map20;
            productCode = "RESHARPER_FUS_SESSION";
            map11 = EventLogConfiguration.Companion.getDefaultSessionId();
            build2.put(productCode, map11);
            if (this.killedEbs != null) {
                Map<String, String> map21 = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map21, (String)"environment(...)");
                build2 = map21;
                productCode = "RESHARPER_FUS_IGNOREPID";
                map11 = this.killedEbs.toString();
                build2.put(productCode, map11);
            }
            if (!AppMode.isHeadless()) {
                bucket = this.getBucket();
                if (bucket != null) {
                    Map<String, String> map22 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map22, (String)"environment(...)");
                    productCode = map22;
                    map11 = "RESHARPER_FUS_BUCKET";
                    object = ((Integer)bucket).toString();
                    productCode.put(map11, object);
                }
                if ((deviceId = this.getOrGenerateDeviceId()) != null) {
                    Map<String, String> map23 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map23, (String)"environment(...)");
                    map11 = map23;
                    map11.put("RESHARPER_FUS_DEVICEID", deviceId);
                }
                String string6 = PermanentInstallationID.get();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"get(...)");
                installationId = string6;
                Map<String, String> map24 = processBuilder.environment();
                Intrinsics.checkNotNullExpressionValue(map24, (String)"environment(...)");
                object = map24;
                object.put("RESHARPER_FUS_USERID", installationId);
            }
            if (this.isInternal()) {
                if (Boolean.getBoolean("fus.internal.test.mode") || !((bucket = (CharSequence)System.getProperty("fus.recorder.internal.test.mode")) == null || StringsKt.isBlank(bucket))) {
                    Map<String, String> map25 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map25, (String)"environment(...)");
                    bucket = map25;
                    deviceId = "JETBRAINS_FUS_TRACE";
                    installationId = "true";
                    bucket.put((String)deviceId, (String)installationId);
                }
                if (SystemProperties.getBooleanProperty((String)"fus.internal.disable.data.submit", (boolean)false)) {
                    Map<String, String> map26 = processBuilder.environment();
                    Intrinsics.checkNotNullExpressionValue(map26, (String)"environment(...)");
                    bucket = map26;
                    deviceId = "JETBRAINS_FUS_DISABLE_DATA_SUBMIT";
                    installationId = "true";
                    bucket.put((String)deviceId, (String)installationId);
                }
            }
        }
        catch (Throwable t) {
            logger.error(t);
        }
        boolean bl = overrideReSharperPaths = ((CharSequence)overriddenReSharperSettingsDir).length() > 0;
        if (overrideReSharperPaths) {
            Map<String, String> map27 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map27, (String)"environment(...)");
            this.prepareReSharperHostSystemDir(map27, isFirstBackendProcess);
        }
        Map<String, String> map28 = processBuilder.environment();
        Intrinsics.checkNotNullExpressionValue(map28, (String)"environment(...)");
        this.sanitizeEnvironment(map28);
        Map<String, String> envVars = processBuilder.environment();
        String string7 = LocaleHelper.INSTANCE.getLocale();
        if (string7 != null) {
            String it = string7;
            boolean bl3 = false;
            Intrinsics.checkNotNull(envVars);
            envVars.put("JET_BACKEND_CULTURE", it);
        }
        List<String> list3 = processBuilder.command();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"command(...)");
        String commandLine = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        logger.info("Start " + commandLine);
        if (logger.isTraceEnabled()) {
            logger.trace("Working directory: " + processBuilder.directory());
            Map<String, String> map29 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map29, (String)"environment(...)");
            if (!map29.isEmpty()) {
                logger.trace("Environment variables: ");
            }
            Map<String, String> map30 = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map30, (String)"environment(...)");
            Map<String, String> $this$forEach$iv = map30;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry2 = element$iv = iterator2.next();
                boolean bl4 = false;
                String k = entry2.getKey();
                String v = entry2.getValue();
                logger.trace("  " + k + "=" + v);
            }
        }
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = processBuilder.start();
        long pid = process.pid();
        if (FileUtil.createDirectory((File)RiderEnvironment.INSTANCE.getLogDirectory())) {
            logger.info("Log directory created: " + RiderEnvironment.INSTANCE.getLogDirectory());
        }
        if (backendLogConfiguration.isPidIncludedInLogFileName()) {
            ProcessHandle processHandle = process.toHandle();
            Intrinsics.checkNotNullExpressionValue((Object)processHandle, (String)"toHandle(...)");
            string = Companion.defaultLogFileNameBase(processHandle);
        } else {
            string = "backend";
        }
        String backendLogFileNameBase = string;
        File outFile = new File(RiderEnvironment.INSTANCE.getLogDirectory(), backendLogFileNameBase + "-out.log");
        File errFile = new File(RiderEnvironment.INSTANCE.getLogDirectory(), backendLogFileNameBase + "-err.log");
        this.setResharperProcessHandler(new BaseOSProcessHandler(process, commandLine, outFile, errFile){
            final /* synthetic */ File $outFile;
            final /* synthetic */ File $errFile;
            {
                this.$outFile = $outFile;
                this.$errFile = $errFile;
                super($process, $commandLine, null);
            }

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }

            public void notifyTextAvailable(String text, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                Key<?> key = outputType;
                if (Intrinsics.areEqual(key, (Object)ProcessOutputType.STDOUT)) {
                    FilesKt.appendText$default((File)this.$outFile, (String)text, null, (int)2, null);
                } else if (Intrinsics.areEqual(key, (Object)ProcessOutputType.STDERR)) {
                    FilesKt.appendText$default((File)this.$errFile, (String)text, null, (int)2, null);
                } else if (Intrinsics.areEqual(key, (Object)ProcessOutputType.SYSTEM)) {
                    FilesKt.appendText$default((File)this.$errFile, (String)text, null, (int)2, null);
                } else {
                    ReSharperProcessBase.access$getLogger$cp().error("Unknown process output type for text: '" + text + "'");
                }
                super.notifyTextAvailable(text, outputType);
            }
        });
        LifetimeDefinition processDefinition = new LifetimeDefinition();
        ProcessAdapter processListener2 = new ProcessAdapter(this, processDefinition, pid, errFile){
            final /* synthetic */ ReSharperProcessBase this$0;
            final /* synthetic */ LifetimeDefinition $processDefinition;
            final /* synthetic */ long $pid;
            final /* synthetic */ File $errFile;
            {
                this.this$0 = $receiver;
                this.$processDefinition = $processDefinition;
                this.$pid = $pid;
                this.$errFile = $errFile;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getResharperProcessHandler().removeProcessListener((ProcessListener)this);
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$processDefinition, (boolean)false, (int)1, null);
                int exitCode = event.getExitCode();
                if (this.this$0.getRequestShutdown().get() || !RLifetimeKt.isAlive((Lifetime)this.this$0.getLifetime())) {
                    String message = "Rider host process has exited by request with exit code " + exitCode;
                    if (exitCode == 0) {
                        ReSharperProcessBase.access$getLogger$cp().info(message);
                    } else {
                        ReSharperProcessBase.access$getLogger$cp().warn(message);
                    }
                    return;
                }
                this.this$0.tryMoveDiagnosticReportToLogFolder(this.$pid, this.this$0.getLifetime());
                Attachment[] message = new Attachment[]{new Attachment("backend-err.log", FilesKt.readText$default((File)this.$errFile, null, (int)1, null))};
                ReSharperProcessBase.access$getLogger$cp().error("Rider host (PID = " + this.$pid + ") has unexpectedly exited with exit code " + exitCode + ".", message);
                if (PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode()) {
                    ReSharperProcessBase.access$getLogger$cp().info("Perform exitProcess(6)");
                    String terminationDirectory = System.getenv("PROCESS_REQUEST_TERMINATION");
                    if (terminationDirectory != null) {
                        File file = FilesKt.resolve((File)new File(terminationDirectory), (String)String.valueOf(OSProcessUtil.getCurrentProcessId()));
                        ReSharperProcessBase.access$getLogger$cp().warn("Request force termination. file: " + file);
                        FilesKt.writeText$default((File)file, (String)"6", null, (int)2, null);
                    }
                    System.exit(6);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                CriticalErrorApplicationTerminator.Companion.invokeLaterAfterAppStarted((Function1<? super ApplicationEx, Unit>)((Function1)arg_0 -> start.processListener.1.processTerminated$lambda$2(this.this$0, this.$errFile, arg_0)));
            }

            private static final String processTerminated$lambda$2$lambda$0(BackendCrashAnalyzer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.tryGetFailReason();
            }

            private static final Unit processTerminated$lambda$2(ReSharperProcessBase this$0, File $errFile, ApplicationEx appEx) {
                Object[] objectArray;
                Intrinsics.checkNotNullParameter((Object)appEx, (String)"appEx");
                List possibleReasons = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])BackendCrashDiagnostics.Companion.getEP_NAME().getExtensions()), start.processListener.1::processTerminated$lambda$2$lambda$0));
                StringBuilder message = new StringBuilder();
                if (!((Collection)possibleReasons).isEmpty()) {
                    $this$forEach$iv = possibleReasons;
                    boolean $i$f$forEach = false;
                    objectArray = $this$forEach$iv.iterator();
                    while (objectArray.hasNext()) {
                        T element$iv = objectArray.next();
                        String it = (String)element$iv;
                        boolean bl = false;
                        StringBuilder stringBuilder = message.append(it);
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                    }
                    v1 = Unit.INSTANCE;
                } else {
                    StringBuilder stringBuilder = message.append(RdClientDotnetBundle.INSTANCE.message("dialog.message.you.can.continue.to.work.but.full.functionality.will.be.available.after.restart", new Object[0]));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
                    $this$forEach$iv = message;
                    Object[] objectArray2 = new Object[]{ApplicationNamesInfo.getInstance().getProductName()};
                    StringBuilder stringBuilder2 = ((StringBuilder)$this$forEach$iv).append(RdClientDotnetBundle.INSTANCE.message("dialog.message.please.contact.ide.support.attach.zipped.log.folder", objectArray2));
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                    v1 = stringBuilder3;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                }
                String[] stringArray = new String[4];
                stringArray[0] = Messages.getOkButton();
                stringArray[1] = RdClientDotnetBundle.INSTANCE.message("button.restart", new Object[0]);
                stringArray[2] = RdClientDotnetBundle.INSTANCE.message("button.contact.support", new Object[0]);
                objectArray = new Object[]{RevealFileAction.getFileManagerName()};
                stringArray[3] = RdClientDotnetBundle.INSTANCE.message("button.show.log.in", objectArray);
                int dialogResult = MessagesEx.showDialog((String)message.toString(), (String)RdClientDotnetBundle.INSTANCE.message("dialog.title.critical.failure.has.occurred", new Object[0]), (String[])stringArray, (int)0, (Icon)UIUtil.getErrorIcon());
                switch (dialogResult) {
                    case 1: {
                        appEx.exit(true, false, true);
                        break;
                    }
                    case 2: {
                        ReSharperProcessBase.access$contactSupport(this$0);
                        break;
                    }
                    case 3: {
                        RevealFileAction.openFile((File)$errFile);
                        break;
                    }
                    default: {
                        return Unit.INSTANCE;
                    }
                }
                return Unit.INSTANCE;
            }
        };
        this.getResharperProcessHandler().addProcessListener((ProcessListener)processListener2);
        this.getResharperProcessHandler().startNotify();
        RiderEnvironment.INSTANCE.addRiderBackendProcess(this.getResharperProcessHandler());
        DotnetSelfProfilingProcesses.INSTANCE.add(processDefinition.getLifetime(), "Rider.Backend", (int)this.getResharperProcessHandler().getProcess().pid());
        logger.info("Rider backend PID: " + process.pid());
        if (this.getResharperProcessHandler().isProcessTerminated()) {
            logger.error("Rider host exited while initializing. See " + errFile);
        }
    }

    private final void contactSupport() {
        block1: {
            Function1 function1 = ExternalProductResourceUrls.Companion.getInstance().getTechnicalSupportUrl();
            if (function1 == null) break block1;
            Function1 url2 = function1;
            boolean bl = false;
            boolean $i$f$service = false;
            Class<ReportFeedbackService> serviceClass$iv = ReportFeedbackService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            BuildersKt.launch$default((CoroutineScope)((ReportFeedbackService)object).getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super String, ? extends Url>)url2, null){
                Object L$0;
                int label;
                final /* synthetic */ Function1<String, Url> $url;
                {
                    this.$url = $url;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.L$0 = var2_3 = this.$url;
                            this.label = 1;
                            v0 = SendFeedbackAction.Companion.getDescription(null, (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl15
                        }
                        case 1: {
                            var2_3 = (Function1<String, Url>)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl15:
                            // 2 sources

                            BrowserUtil.browse((String)((Url)var2_3.invoke(v0)).toExternalForm());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void withBackendProfiling(ProcessBuilder processBuilder) {
        SnapshotKind kind;
        Object it;
        File customSelfProfilingToolLocation;
        File snapshotDir;
        String snapshotKind;
        block5: {
            SnapshotKind snapshotKind2;
            snapshotKind = this.tryGetSnapshotKind();
            ReSharperProcessBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("SnapshotKind: " + snapshotKind);
            String string = System.getProperty("rider.backend.JET_SNAPSHOT_DIR");
            if (string == null) {
                string = FilesKt.resolve((File)RiderEnvironment.INSTANCE.getLogDirectory(), (String)"BackendSnapshot").getAbsolutePath();
            }
            snapshotDir = new File(string);
            ReSharperProcessBase $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.info("snapshotDir: " + snapshotDir);
            customSelfProfilingToolLocation = DotnetSelfProfiler.Companion.getDefaultSelfProfilingToolLocation();
            SnapshotKind[] $this$firstOrNull$iv = SnapshotKind.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                SnapshotKind element$iv;
                it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)snapshotKind, (boolean)true)) continue;
                snapshotKind2 = element$iv;
                break block5;
            }
            snapshotKind2 = kind = null;
        }
        if (kind != null) {
            File profilerFile = FilesKt.resolve((File)customSelfProfilingToolLocation, (String)"dottrace.exe");
            if (!profilerFile.exists()) {
                ReSharperProcessBase $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ReSharperProcessBase.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("ProfilerFile: " + profilerFile + " doesn't exist");
                return;
            }
            String name = kind + " " + OffsetDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss"));
            File file = FileUtil.createTempDirectory((File)snapshotDir, (String)name, null, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
            File tempDir = file;
            List<String> args = ReSharperProcessBase.withBackendProfiling$getArgs(profilerFile, kind, tempDir);
            processBuilder.command().addAll(0, (Collection<String>)args);
            processBuilder.command().add(args.size() + 1, "--");
            it = DotnetSelfProfiler.Companion.getRiderBackendProfilerAdditionalProbingPaths();
            boolean bl = false;
            Map<String, String> map = processBuilder.environment();
            Intrinsics.checkNotNullExpressionValue(map, (String)"environment(...)");
            Map<String, String> map2 = map;
            map2.put("RIDER_BACKEND_PROFILER_ADDITIONAL_PROBING_PATHS", (String)it);
        } else {
            ReSharperProcessBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ReSharperProcessBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("snapshotKind: " + snapshotKind + " is unknown");
        }
    }

    private final String tryGetSnapshotKind() {
        return System.getProperty("rider.backend.JET_RUN_WITH_SNAPSHOT");
    }

    private final Integer getBucket() {
        String string = this.getOrGenerateDeviceId();
        if (string == null) {
            return null;
        }
        String deviceId = string;
        return this.asBucket(deviceId);
    }

    private final String getOrGenerateDeviceId() {
        String string;
        String recorderId = "FUS";
        try {
            string = DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)recorderId);
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException invalidDeviceIdTokenException) {
            logger.warn("Failed retrieving device id for " + recorderId);
            string = null;
        }
        catch (IllegalArgumentException e) {
            String string2;
            if (StringsKt.contains$default((CharSequence)String.valueOf(e.getMessage()), (CharSequence)"U+0000", (boolean)false, (int)2, null)) {
                Preferences prefs = Preferences.userRoot().node("jetbrains");
                prefs.remove("device_id");
                if (SystemInfo.isWindows) {
                    try {
                        File permanentIdFile;
                        File dir;
                        String appdata = System.getenv("APPDATA");
                        if (appdata != null && (dir = new File(appdata, "JetBrains")).exists() && (permanentIdFile = new File(dir, "PermanentDeviceId")).exists()) {
                            permanentIdFile.delete();
                        }
                    }
                    catch (Exception appdata) {
                        // empty catch block
                    }
                }
            }
            logger.error("Had to clear device_id");
            try {
                string2 = DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)recorderId);
            }
            catch (DeviceIdManager.InvalidDeviceIdTokenException invalidDeviceIdTokenException) {
                logger.warn("Failed retrieving device id for " + recorderId);
                string2 = null;
            }
            string = string2;
        }
        return string;
    }

    private final String asBuildNumber(BuildNumber $this$asBuildNumber) {
        String string = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCodeAndSnapshot(...)");
        String str = string;
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getPathForBackendSettings() {
        String result2 = ((File)resharperHostConfigDir.getValue()).getAbsolutePath();
        try {
            File file = new File(PathManager.getConfigPath(), "options\\resharper.xml");
            if (!file.exists()) {
                String string = result2;
                Intrinsics.checkNotNull((Object)string);
                return string;
            }
            char[] cArray = FileUtil.loadFileText((File)file, (Charset)StandardCharsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"loadFileText(...)");
            Object object = cArray;
            String loadFileText = new String((char[])object);
            object = StringsKt.lines((CharSequence)loadFileText).iterator();
            while (object.hasNext()) {
                String line = (String)object.next();
                if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"syncWithReSharper", (boolean)false, (int)2, null)) continue;
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)"true", (boolean)false, (int)2, null)) {
                    result2 = "";
                }
                break;
            }
        }
        catch (Throwable t) {
            logger.warn("could not parse ide.general.xml with exception:\n", t);
            String string = result2;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        logger.info("successfully parsed resharper.xml. Backend's config path will be '" + result2 + "'");
        String string = result2;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private static final void waitFor$lambda$1$lambda$0(Function0 $afterShutdown) {
        $afterShutdown.invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit waitFor$lambda$1(ReSharperProcessBase this$0, Application $app, Function0 $afterShutdown) {
        try {
            if (!this$0.getResharperProcessHandler().isProcessTerminated() && !this$0.getResharperProcessHandler().waitFor(shutdownTimeout)) {
                long pid = this$0.getResharperProcessHandler().getProcess().pid();
                String message = "Rider backend process (PID: " + pid + ") has not gracefully exited within " + shutdownTimeout;
                logger.error(message + " ms and will be killed");
                ClrProcessThreadDumpUtilKt.requestThreadDumpForClrProcessesBlocking$default(CollectThreadDumpRequest.Companion.automaticAllowMainThread(message), pid, null, 4, null);
                this$0.getResharperProcessHandler().destroyProcess();
            }
        }
        finally {
            if ($app.isDispatchThread()) {
                $afterShutdown.invoke();
            } else {
                $app.invokeLater(() -> ReSharperProcessBase.waitFor$lambda$1$lambda$0($afterShutdown));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void waitFor$lambda$2(Function0 $shutdownAction) {
        $shutdownAction.invoke();
    }

    private static final Unit tryMoveDiagnosticReportToLogFolder$lambda$5(Lifetime $lifetime, HashSet $scannedFiles, Regex $pidRegex, String $pidStr, File $logDirectory) {
        for (int i = 1; i < 11; ++i) {
            Unit unit;
            Thread.sleep(500L);
            if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
                return Unit.INSTANCE;
            }
            logger.info("Attempt " + i + " to attach crash report");
            Logger $this$catchWarn_u24default$iv = logger;
            String message$iv = null;
            boolean $i$f$catchWarn = false;
            try {
                boolean bl = false;
                Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)new File(System.getProperty("user.home"), "Library/Logs/DiagnosticReports"), null, (int)1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MatchResult m;
                    File reportFile = (File)element$iv;
                    boolean bl2 = false;
                    if (RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
                        return Unit.INSTANCE;
                    }
                    if ($scannedFiles.contains(reportFile.getAbsolutePath())) continue;
                    $scannedFiles.add(reportFile.getAbsolutePath());
                    if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)reportFile), (Object)"crash") || System.currentTimeMillis() - reportFile.lastModified() > 60000L) continue;
                    String string = reportFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"dotnet_", (boolean)false, (int)2, null)) continue;
                    File file = reportFile;
                    Charset charset = Charsets.UTF_8;
                    int n = 8192;
                    Object object = file;
                    String firstLine = ((object = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object), charset)) instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)).readLine();
                    System.out.println((Object)firstLine);
                    Intrinsics.checkNotNull((Object)firstLine);
                    if (Regex.find$default((Regex)$pidRegex, (CharSequence)firstLine, (int)0, (int)2, null) == null || !Intrinsics.areEqual(m.getGroupValues().get(1), (Object)$pidStr)) continue;
                    if (!$logDirectory.exists()) {
                        $logDirectory.mkdirs();
                    }
                    String string2 = reportFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    File backendCrashReport = FilesKt.resolve((File)$logDirectory, (String)string2);
                    FilesKt.copyTo$default((File)reportFile, (File)backendCrashReport, (boolean)false, (int)0, (int)6, null);
                    Attachment[] attachmentArray = new Attachment[]{new Attachment(reportFile.getName(), FilesKt.readText$default((File)reportFile, null, (int)1, null))};
                    logger.error("Rider backend crashed", attachmentArray);
                    return Unit.INSTANCE;
                }
                unit = Unit.INSTANCE;
                continue;
            }
            catch (ProcessCanceledException e$iv) {
                throw e$iv;
            }
            catch (CancellationException e$iv) {
                throw e$iv;
            }
            catch (Throwable e$iv) {
                $this$catchWarn_u24default$iv.warn(message$iv, e$iv);
                unit = null;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTemporaryLifetimedFile$lambda$7$lambda$6(File $it) {
        try {
            $it.delete();
        }
        catch (Throwable ex) {
            logger.warn("Can't delete " + $it, ex);
        }
        return Unit.INSTANCE;
    }

    private static final List<String> withBackendProfiling$getArgs(File profilerFile, SnapshotKind kind, File tempDir) {
        Object[] objectArray = new String[]{profilerFile.getCanonicalPath(), "start", "--profiling-type=" + kind, "--save-to=" + tempDir};
        List args = CollectionsKt.listOf((Object[])objectArray);
        if (SystemInfo.isWindows) {
            return args;
        }
        String runtime = NetCoreRuntime.INSTANCE.getBundledDotnetCoreRuntime(NetCoreUtil.INSTANCE.getPlatformId());
        Object object = new String[]{runtime};
        Object $this$withBackendProfiling_u24getArgs_u24lambda_u2415 = object = CollectionsKt.mutableListOf((Object[])object);
        boolean bl = false;
        $this$withBackendProfiling_u24getArgs_u24lambda_u2415.addAll(args);
        $this$withBackendProfiling_u24getArgs_u24lambda_u2415.add("--no-check-for-updates");
        $this$withBackendProfiling_u24getArgs_u24lambda_u2415.add("--framework=NetCore");
        return object;
    }

    private static final File resharperHostConfigDir$lambda$17() {
        return new File(PathManager.getConfigPath(), "resharper-host");
    }

    private static final File resharperHostSystemDir$lambda$18() {
        return new File(PathManager.getSystemPath(), "resharper-host");
    }

    private static final File resharperHostSystemInvalidateFlag$lambda$19() {
        return FilesKt.resolve((File)((File)resharperHostSystemDir.getValue()), (String)".invalidate.all");
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$contactSupport(ReSharperProcessBase $this) {
        $this.contactSupport();
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReSharperProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ReSharperProcessBase.logger = logger;
        shouldImportReSharperSettings = true;
        shutdownTimeout = Duration.ofMinutes(1L).toMillis();
        resharperHostConfigDir = LazyKt.lazy(ReSharperProcessBase::resharperHostConfigDir$lambda$17);
        resharperHostSystemDir = LazyKt.lazy(ReSharperProcessBase::resharperHostSystemDir$lambda$18);
        resharperHostSystemInvalidateFlag = LazyKt.lazy(ReSharperProcessBase::resharperHostSystemInvalidateFlag$lambda$19);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$BackendLogConfiguration;", "", "isPidIncludedInLogFileName", "", "logConfigurationFilePath", "Ljava/nio/file/Path;", "<init>", "(ZLjava/nio/file/Path;)V", "()Z", "getLogConfigurationFilePath", "()Ljava/nio/file/Path;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class BackendLogConfiguration {
        private final boolean isPidIncludedInLogFileName;
        @NotNull
        private final Path logConfigurationFilePath;

        public BackendLogConfiguration(boolean isPidIncludedInLogFileName, @NotNull Path logConfigurationFilePath) {
            Intrinsics.checkNotNullParameter((Object)logConfigurationFilePath, (String)"logConfigurationFilePath");
            this.isPidIncludedInLogFileName = isPidIncludedInLogFileName;
            this.logConfigurationFilePath = logConfigurationFilePath;
        }

        public final boolean isPidIncludedInLogFileName() {
            return this.isPidIncludedInLogFileName;
        }

        @NotNull
        public final Path getLogConfigurationFilePath() {
            return this.logConfigurationFilePath;
        }

        public final boolean component1() {
            return this.isPidIncludedInLogFileName;
        }

        @NotNull
        public final Path component2() {
            return this.logConfigurationFilePath;
        }

        @NotNull
        public final BackendLogConfiguration copy(boolean isPidIncludedInLogFileName, @NotNull Path logConfigurationFilePath) {
            Intrinsics.checkNotNullParameter((Object)logConfigurationFilePath, (String)"logConfigurationFilePath");
            return new BackendLogConfiguration(isPidIncludedInLogFileName, logConfigurationFilePath);
        }

        public static /* synthetic */ BackendLogConfiguration copy$default(BackendLogConfiguration backendLogConfiguration, boolean bl, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                bl = backendLogConfiguration.isPidIncludedInLogFileName;
            }
            if ((n & 2) != 0) {
                path = backendLogConfiguration.logConfigurationFilePath;
            }
            return backendLogConfiguration.copy(bl, path);
        }

        @NotNull
        public String toString() {
            return "BackendLogConfiguration(isPidIncludedInLogFileName=" + this.isPidIncludedInLogFileName + ", logConfigurationFilePath=" + this.logConfigurationFilePath + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isPidIncludedInLogFileName);
            result2 = result2 * 31 + ((Object)this.logConfigurationFilePath).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BackendLogConfiguration)) {
                return false;
            }
            BackendLogConfiguration backendLogConfiguration = (BackendLogConfiguration)other;
            if (this.isPidIncludedInLogFileName != backendLogConfiguration.isPidIncludedInLogFileName) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.logConfigurationFilePath, (Object)backendLogConfiguration.logConfigurationFilePath);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "processIdIncrement", "", "getProcessIdIncrement", "()I", "setProcessIdIncrement", "(I)V", "shouldImportReSharperSettings", "", "getShouldImportReSharperSettings", "()Z", "setShouldImportReSharperSettings", "(Z)V", "shutdownTimeout", "", "getShutdownTimeout", "()J", "resharperHostConfigDir", "Lkotlin/Lazy;", "Ljava/io/File;", "getResharperHostConfigDir", "()Lkotlin/Lazy;", "resharperHostSystemDir", "resharperHostSystemInvalidateFlag", "getResharperHostSystemInvalidateFlag", "invalidateCachesOnNextRiderStart", "", "defaultLogFileNameBase", "", "process", "Ljava/lang/ProcessHandle;", "defaultLogFileName", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public final int getProcessIdIncrement() {
            return processIdIncrement;
        }

        public final void setProcessIdIncrement(int n) {
            processIdIncrement = n;
        }

        public final boolean getShouldImportReSharperSettings() {
            return shouldImportReSharperSettings;
        }

        public final void setShouldImportReSharperSettings(boolean bl) {
            shouldImportReSharperSettings = bl;
        }

        public final long getShutdownTimeout() {
            return shutdownTimeout;
        }

        @NotNull
        protected final Lazy<File> getResharperHostConfigDir() {
            return resharperHostConfigDir;
        }

        @NotNull
        protected final Lazy<File> getResharperHostSystemInvalidateFlag() {
            return resharperHostSystemInvalidateFlag;
        }

        public final void invalidateCachesOnNextRiderStart() {
            ((File)this.getResharperHostSystemInvalidateFlag().getValue()).getParentFile().mkdirs();
            FilesKt.writeText$default((File)((File)this.getResharperHostSystemInvalidateFlag().getValue()), (String)"", null, (int)2, null);
        }

        @NotNull
        public final String defaultLogFileNameBase(@NotNull ProcessHandle process) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                    Optional<Instant> optional = process.info().startInstant();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"startInstant(...)");
                    object = (Instant)OptionalsKt.getOrNull(optional);
                    if (object == null) break block2;
                    Instant it = object;
                    boolean bl = false;
                    String string = DateTimeFormatter.ofPattern("yyyy-MM-dd_HHmm").format(it.atZone(ZoneId.systemDefault()));
                    object = string;
                    if (string != null) break block3;
                }
                object = "0000-00-00_0000";
            }
            Object startTime = object;
            return "backend." + (String)startTime + "." + process.pid();
        }

        @NotNull
        public final String defaultLogFileName(@NotNull ProcessHandle process) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            return this.defaultLogFileNameBase(process) + ".log";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$PlaybackCrash;", "", "<init>", "()V", "BACKEND_CRASH_EXIT_CODE", "", "PROCESS_REQUEST_TERMINATION_DIRECTORY", "", "IDEA_FUS_RECORDER_INTERNAL_MODE", "IDEA_RECORDER_INTERNAL_MODE", "intellij.rider.rdclient.dotnet"})
    public static final class PlaybackCrash {
        @NotNull
        public static final PlaybackCrash INSTANCE = new PlaybackCrash();
        public static final int BACKEND_CRASH_EXIT_CODE = 6;
        @NotNull
        public static final String PROCESS_REQUEST_TERMINATION_DIRECTORY = "PROCESS_REQUEST_TERMINATION";
        @NotNull
        public static final String IDEA_FUS_RECORDER_INTERNAL_MODE = "fus.internal.test.mode";
        @NotNull
        public static final String IDEA_RECORDER_INTERNAL_MODE = "fus.recorder.internal.test.mode";

        private PlaybackCrash() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0011R\u0010\u0010\u0012\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0013R\u0010\u0010\u0014\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0015R\u0010\u0010\u0016\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0017R\u0010\u0010\u0018\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u0019R\u0010\u0010\u001a\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u001bR\u0010\u0010\u001c\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\b\u001d\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$VersionRecord;", "", "<init>", "()V", "myFullVersionFormat", "", "myMajorVersion", "myMinorVersion", "myMicroVersion", "myPatchVersion", "myVersionSuffix", "getFullVersion", "getChild", "Lcom/intellij/util/xml/dom/XmlElement;", "parentNode", "name", "ELEMENT_VERSION", "ELEMENT_VERSION$1", "ATTRIBUTE_MAJOR", "ATTRIBUTE_MAJOR$1", "ATTRIBUTE_MINOR", "ATTRIBUTE_MINOR$1", "ATTRIBUTE_MICRO", "ATTRIBUTE_MICRO$1", "ATTRIBUTE_PATCH", "ATTRIBUTE_PATCH$1", "ATTRIBUTE_FULL", "ATTRIBUTE_FULL$1", "ATTRIBUTE_EAP", "ATTRIBUTE_EAP$1", "loadState", "", "loadState$intellij_rider_rdclient_dotnet", "Companion", "intellij.rider.rdclient.dotnet"})
    public static final class VersionRecord {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private String myFullVersionFormat;
        @Nullable
        private String myMajorVersion = "";
        @Nullable
        private String myMinorVersion = "";
        @Nullable
        private String myMicroVersion = "";
        @Nullable
        private String myPatchVersion = "";
        @Nullable
        private String myVersionSuffix = "";
        @NotNull
        private final String ELEMENT_VERSION$1;
        @NotNull
        private final String ATTRIBUTE_MAJOR$1;
        @NotNull
        private final String ATTRIBUTE_MINOR$1;
        @NotNull
        private final String ATTRIBUTE_MICRO$1;
        @NotNull
        private final String ATTRIBUTE_PATCH$1;
        @NotNull
        private final String ATTRIBUTE_FULL$1;
        @NotNull
        private final String ATTRIBUTE_EAP$1;
        @NotNull
        private static final String IDEA_PATH = "/idea/";
        @NotNull
        private static final String ELEMENT_VERSION = "version";
        @NotNull
        private static final String ATTRIBUTE_MAJOR = "major";
        @NotNull
        private static final String ATTRIBUTE_MINOR = "minor";
        @NotNull
        private static final String ATTRIBUTE_MICRO = "micro";
        @NotNull
        private static final String ATTRIBUTE_PATCH = "patch";
        @NotNull
        private static final String ATTRIBUTE_FULL = "full";
        @NotNull
        private static final String APP_INFO_XML_SUFFIX = "ApplicationInfo.xml";
        @NotNull
        private static final String ATTRIBUTE_EAP = "eap";

        public VersionRecord() {
            this.ELEMENT_VERSION$1 = ELEMENT_VERSION;
            this.ATTRIBUTE_MAJOR$1 = ATTRIBUTE_MAJOR;
            this.ATTRIBUTE_MINOR$1 = ATTRIBUTE_MINOR;
            this.ATTRIBUTE_MICRO$1 = ATTRIBUTE_MICRO;
            this.ATTRIBUTE_PATCH$1 = ATTRIBUTE_PATCH;
            this.ATTRIBUTE_FULL$1 = ATTRIBUTE_FULL;
            this.ATTRIBUTE_EAP$1 = ATTRIBUTE_EAP;
        }

        @NotNull
        public final String getFullVersion() {
            String result2;
            Object[] objectArray;
            if (this.myFullVersionFormat != null) {
                String string = this.myFullVersionFormat;
                if (string == null) {
                    string = "";
                }
                objectArray = new Object[]{this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion};
                v1 = MessageFormat.format(string, objectArray);
            } else {
                v1 = result2 = StringUtil.notNullize((String)this.myMajorVersion, (String)"0") + "." + StringUtil.notNullize((String)this.myMinorVersion, (String)"0");
            }
            if (!StringUtil.isEmpty((String)this.myVersionSuffix)) {
                result2 = result2 + " " + this.myVersionSuffix;
            }
            objectArray = result2;
            Intrinsics.checkNotNull((Object)objectArray);
            return objectArray;
        }

        private final XmlElement getChild(XmlElement parentNode, String name) {
            return parentNode.getChild(name);
        }

        public final void loadState$intellij_rider_rdclient_dotnet(@NotNull XmlElement parentNode) {
            Intrinsics.checkNotNullParameter((Object)parentNode, (String)"parentNode");
            XmlElement versionElement = this.getChild(parentNode, this.ELEMENT_VERSION$1);
            if (versionElement != null) {
                this.myMajorVersion = versionElement.getAttributeValue(this.ATTRIBUTE_MAJOR$1);
                this.myMinorVersion = versionElement.getAttributeValue(this.ATTRIBUTE_MINOR$1);
                this.myMicroVersion = versionElement.getAttributeValue(this.ATTRIBUTE_MICRO$1);
                this.myPatchVersion = versionElement.getAttributeValue(this.ATTRIBUTE_PATCH$1);
                this.myFullVersionFormat = versionElement.getAttributeValue(this.ATTRIBUTE_FULL$1);
                boolean eap = Boolean.parseBoolean(versionElement.getAttributeValue(this.ATTRIBUTE_EAP$1));
                this.myVersionSuffix = versionElement.getAttributeValue("suffix");
                if (this.myVersionSuffix == null && eap) {
                    this.myVersionSuffix = "EAP";
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcessBase$VersionRecord$Companion;", "", "<init>", "()V", "IDEA_PATH", "", "ELEMENT_VERSION", "ATTRIBUTE_MAJOR", "ATTRIBUTE_MINOR", "ATTRIBUTE_MICRO", "ATTRIBUTE_PATCH", "ATTRIBUTE_FULL", "APP_INFO_XML_SUFFIX", "ATTRIBUTE_EAP", "intellij.rider.rdclient.dotnet"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

