/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.protocol.ReSharperProcessBase;
import com.jetbrains.rider.protocol.RiderBackendEnvProvider;
import com.jetbrains.rider.protocol.RuntimeSpecificAssemblyResolver;
import com.jetbrains.rider.utils.XMLStreamHelpers;
import java.io.File;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess;", "Lcom/jetbrains/rider/protocol/ReSharperProcessBase;", "application", "Lcom/intellij/openapi/application/Application;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "serverPort", "", "killedEbs", "", "<init>", "(Lcom/intellij/openapi/application/Application;Lcom/jetbrains/rd/util/lifetime/Lifetime;ILjava/lang/Long;)V", "getDotNetPluginsXmlDescriptor", "", "isInternal", "", "()Z", "isUnitTesting", "getDotNetPluginsExtraDirs", "getExtraFlags", "", "getExtraEnvVars", "", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,318:1\n1#2:319\n13#3:320\n14#4:321\n*S KotlinDebug\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess\n*L\n41#1:320\n41#1:321\n*E\n"})
public final class ReSharperProcess
extends ReSharperProcessBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Application application;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Companion.AdditionalInfo> additionalInfo$delegate;

    public ReSharperProcess(@NotNull Application application, @NotNull Lifetime lifetime, int serverPort, @Nullable Long killedEbs) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(lifetime, serverPort, killedEbs);
        this.application = application;
        this.start();
    }

    @Override
    @NotNull
    public String getDotNetPluginsXmlDescriptor() {
        return Companion.getAdditionalInfo().isEmpty() ? "" : Companion.getDotNetPluginsXmlDescriptor(Companion.getAdditionalInfo());
    }

    @Override
    public boolean isInternal() {
        return this.application.isInternal();
    }

    @Override
    public boolean isUnitTesting() {
        return this.application.isUnitTestMode();
    }

    @Override
    @NotNull
    public String getDotNetPluginsExtraDirs() {
        return Companion.getAdditionalInfo().isEmpty() ? "" : Companion.getAllDotNetBinDirectoriesAsSortedString(Companion.getAdditionalInfo());
    }

    @Override
    @NotNull
    public List<String> getExtraFlags() {
        return Companion.getAdditionalInfo().getExtraFlags();
    }

    @Override
    @NotNull
    public Map<String, String> getExtraEnvVars() {
        return Companion.getAdditionalInfo().getExtraEnvVars();
    }

    private static final Companion.AdditionalInfo additionalInfo_delegate$lambda$1() {
        List nugetPackages = new ArrayList();
        List dirsAdHoc = new ArrayList();
        List dirsAdHocV2 = new ArrayList();
        List debuggerDirs = new ArrayList();
        List dirsExpanded = new ArrayList();
        List projectTemplateDirs = new ArrayList();
        Map envVars = new LinkedHashMap();
        MapsKt.putAll((Map)envVars, RiderBackendEnvProvider.Companion.getEnvironment());
        Path dirBackend = RiderEnvironment.INSTANCE.getRiderBackendDirectory().toPath();
        Intrinsics.checkNotNull((Object)dirBackend);
        dirsExpanded.add(dirBackend);
        logger.info("* adding directory with expanded DLLs for the main backend dir: " + dirBackend + ".");
        List flags = new ArrayList();
        for (IdeaPluginDescriptor plugin : PluginManager.getPlugins()) {
            Object object;
            logger.info("Start analyzing IntelliJ Plugin: " + plugin.getPluginId().getIdString() + " (\"" + plugin.getPluginPath() + "\")");
            if (Intrinsics.areEqual((Object)plugin.getPluginId().getIdString(), (Object)"com.jetbrains.rider-cpp") && plugin.isEnabled()) {
                flags.add("--enablecpp");
            }
            if (Intrinsics.areEqual((Object)plugin.getPluginId().getIdString(), (Object)"com.intellij.ml.llm") && plugin.isEnabled()) {
                envVars.put("AIAssistantPlugin", "true");
            }
            Path path = plugin.getPluginPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPluginPath(...)");
            if (Intrinsics.areEqual((Object)PathsKt.getExtension((Path)path), (Object)"jar")) {
                object = plugin.getPluginPath().getParent().getParent();
            } else if (PathManager.getArchivedCompliedClassesLocation() != null) {
                String string = PathManager.getHomePath();
                Object object2 = new String[4];
                object2[0] = "out";
                object2[1] = "rider";
                object2[2] = "plugins-backend-parts";
                Path path2 = plugin.getPluginPath();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPluginPath(...)");
                object2[3] = PathsKt.getName((Path)path2);
                Object it = object2 = Paths.get(string, (String[])object2);
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                object = Files.isDirectory((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object2 : null;
                if (object == null) {
                    object = plugin.getPluginPath();
                }
            } else {
                object = plugin.getPluginPath();
            }
            Object path3 = object;
            logger.info("Idea Plugin: " + plugin.getPluginId().getIdString() + " (" + (Path)path3 + ")");
            if (!plugin.isEnabled()) {
                logger.info("- " + plugin.getPluginId().getIdString() + " is disabled, skipping");
                continue;
            }
            Path dotnetDirectoryPart = path3.resolve("dotnet");
            Intrinsics.checkNotNull((Object)dotnetDirectoryPart);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory(dotnetDirectoryPart, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                logger.info("* adding directory with ad-hoc DLLs for a simplified Rider.Backend plugin: " + dotnetDirectoryPart + ".");
                dirsAdHoc.add(new Pair((Object)plugin, (Object)dotnetDirectoryPart));
            }
            Path netV2DirectoryPart = path3.resolve("net-v2");
            Intrinsics.checkNotNull((Object)netV2DirectoryPart);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.isDirectory(netV2DirectoryPart, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                logger.info("* adding directory with ad-hoc DLLs for a simplified Rider.Backend plugin version 2: " + netV2DirectoryPart + ".");
                dirsAdHocV2.add(new Pair((Object)plugin, (Object)netV2DirectoryPart));
            }
            Path dotnetDebuggerDirectoryPart = path3.resolve("dotnetDebuggerWorker");
            Intrinsics.checkNotNull((Object)dotnetDebuggerDirectoryPart);
            LinkOption[] linkOptionArray3 = new LinkOption[]{};
            if (Files.isDirectory(dotnetDebuggerDirectoryPart, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                logger.info("* adding directory with DLLs for a debugger plugin: " + dotnetDebuggerDirectoryPart + ".");
                debuggerDirs.add(new Pair((Object)plugin, (Object)dotnetDebuggerDirectoryPart));
            }
            Path dotFilesDirectoryPart = path3.resolve("DotFiles");
            Intrinsics.checkNotNull((Object)dotFilesDirectoryPart);
            LinkOption[] linkOptionArray4 = new LinkOption[]{};
            if (Files.isDirectory(dotFilesDirectoryPart, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) {
                if (Intrinsics.areEqual((Object)dotFilesDirectoryPart, (Object)dirBackend)) {
                    logger.info("* skipping directory with expanded DLLs for a set of full Rider.Backend plugins (reason: duplicates the main backend dir): " + dotFilesDirectoryPart + ".");
                } else {
                    logger.info("* adding directory with expanded DLLs for a set of full Rider.Backend plugins: " + dotFilesDirectoryPart + ".");
                    dirsExpanded.add(dotFilesDirectoryPart);
                }
            }
            Path projectTemplatesDirCandidate = path3.resolve("projectTemplates");
            Intrinsics.checkNotNull((Object)projectTemplatesDirCandidate);
            LinkOption[] linkOptionArray5 = new LinkOption[]{};
            if (Files.isDirectory(projectTemplatesDirCandidate, Arrays.copyOf(linkOptionArray5, linkOptionArray5.length))) {
                logger.info("* adding project templates directory: " + projectTemplatesDirCandidate);
                projectTemplateDirs.add(projectTemplatesDirCandidate);
            }
            Intrinsics.checkNotNull((Object)path3);
            List dotnetNugets = PathsKt.listDirectoryEntries((Path)path3, (String)"*.nupkg");
            for (Path nuget : dotnetNugets) {
                logger.info("* adding a nupkg file for a Rider.Backend plugin: " + nuget);
                nugetPackages.add(nuget);
            }
        }
        if (PathManager.getArchivedCompliedClassesLocation() != null) {
            String[] stringArray = new String[]{"rider", "plugins", "cpp", "resources", "projectTemplates"};
            Path path = Paths.get(PathManager.getHomePath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            projectTemplateDirs.add(path);
        }
        return new Companion.AdditionalInfo(nugetPackages, dirsAdHoc, dirsAdHocV2, debuggerDirs, dirsExpanded, projectTemplateDirs, flags, envVars);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReSharperProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ReSharperProcess.logger = logger;
        additionalInfo$delegate = LazyKt.lazy(ReSharperProcess::additionalInfo_delegate$lambda$1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getCompanyName", "", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getSubPlatformName", "getDotNetPluginsXmlDescriptor", "info", "Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "getAllDotNetBinDirectoriesSorted", "Ljava/util/SortedSet;", "Ljava/io/File;", "getAllDotNetBinDirectoriesAsSortedString", "additionalInfo", "getAdditionalInfo", "()Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "additionalInfo$delegate", "Lkotlin/Lazy;", "AdditionalInfo", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nReSharperProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess$Companion\n+ 2 XMLStreamHelpers.kt\ncom/jetbrains/rider/utils/XMLStreamHelpers\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,318:1\n7#2:319\n11#2,2:320\n11#2,4:323\n11#2,4:329\n11#2,2:340\n11#2,4:343\n13#2,2:348\n11#2,2:360\n11#2,4:363\n13#2,2:368\n13#2,2:371\n8#2:373\n1863#3:322\n1864#3:327\n1863#3:328\n1864#3:333\n1053#3:334\n1863#3:335\n1557#3:336\n1628#3,3:337\n1863#3:342\n1864#3:347\n1864#3:350\n1053#3:351\n1863#3:352\n774#3:353\n865#3,2:354\n1557#3:356\n1628#3,3:357\n1863#3:362\n1864#3:367\n1864#3:370\n1557#3:374\n1628#3,3:375\n1557#3:378\n1628#3,3:379\n*S KotlinDebug\n*F\n+ 1 ReSharperProcess.kt\ncom/jetbrains/rider/protocol/ReSharperProcess$Companion\n*L\n78#1:319\n79#1:320,2\n99#1:323,4\n105#1:329,4\n124#1:340,2\n132#1:343,4\n124#1:348,2\n162#1:360,2\n170#1:363,4\n162#1:368,2\n79#1:371,2\n78#1:373\n98#1:322\n98#1:327\n104#1:328\n104#1:333\n110#1:334\n110#1:335\n121#1:336\n121#1:337,3\n131#1:342\n131#1:347\n110#1:350\n142#1:351\n142#1:352\n153#1:353\n153#1:354,2\n159#1:356\n159#1:357,3\n169#1:362\n169#1:367\n142#1:370\n193#1:374\n193#1:375,3\n194#1:378\n194#1:379,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getCompanyName(IdeaPluginDescriptor plugin) {
            String string = plugin.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDotIndex == -1) {
                String string2 = plugin.getVendor();
                if (string2 == null) {
                    throw new IllegalStateException("Company name not found".toString());
                }
                return string2;
            }
            String string3 = plugin.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdString(...)");
            String string4 = string3;
            int n = 0;
            String string5 = string4.substring(n, lastDotIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }

        private final String getSubPlatformName(IdeaPluginDescriptor plugin) {
            String string = plugin.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
            int lastDotIndex = StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (lastDotIndex == -1) {
                String string2 = plugin.getPluginId().getIdString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdString(...)");
                return string2;
            }
            String string3 = plugin.getPluginId().getIdString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdString(...)");
            String string4 = string3;
            int n = lastDotIndex + 1;
            int n2 = plugin.getPluginId().getIdString().length();
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            return string5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String getDotNetPluginsXmlDescriptor(@NotNull AdditionalInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Regex jetSemanticVersionRegex = new Regex("^(\\d+(\\s*\\.\\s*\\d+){0,3})(-(([-a-zA-Z0-9])([-a-zA-Z0-9\\\\.](?<!\\.{2}))*(?<!\\.)))?(\\+(?<Build>[0-9a-z\\-\\\\.]*))?$", RegexOption.IGNORE_CASE);
            StringWriter sw = new StringWriter();
            XMLStreamWriter xMLStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
            Intrinsics.checkNotNullExpressionValue((Object)xMLStreamWriter, (String)"createXMLStreamWriter(...)");
            try (XMLStreamWriter xml = xMLStreamWriter;){
                Object name$iv;
                Iterable iterable;
                String version;
                Path baseDir;
                IdeaPluginDescriptor plugin;
                Pair pair2;
                void $this$element$iv;
                boolean $i$f$element;
                String name$iv2;
                Path it;
                void name$iv3;
                void $this$element$iv2;
                XMLStreamHelpers this_$iv = XMLStreamHelpers.INSTANCE;
                boolean $i$f$xmlSteamWriter = false;
                XMLStreamWriter $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420 = xml;
                boolean bl = false;
                XMLStreamHelpers xMLStreamHelpers = XMLStreamHelpers.INSTANCE;
                XMLStreamWriter xMLStreamWriter2 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420;
                String string = "Packages";
                boolean $i$f$element2 = false;
                $this$element$iv2.writeStartElement((String)name$iv3);
                void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419 = $this$element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)info2.getNugetPackages());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Path)element$iv;
                    boolean bl3 = false;
                    XMLStreamHelpers xMLStreamHelpers2 = XMLStreamHelpers.INSTANCE;
                    void var22_23 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419;
                    name$iv2 = "File";
                    $i$f$element = false;
                    $this$element$iv.writeStartElement(name$iv2);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u241_u24lambda_u240 = $this$element$iv;
                    boolean bl4 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u241_u24lambda_u240, "Path", ((Object)it).toString());
                    $this$element$iv.writeEndElement();
                }
                $this$forEach$iv = CollectionsKt.sorted((Iterable)info2.getDirsExpanded());
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (Path)element$iv;
                    boolean bl5 = false;
                    XMLStreamHelpers this_$iv2 = XMLStreamHelpers.INSTANCE;
                    $this$element$iv = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419;
                    name$iv2 = "Folder";
                    $i$f$element = false;
                    $this$element$iv.writeStartElement(name$iv2);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u243_u24lambda_u242 = $this$element$iv;
                    boolean bl6 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u243_u24lambda_u242, "Path", ((Object)it).toString());
                    $this$element$iv.writeEndElement();
                }
                Iterable $this$sortedBy$iv = info2.getDirsAdHoc();
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Path)it.getSecond();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)it.getSecond()));
                    }
                });
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$element$iv3;
                    Instant maxMtime;
                    void $this$mapTo$iv$iv;
                    pair2 = (Pair)element$iv;
                    boolean bl7 = false;
                    plugin = (IdeaPluginDescriptor)pair2.component1();
                    baseDir = (Path)pair2.component2();
                    String string2 = plugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getVersion(...)");
                    version = jetSemanticVersionRegex.matches((CharSequence)string2) ? plugin.getVersion() : "999.999.999";
                    List files = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)baseDir, (PathWalkOption[])new PathWalkOption[0]), Companion::getDotNetPluginsXmlDescriptor$lambda$20$lambda$19$lambda$10$lambda$5));
                    Intrinsics.checkNotNullExpressionValue((Object)plugin.getPluginId().getIdString(), (String)"getIdString(...)");
                    if (files.isEmpty()) {
                        String id;
                        logger.warn("Backend/ReSharper dotnet part of plugin " + id + " was skipped since plugin folder does not contain any dlls: " + baseDir);
                        continue;
                    }
                    Object $this$map$iv = files;
                    boolean $i$f$map22 = false;
                    iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        Path path = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl8 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime((Path)it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        collection.add(fileTime.toInstant());
                    }
                    if ((Instant)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv)) == null) continue;
                    String builtOn = ZonedDateTime.ofInstant(maxMtime, ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                    $this$map$iv = XMLStreamHelpers.INSTANCE;
                    void $i$f$map22 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419;
                    String name$iv4 = "AdHocMetadata";
                    boolean $i$f$element3 = false;
                    $this$element$iv3.writeStartElement(name$iv4);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249 = $this$element$iv3;
                    boolean bl9 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249, "BaseDir", ((Object)baseDir.toAbsolutePath()).toString());
                    Intrinsics.checkNotNull((Object)version);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249, "Version", version);
                    Intrinsics.checkNotNull((Object)builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249, "BuiltOn", builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249, "CompanyNameHuman", Companion.getCompanyName(plugin));
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249, "SubplatformName", Companion.getSubPlatformName(plugin));
                    Iterable $this$forEach$iv2 = CollectionsKt.sorted((Iterable)files);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        void $this$element$iv4;
                        Path file = (Path)element$iv2;
                        boolean bl10 = false;
                        XMLStreamHelpers xMLStreamHelpers3 = XMLStreamHelpers.INSTANCE;
                        void var42_75 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249;
                        name$iv = "PackageFile";
                        boolean $i$f$element4 = false;
                        $this$element$iv4.writeStartElement((String)name$iv);
                        void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247 = $this$element$iv4;
                        boolean bl11 = false;
                        XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247, "RelativePath", ((Object)PathsKt.relativeTo((Path)file, (Path)baseDir)).toString());
                        if (StringsKt.endsWith((String)PathsKt.getName((Path)file), (String)".dll", (boolean)true)) {
                            XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249_u24lambda_u248_u24lambda_u247, "AssemblyName", "*");
                        }
                        $this$element$iv4.writeEndElement();
                    }
                    $this$element$iv3.writeEndElement();
                }
                $this$sortedBy$iv = info2.getDirsAdHocV2();
                $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Path)it.getSecond();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Path)it.getSecond()));
                    }
                });
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$element$iv5;
                    Instant maxMtime;
                    void $this$mapTo$iv$iv;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    pair2 = (Pair)element$iv;
                    boolean bl12 = false;
                    plugin = (IdeaPluginDescriptor)pair2.component1();
                    baseDir = (Path)pair2.component2();
                    String string3 = plugin.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
                    version = jetSemanticVersionRegex.matches((CharSequence)string3) ? plugin.getVersion() : "999.999.999";
                    Set managedDlls = new LinkedHashSet();
                    List files = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PathsKt.walk((Path)baseDir, (PathWalkOption[])new PathWalkOption[0]), Companion::getDotNetPluginsXmlDescriptor$lambda$20$lambda$19$lambda$18$lambda$12));
                    Intrinsics.checkNotNullExpressionValue((Object)plugin.getPluginId().getIdString(), (String)"getIdString(...)");
                    if (files.isEmpty()) {
                        String id;
                        logger.warn("Backend/ReSharper net-v2 part of plugin " + id + " was skipped since plugin folder does not contain any dlls: " + baseDir);
                        continue;
                    }
                    Iterable $this$element$iv3 = PathsKt.listDirectoryEntries$default((Path)baseDir, null, (int)1, null);
                    iterable = managedDlls;
                    boolean $i$f$filter = false;
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2410_u24lambda_u249 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Path it3 = (Path)element$iv$iv;
                        boolean bl13 = false;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!(Files.isRegularFile(it3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && StringsKt.equals((String)PathsKt.getExtension((Path)it3), (String)"dll", (boolean)true))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    iterable.addAll((List)destination$iv$iv);
                    Path runtimesDir = baseDir.resolve("runtimes");
                    Intrinsics.checkNotNull((Object)runtimesDir);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (Files.isDirectory(runtimesDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                        managedDlls.addAll((Collection)RuntimeSpecificAssemblyResolver.INSTANCE.enumerateRuntimeSpecificAssemblies(runtimesDir));
                    }
                    Object $this$map$iv = files;
                    boolean $i$f$map32 = false;
                    Object $i$f$forEach2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it4;
                        Path element$iv2 = (Path)item$iv$iv;
                        iterable = destination$iv$iv2;
                        boolean bl14 = false;
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        FileTime fileTime = Files.getLastModifiedTime((Path)it4, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                        iterable.add(fileTime.toInstant());
                    }
                    if ((Instant)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2)) == null) continue;
                    String builtOn = ZonedDateTime.ofInstant(maxMtime, ZoneId.systemDefault()).format(DateTimeFormatter.ISO_INSTANT);
                    $this$map$iv = XMLStreamHelpers.INSTANCE;
                    void $i$f$map32 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419;
                    String name$iv5 = "AdHocMetadata";
                    boolean $i$f$element5 = false;
                    $this$element$iv5.writeStartElement(name$iv5);
                    void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417 = $this$element$iv5;
                    boolean bl15 = false;
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417, "BaseDir", ((Object)baseDir.toAbsolutePath()).toString());
                    Intrinsics.checkNotNull((Object)version);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417, "Version", version);
                    Intrinsics.checkNotNull((Object)builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417, "BuiltOn", builtOn);
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417, "CompanyNameHuman", Companion.getCompanyName(plugin));
                    XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417, "SubplatformName", Companion.getSubPlatformName(plugin));
                    Iterable $this$forEach$iv3 = CollectionsKt.sorted((Iterable)files);
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        void $this$element$iv6;
                        Path file = (Path)element$iv3;
                        boolean bl16 = false;
                        name$iv = XMLStreamHelpers.INSTANCE;
                        void $i$f$element4 = $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417;
                        String name$iv6 = "PackageFile";
                        boolean $i$f$element6 = false;
                        $this$element$iv6.writeStartElement(name$iv6);
                        void $this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415 = $this$element$iv6;
                        boolean bl17 = false;
                        Path relativeFile = PathsKt.relativeTo((Path)file, (Path)baseDir);
                        XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415, "RelativePath", ((Object)relativeFile).toString());
                        if (managedDlls.contains(file)) {
                            XMLStreamHelpers.INSTANCE.attribute((XMLStreamWriter)$this$getDotNetPluginsXmlDescriptor_u24lambda_u2420_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415, "AssemblyName", "*");
                        }
                        $this$element$iv6.writeEndElement();
                    }
                    $this$element$iv5.writeEndElement();
                }
                $this$element$iv2.writeEndElement();
            }
            logger.info("Additional packages: " + sw);
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final SortedSet<File> getAllDotNetBinDirectoriesSorted(AdditionalInfo info2) {
            Path it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = info2.getDirsAdHoc();
            Collection collection2 = CollectionsKt.listOf((Object)RiderEnvironment.INSTANCE.getRiderBackendDirectory());
            boolean $i$f$map = false;
            void var5_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair2 = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Path)it.getSecond()).toFile());
            }
            $this$map$iv = info2.getDirsExpanded();
            collection2 = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Path)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toFile());
            }
            List files = CollectionsKt.plus((Collection)collection2, (Iterable)((List)destination$iv$iv));
            return CollectionsKt.toSortedSet((Iterable)files, (arg_0, arg_1) -> Companion.getAllDotNetBinDirectoriesSorted$lambda$24(Companion::getAllDotNetBinDirectoriesSorted$lambda$23, arg_0, arg_1));
        }

        @NotNull
        public final String getAllDotNetBinDirectoriesAsSortedString(@NotNull AdditionalInfo info2) {
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            return CollectionsKt.joinToString$default((Iterable)this.getAllDotNetBinDirectoriesSorted(info2), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final AdditionalInfo getAdditionalInfo() {
            Lazy lazy = additionalInfo$delegate;
            return (AdditionalInfo)lazy.getValue();
        }

        private static final boolean getDotNetPluginsXmlDescriptor$lambda$20$lambda$19$lambda$10$lambda$5(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !StringsKt.equals((String)PathsKt.getExtension((Path)it), (String)"pdb", (boolean)true);
        }

        private static final boolean getDotNetPluginsXmlDescriptor$lambda$20$lambda$19$lambda$18$lambda$12(Path it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        private static final int getAllDotNetBinDirectoriesSorted$lambda$23(File f1, File f2) {
            return FileUtil.compareFiles((File)f1, (File)f2);
        }

        private static final int getAllDotNetBinDirectoriesSorted$lambda$24(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u00a1\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\u0018\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u001b\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u001b\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u001b\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003H\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u00c6\u0003J\u0015\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0003J\u00b3\u0001\u0010'\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u00032\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000fH\u00c6\u0001J\u0013\u0010(\u001a\u00020\u001d2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\rH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R#\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/protocol/ReSharperProcess$Companion$AdditionalInfo;", "", "nugetPackages", "", "Ljava/nio/file/Path;", "dirsAdHoc", "Lkotlin/Pair;", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "dirsAdHocV2", "debuggerDirs", "dirsExpanded", "projectTemplateDirs", "extraFlags", "", "extraEnvVars", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/Map;)V", "getNugetPackages", "()Ljava/util/List;", "getDirsAdHoc", "getDirsAdHocV2", "getDebuggerDirs", "getDirsExpanded", "getProjectTemplateDirs", "getExtraFlags", "getExtraEnvVars", "()Ljava/util/Map;", "isEmpty", "", "()Z", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "", "toString", "intellij.rider.rdclient.dotnet"})
        public static final class AdditionalInfo {
            @NotNull
            private final List<Path> nugetPackages;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> dirsAdHoc;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> dirsAdHocV2;
            @NotNull
            private final List<Pair<IdeaPluginDescriptor, Path>> debuggerDirs;
            @NotNull
            private final List<Path> dirsExpanded;
            @NotNull
            private final List<Path> projectTemplateDirs;
            @NotNull
            private final List<String> extraFlags;
            @NotNull
            private final Map<String, String> extraEnvVars;

            public AdditionalInfo(@NotNull List<? extends Path> nugetPackages, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHoc, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHocV2, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> debuggerDirs, @NotNull List<? extends Path> dirsExpanded, @NotNull List<? extends Path> projectTemplateDirs, @NotNull List<String> extraFlags, @NotNull Map<String, String> extraEnvVars) {
                Intrinsics.checkNotNullParameter(nugetPackages, (String)"nugetPackages");
                Intrinsics.checkNotNullParameter(dirsAdHoc, (String)"dirsAdHoc");
                Intrinsics.checkNotNullParameter(dirsAdHocV2, (String)"dirsAdHocV2");
                Intrinsics.checkNotNullParameter(debuggerDirs, (String)"debuggerDirs");
                Intrinsics.checkNotNullParameter(dirsExpanded, (String)"dirsExpanded");
                Intrinsics.checkNotNullParameter(projectTemplateDirs, (String)"projectTemplateDirs");
                Intrinsics.checkNotNullParameter(extraFlags, (String)"extraFlags");
                Intrinsics.checkNotNullParameter(extraEnvVars, (String)"extraEnvVars");
                this.nugetPackages = nugetPackages;
                this.dirsAdHoc = dirsAdHoc;
                this.dirsAdHocV2 = dirsAdHocV2;
                this.debuggerDirs = debuggerDirs;
                this.dirsExpanded = dirsExpanded;
                this.projectTemplateDirs = projectTemplateDirs;
                this.extraFlags = extraFlags;
                this.extraEnvVars = extraEnvVars;
            }

            @NotNull
            public final List<Path> getNugetPackages() {
                return this.nugetPackages;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDirsAdHoc() {
                return this.dirsAdHoc;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDirsAdHocV2() {
                return this.dirsAdHocV2;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> getDebuggerDirs() {
                return this.debuggerDirs;
            }

            @NotNull
            public final List<Path> getDirsExpanded() {
                return this.dirsExpanded;
            }

            @NotNull
            public final List<Path> getProjectTemplateDirs() {
                return this.projectTemplateDirs;
            }

            @NotNull
            public final List<String> getExtraFlags() {
                return this.extraFlags;
            }

            @NotNull
            public final Map<String, String> getExtraEnvVars() {
                return this.extraEnvVars;
            }

            public final boolean isEmpty() {
                return this.nugetPackages.isEmpty() && this.dirsAdHoc.isEmpty() && this.dirsExpanded.isEmpty() && this.projectTemplateDirs.isEmpty();
            }

            @NotNull
            public final List<Path> component1() {
                return this.nugetPackages;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component2() {
                return this.dirsAdHoc;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component3() {
                return this.dirsAdHocV2;
            }

            @NotNull
            public final List<Pair<IdeaPluginDescriptor, Path>> component4() {
                return this.debuggerDirs;
            }

            @NotNull
            public final List<Path> component5() {
                return this.dirsExpanded;
            }

            @NotNull
            public final List<Path> component6() {
                return this.projectTemplateDirs;
            }

            @NotNull
            public final List<String> component7() {
                return this.extraFlags;
            }

            @NotNull
            public final Map<String, String> component8() {
                return this.extraEnvVars;
            }

            @NotNull
            public final AdditionalInfo copy(@NotNull List<? extends Path> nugetPackages, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHoc, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> dirsAdHocV2, @NotNull List<? extends Pair<? extends IdeaPluginDescriptor, ? extends Path>> debuggerDirs, @NotNull List<? extends Path> dirsExpanded, @NotNull List<? extends Path> projectTemplateDirs, @NotNull List<String> extraFlags, @NotNull Map<String, String> extraEnvVars) {
                Intrinsics.checkNotNullParameter(nugetPackages, (String)"nugetPackages");
                Intrinsics.checkNotNullParameter(dirsAdHoc, (String)"dirsAdHoc");
                Intrinsics.checkNotNullParameter(dirsAdHocV2, (String)"dirsAdHocV2");
                Intrinsics.checkNotNullParameter(debuggerDirs, (String)"debuggerDirs");
                Intrinsics.checkNotNullParameter(dirsExpanded, (String)"dirsExpanded");
                Intrinsics.checkNotNullParameter(projectTemplateDirs, (String)"projectTemplateDirs");
                Intrinsics.checkNotNullParameter(extraFlags, (String)"extraFlags");
                Intrinsics.checkNotNullParameter(extraEnvVars, (String)"extraEnvVars");
                return new AdditionalInfo(nugetPackages, dirsAdHoc, dirsAdHocV2, debuggerDirs, dirsExpanded, projectTemplateDirs, extraFlags, extraEnvVars);
            }

            public static /* synthetic */ AdditionalInfo copy$default(AdditionalInfo additionalInfo, List list2, List list3, List list4, List list5, List list6, List list7, List list8, Map map, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = additionalInfo.nugetPackages;
                }
                if ((n & 2) != 0) {
                    list3 = additionalInfo.dirsAdHoc;
                }
                if ((n & 4) != 0) {
                    list4 = additionalInfo.dirsAdHocV2;
                }
                if ((n & 8) != 0) {
                    list5 = additionalInfo.debuggerDirs;
                }
                if ((n & 0x10) != 0) {
                    list6 = additionalInfo.dirsExpanded;
                }
                if ((n & 0x20) != 0) {
                    list7 = additionalInfo.projectTemplateDirs;
                }
                if ((n & 0x40) != 0) {
                    list8 = additionalInfo.extraFlags;
                }
                if ((n & 0x80) != 0) {
                    map = additionalInfo.extraEnvVars;
                }
                return additionalInfo.copy(list2, list3, list4, list5, list6, list7, list8, map);
            }

            @NotNull
            public String toString() {
                return "AdditionalInfo(nugetPackages=" + this.nugetPackages + ", dirsAdHoc=" + this.dirsAdHoc + ", dirsAdHocV2=" + this.dirsAdHocV2 + ", debuggerDirs=" + this.debuggerDirs + ", dirsExpanded=" + this.dirsExpanded + ", projectTemplateDirs=" + this.projectTemplateDirs + ", extraFlags=" + this.extraFlags + ", extraEnvVars=" + this.extraEnvVars + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.nugetPackages).hashCode();
                result2 = result2 * 31 + ((Object)this.dirsAdHoc).hashCode();
                result2 = result2 * 31 + ((Object)this.dirsAdHocV2).hashCode();
                result2 = result2 * 31 + ((Object)this.debuggerDirs).hashCode();
                result2 = result2 * 31 + ((Object)this.dirsExpanded).hashCode();
                result2 = result2 * 31 + ((Object)this.projectTemplateDirs).hashCode();
                result2 = result2 * 31 + ((Object)this.extraFlags).hashCode();
                result2 = result2 * 31 + ((Object)this.extraEnvVars).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AdditionalInfo)) {
                    return false;
                }
                AdditionalInfo additionalInfo = (AdditionalInfo)other;
                if (!Intrinsics.areEqual(this.nugetPackages, additionalInfo.nugetPackages)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsAdHoc, additionalInfo.dirsAdHoc)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsAdHocV2, additionalInfo.dirsAdHocV2)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.debuggerDirs, additionalInfo.debuggerDirs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.dirsExpanded, additionalInfo.dirsExpanded)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.projectTemplateDirs, additionalInfo.projectTemplateDirs)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.extraFlags, additionalInfo.extraFlags)) {
                    return false;
                }
                return Intrinsics.areEqual(this.extraEnvVars, additionalInfo.extraEnvVars);
            }
        }
    }
}

