/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget;

import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.model.RdNuGetImplicitPackageIdentity;
import com.jetbrains.rider.model.RdNuGetImplicitVersion;
import com.jetbrains.rider.model.RdNuGetLogLevel;
import com.jetbrains.rider.model.RdNuGetLogMessage;
import com.jetbrains.rider.model.RdNuGetPackageIdentity;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import com.jetbrains.rider.model.RdNuGetStateInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001c\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"4\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\"\u0015\u0010\r\u001a\u00020\u0006*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0006*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\"\u001b\u0010\u0013\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"fullText", "", "Lcom/jetbrains/rider/model/RdNuGetLogMessage;", "getFullText", "(Lcom/jetbrains/rider/model/RdNuGetLogMessage;)Ljava/lang/String;", "isEmpty", "", "(Lcom/jetbrains/rider/model/RdNuGetLogMessage;)Z", "RdNuGetLogLevelErrors", "Ljava/util/EnumSet;", "Lcom/jetbrains/rider/model/RdNuGetLogLevel;", "kotlin.jvm.PlatformType", "Ljava/util/EnumSet;", "isError", "(Lcom/jetbrains/rider/model/RdNuGetLogLevel;)Z", "isInstalled", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "(Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;)Z", "isAvailable", "hashString", "", "Lcom/jetbrains/rider/model/RdNuGetFeed;", "getHashString", "(Ljava/util/List;)Ljava/lang/String;", "toUserString", "Lcom/jetbrains/rider/model/RdNuGetStateInfo;", "toImplicitVersion", "Lcom/jetbrains/rider/model/RdNuGetImplicitVersion;", "Lcom/jetbrains/rider/model/RdNuGetImplicitPackageIdentity;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetExtensions.kt\ncom/jetbrains/rider/nuget/RiderNuGetExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1557#2:42\n1628#2,3:43\n*S KotlinDebug\n*F\n+ 1 RiderNuGetExtensions.kt\ncom/jetbrains/rider/nuget/RiderNuGetExtensionsKt\n*L\n41#1:42\n41#1:43,3\n*E\n"})
public final class RiderNuGetExtensionsKt {
    private static final EnumSet<RdNuGetLogLevel> RdNuGetLogLevelErrors = EnumSet.of((Enum)RdNuGetLogLevel.Error, (Enum)RdNuGetLogLevel.Warning);

    @NotNull
    public static final String getFullText(@NotNull RdNuGetLogMessage $this$fullText) {
        Intrinsics.checkNotNullParameter((Object)$this$fullText, (String)"<this>");
        String string = $this$fullText.getLevel().toString().toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return string + ": " + ((Object)StringsKt.trim((CharSequence)$this$fullText.getText())).toString();
    }

    public static final boolean isEmpty(@NotNull RdNuGetLogMessage $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return StringsKt.isBlank((CharSequence)$this$isEmpty.getText());
    }

    public static final boolean isError(@NotNull RdNuGetLogLevel $this$isError) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isError), (String)"<this>");
        return RdNuGetLogLevelErrors.contains((Object)$this$isError);
    }

    public static final boolean isInstalled(@NotNull RdNuGetSmartMetadata $this$isInstalled) {
        Intrinsics.checkNotNullParameter((Object)$this$isInstalled, (String)"<this>");
        return CollectionsKt.any((Iterable)$this$isInstalled.getInstalledVersions());
    }

    public static final boolean isAvailable(@NotNull RdNuGetSmartMetadata $this$isAvailable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAvailable, (String)"<this>");
        return $this$isAvailable.getInstalledVersions().isEmpty();
    }

    @NotNull
    public static final String getHashString(@NotNull List<RdNuGetFeed> $this$hashString) {
        Intrinsics.checkNotNullParameter($this$hashString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$hashString, (CharSequence)"+", null, null, (int)0, null, RiderNuGetExtensionsKt::_get_hashString_$lambda$0, (int)30, null);
    }

    @NotNull
    public static final String toUserString(@NotNull RdNuGetStateInfo $this$toUserString) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toUserString), (String)"<this>");
        StringBuilder builder = new StringBuilder();
        Ref.BooleanRef first = new Ref.BooleanRef();
        first.element = true;
        RiderNuGetExtensionsKt.toUserString$print(first, builder, "IsFetching", $this$toUserString.isFetching());
        RiderNuGetExtensionsKt.toUserString$print(first, builder, "TotalFetched", $this$toUserString.getTotalFetched());
        RiderNuGetExtensionsKt.toUserString$print(first, builder, "PackageReferenceTrackerIsBusy", $this$toUserString.getPackageReferenceTrackerIsBusy());
        RiderNuGetExtensionsKt.toUserString$print(first, builder, "OperatorIsBusy", $this$toUserString.getOperatorIsBusy());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RdNuGetImplicitVersion toImplicitVersion(@NotNull RdNuGetImplicitPackageIdentity $this$toImplicitVersion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toImplicitVersion, (String)"<this>");
        Iterable iterable = $this$toImplicitVersion.getOrigins();
        String string = $this$toImplicitVersion.getIdentity().getVersion();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdNuGetPackageIdentity rdNuGetPackageIdentity = (RdNuGetPackageIdentity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List list2 = (List)destination$iv$iv;
        String string2 = string;
        return new RdNuGetImplicitVersion(string2, list2);
    }

    private static final CharSequence _get_hashString_$lambda$0(RdNuGetFeed it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFeedId();
    }

    private static final <T> void toUserString$print(Ref.BooleanRef first, StringBuilder builder, String title, IOptProperty<T> property) {
        Object object;
        if (!first.element) {
            builder.append(", ");
        }
        if ((object = property.getValueOrNull()) == null || (object = object.toString()) == null) {
            object = "NA";
        }
        builder.append(title + ": " + (String)object);
        first.element = false;
    }
}

