/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.intentions.altEnter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.intentions.altEnter.GotoActionMenuListener;
import com.jetbrains.rider.intentions.altEnter.RiderAltEnterUsageCollector;
import com.jetbrains.rider.intentions.altEnter.SearchEndType;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker;", "Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "currentSearchSessionInfo", "Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker$GotoActionSearchInfo;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "language", "Lcom/intellij/lang/Language;", "searchStarted", "", "searchEnded", "type", "Lcom/jetbrains/rider/intentions/altEnter/SearchEndType;", "selectedIndex", "", "selectionChanged", "patternChanged", "previousPattern", "", "currentPattern", "itemListUpdated", "timeMs", "", "GotoActionSearchInfo", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nGotoActionMenuTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotoActionMenuTracker.kt\ncom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n14#2:74\n*S KotlinDebug\n*F\n+ 1 GotoActionMenuTracker.kt\ncom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker\n*L\n13#1:74\n*E\n"})
public final class GotoActionMenuTracker
implements GotoActionMenuListener {
    @NotNull
    private final Project project;
    @Nullable
    private GotoActionSearchInfo currentSearchSessionInfo;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Language language;

    public GotoActionMenuTracker(@NotNull Project project, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GotoActionMenuTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        PsiFile psiFile = psiDocumentManager.getPsiFile((Document)editor.getDocument());
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            Language language = Language.ANY;
            psiFile = language;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"ANY");
        }
        this.language = psiFile;
    }

    @Override
    public void searchStarted() {
        GotoActionSearchInfo searchInfo;
        this.currentSearchSessionInfo = searchInfo = new GotoActionSearchInfo();
    }

    @Override
    public void searchEnded(@NotNull SearchEndType type, int selectedIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            return;
        }
        GotoActionSearchInfo currentSession = gotoActionSearchInfo;
        this.currentSearchSessionInfo = null;
        long sessionDuration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - currentSession.getSessionStartTime(), TimeUnit.NANOSECONDS);
        RiderAltEnterUsageCollector.INSTANCE.logSearchEnded(this.project, type, selectedIndex, sessionDuration, currentSession);
    }

    @Override
    public void selectionChanged() {
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            return;
        }
        GotoActionSearchInfo sessionInfo = gotoActionSearchInfo;
        int n = sessionInfo.getSelectionChanged();
        sessionInfo.setSelectionChanged(n + 1);
    }

    @Override
    public void patternChanged(@NotNull String previousPattern, @NotNull String currentPattern) {
        Intrinsics.checkNotNullParameter((Object)previousPattern, (String)"previousPattern");
        Intrinsics.checkNotNullParameter((Object)currentPattern, (String)"currentPattern");
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            boolean bl = false;
            this.logger.error("No currentSearchSessionInfo during prefix change");
            return;
        }
        GotoActionSearchInfo sessionInfo = gotoActionSearchInfo;
        if (previousPattern.length() < currentPattern.length()) {
            int n = sessionInfo.getTypingCount();
            sessionInfo.setTypingCount(n + 1);
        } else {
            int n = sessionInfo.getBackspacesCount();
            sessionInfo.setBackspacesCount(n + 1);
        }
        sessionInfo.setQueryLength(currentPattern.length());
    }

    @Override
    public void itemListUpdated(long timeMs2) {
        GotoActionSearchInfo gotoActionSearchInfo = this.currentSearchSessionInfo;
        if (gotoActionSearchInfo == null) {
            boolean bl = false;
            this.logger.error("No currentSearchSessionInfo during list update");
            return;
        }
        GotoActionSearchInfo sessionInfo = gotoActionSearchInfo;
        sessionInfo.setLastSearchStartTime(timeMs2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/intentions/altEnter/GotoActionMenuTracker$GotoActionSearchInfo;", "", "<init>", "()V", "sessionStartTime", "", "getSessionStartTime", "()J", "lastSearchStartTime", "getLastSearchStartTime", "setLastSearchStartTime", "(J)V", "typingCount", "", "getTypingCount", "()I", "setTypingCount", "(I)V", "backspacesCount", "getBackspacesCount", "setBackspacesCount", "selectionChanged", "getSelectionChanged", "setSelectionChanged", "queryLength", "getQueryLength", "setQueryLength", "intellij.rider.rdclient.dotnet"})
    public static final class GotoActionSearchInfo {
        private final long sessionStartTime = System.nanoTime();
        private long lastSearchStartTime;
        private int typingCount;
        private int backspacesCount;
        private int selectionChanged;
        private int queryLength;

        public final long getSessionStartTime() {
            return this.sessionStartTime;
        }

        public final long getLastSearchStartTime() {
            return this.lastSearchStartTime;
        }

        public final void setLastSearchStartTime(long l) {
            this.lastSearchStartTime = l;
        }

        public final int getTypingCount() {
            return this.typingCount;
        }

        public final void setTypingCount(int n) {
            this.typingCount = n;
        }

        public final int getBackspacesCount() {
            return this.backspacesCount;
        }

        public final void setBackspacesCount(int n) {
            this.backspacesCount = n;
        }

        public final int getSelectionChanged() {
            return this.selectionChanged;
        }

        public final void setSelectionChanged(int n) {
            this.selectionChanged = n;
        }

        public final int getQueryLength() {
            return this.queryLength;
        }

        public final void setQueryLength(int n) {
            this.queryLength = n;
        }
    }
}

