/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.intentions;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.intention.impl.IntentionGroup;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.openapi.editor.GutterMarkPreprocessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.FrontendGutterIconRenderer;
import com.jetbrains.rdclient.daemon.highlighters.gutterMarks.MergableGutterIconRenderer;
import com.jetbrains.rider.intentions.ImportantNonMergableGutterMark;
import com.jetbrains.rider.intentions.MergeableGutterIconRendererExternalWrapper;
import com.jetbrains.rider.intentions.RiderWrappedMergeableIconProvider;
import com.jetbrains.rider.intentions.altEnter.FrontendBulbRenderer;
import com.jetbrains.rider.intentions.gutterWrappers.BackendGutterMarkWrapper;
import com.jetbrains.rider.intentions.gutterWrappers.FrontendGutterMarkWrapper;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/intentions/RiderGutterMarkPreprocessor;", "Lcom/intellij/openapi/editor/GutterMarkPreprocessor;", "<init>", "()V", "processMarkers", "", "Lcom/intellij/codeInsight/daemon/GutterMark;", "originalGutters", "tryGetMergableIconRenderer", "Lcom/jetbrains/rdclient/daemon/highlighters/gutterMarks/MergableGutterIconRenderer;", "mark", "unwrapGutterMark", "processGutters", "gutters", "", "processLeftAlignedGutters", "", "leftAlignedGutters", "shouldDropGutterFromLeftAligned", "", "gutterMark", "intellij.rider.rdclient.dotnet"})
public final class RiderGutterMarkPreprocessor
implements GutterMarkPreprocessor {
    @NotNull
    public List<GutterMark> processMarkers(@NotNull List<? extends GutterMark> originalGutters) {
        Intrinsics.checkNotNullParameter(originalGutters, (String)"originalGutters");
        if (originalGutters.isEmpty()) {
            return originalGutters;
        }
        MergableGutterIconRenderer bestGutterMark = null;
        List result2 = new ArrayList();
        List mergableGutters = new ArrayList();
        boolean metFrontendBulbRenderer = false;
        for (GutterMark mark : originalGutters) {
            boolean bl;
            metFrontendBulbRenderer = metFrontendBulbRenderer || mark instanceof FrontendBulbRenderer;
            MergableGutterIconRenderer mergableMark = this.tryGetMergableIconRenderer(mark);
            if (mergableMark != null) {
                if (bestGutterMark == null || bestGutterMark.compareTo(mergableMark) > 0) {
                    bestGutterMark = mergableMark;
                }
                bl = mergableGutters.add(mergableMark);
                continue;
            }
            bl = result2.add(mark);
        }
        if (bestGutterMark == null) {
            return originalGutters;
        }
        int insertionIndex = 0;
        for (MergableGutterIconRenderer mergableGutter : mergableGutters) {
            if (mergableGutter.compareTo(bestGutterMark) != 0) continue;
            GutterMark unwrappedGutter = this.unwrapGutterMark(mergableGutter);
            result2.add(insertionIndex++, unwrappedGutter);
        }
        for (GutterMark gutter : result2) {
            if (!(gutter instanceof FrontendGutterMarkWrapper) || !metFrontendBulbRenderer || ((FrontendGutterMarkWrapper)gutter).isLineMarker()) continue;
            ((FrontendGutterMarkWrapper)gutter).useIdeShowAllIntentionsWhenClicked();
        }
        return this.processGutters(result2);
    }

    private final MergableGutterIconRenderer tryGetMergableIconRenderer(GutterMark mark) {
        if (mark instanceof MergableGutterIconRenderer) {
            if (mark instanceof FrontendGutterIconRenderer) {
                return new BackendGutterMarkWrapper((FrontendGutterIconRenderer)mark);
            }
            return (MergableGutterIconRenderer)mark;
        }
        for (RiderWrappedMergeableIconProvider provider2 : (RiderWrappedMergeableIconProvider[])RiderWrappedMergeableIconProvider.Companion.getEP_NAME().getExtensions()) {
            MergableGutterIconRenderer mergableGutterIconRenderer = provider2.tryGetMergeableIconRenderer(mark);
            if (mergableGutterIconRenderer == null) continue;
            return mergableGutterIconRenderer;
        }
        if (mark instanceof LineMarkerInfo.LineMarkerGutterIconRenderer && !(mark instanceof ImportantNonMergableGutterMark)) {
            return new FrontendGutterMarkWrapper((GutterIconRenderer)mark, IntentionGroup.INSPECTION.getPriority() + 1);
        }
        if (mark instanceof GutterIconRenderer && Intrinsics.areEqual((Object)mark.getClass().getSimpleName(), (Object)"CssColorGutterRenderer")) {
            return new FrontendGutterMarkWrapper((GutterIconRenderer)mark, IntentionGroup.INSPECTION.getPriority() + 1);
        }
        return null;
    }

    private final GutterMark unwrapGutterMark(GutterMark mark) {
        if (mark instanceof MergeableGutterIconRendererExternalWrapper) {
            return ((MergeableGutterIconRendererExternalWrapper)mark).getOriginalMark();
        }
        return mark;
    }

    private final List<GutterMark> processGutters(List<GutterMark> gutters) {
        List rightAlignedGutters = new ArrayList();
        List centerAlignedGutters = new ArrayList();
        List leftAlignedGutters = new ArrayList();
        List otherGutters = new ArrayList();
        List resultGutters = new ArrayList();
        block6: for (GutterMark gutter : gutters) {
            boolean bl;
            if (gutter instanceof GutterIconRenderer) {
                switch (WhenMappings.$EnumSwitchMapping$0[((GutterIconRenderer)gutter).getAlignment().ordinal()]) {
                    case 1: {
                        bl = leftAlignedGutters.add(gutter);
                        continue block6;
                    }
                    case 2: {
                        bl = rightAlignedGutters.add(gutter);
                        continue block6;
                    }
                    case 3: {
                        bl = centerAlignedGutters.add(gutter);
                        continue block6;
                    }
                    case 4: {
                        bl = otherGutters.add(gutter);
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException(((GutterIconRenderer)gutter).getAlignment() + " is not supported");
                    }
                }
            }
            bl = otherGutters.add(gutter);
        }
        for (GutterMark gutter : rightAlignedGutters) {
            resultGutters.add(gutter);
        }
        for (GutterMark gutter : centerAlignedGutters) {
            resultGutters.add(gutter);
        }
        this.processLeftAlignedGutters(leftAlignedGutters);
        for (GutterMark gutter : leftAlignedGutters) {
            resultGutters.add(gutter);
        }
        for (GutterMark gutter : otherGutters) {
            resultGutters.add(gutter);
        }
        return resultGutters;
    }

    private final void processLeftAlignedGutters(List<GutterMark> leftAlignedGutters) {
        if (leftAlignedGutters.size() == 0) {
            return;
        }
        List resultingGutters = new ArrayList();
        boolean tookOneRemovableGutter = false;
        for (GutterMark gutter : leftAlignedGutters) {
            if (!this.shouldDropGutterFromLeftAligned(gutter)) {
                resultingGutters.add(gutter);
                continue;
            }
            if (tookOneRemovableGutter) continue;
            resultingGutters.add(gutter);
            tookOneRemovableGutter = true;
        }
        leftAlignedGutters.clear();
        leftAlignedGutters.addAll(resultingGutters);
    }

    private final boolean shouldDropGutterFromLeftAligned(GutterMark gutterMark) {
        return !(gutterMark instanceof DiffGutterRenderer) && !(gutterMark instanceof ImportantNonMergableGutterMark);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GutterIconRenderer.Alignment.values().length];
            try {
                nArray[GutterIconRenderer.Alignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GutterIconRenderer.Alignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GutterIconRenderer.Alignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GutterIconRenderer.Alignment.LINE_NUMBERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

