/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inspections.suppression;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.inspections.suppression.IdeaInspectionBackendSuppressionDataKeys;
import com.jetbrains.rider.inspections.suppression.InspectionSuppressionInfo;
import com.jetbrains.rider.model.inspections.RdIdeaInspectionBackendSuppressionDataConstant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/inspections/suppression/DisableWarningOnBackendFixBase;", "Lcom/intellij/codeInspection/SuppressQuickFix;", "actionName", "", "suppressionInfo", "Lcom/jetbrains/rider/inspections/suppression/InspectionSuppressionInfo;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rider/inspections/suppression/InspectionSuppressionInfo;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "isAvailable", "", "context", "Lcom/intellij/psi/PsiElement;", "isSuppressAll", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDisableWarningOnBackendFixBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisableWarningOnBackendFixBase.kt\ncom/jetbrains/rider/inspections/suppression/DisableWarningOnBackendFixBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n24#2:55\n24#2:56\n*S KotlinDebug\n*F\n+ 1 DisableWarningOnBackendFixBase.kt\ncom/jetbrains/rider/inspections/suppression/DisableWarningOnBackendFixBase\n*L\n23#1:55\n27#1:56\n*E\n"})
public abstract class DisableWarningOnBackendFixBase
implements SuppressQuickFix {
    @NotNull
    private final String actionName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final InspectionSuppressionInfo suppressionInfo;

    public DisableWarningOnBackendFixBase(@NotNull String actionName, @NotNull InspectionSuppressionInfo suppressionInfo) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter((Object)suppressionInfo, (String)"suppressionInfo");
        this.actionName = actionName;
        this.suppressionInfo = suppressionInfo;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (!(descriptor instanceof ProblemDescriptorBase)) {
            DisableWarningOnBackendFixBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DisableWarningOnBackendFixBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Got descriptor " + descriptor + ", not ProblemDescriptorBase");
            return;
        }
        if (((ProblemDescriptorBase)descriptor).getTextRange() == null) {
            DisableWarningOnBackendFixBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DisableWarningOnBackendFixBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("TextRange of descriptor is null");
            return;
        }
        PsiFile psiFile = ((ProblemDescriptorBase)descriptor).getPsiElement().getContainingFile();
        if (psiFile == null) {
            throw new AssertionError((Object)"file != null");
        }
        PsiFile file = psiFile;
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file.getVirtualFile());
        if (!(selectedEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)selectedEditor).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange range = textRange;
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor2).add(CommonDataKeys.PROJECT, (Object)project).add(IdeaInspectionBackendSuppressionDataKeys.INSTANCE.getDISABLE_INSPECTION_DATA(), (Object)new RdIdeaInspectionBackendSuppressionDataConstant(RangeUtilKt.toRdTextRange(range), this.suppressionInfo.getIdeaToolId(), this.suppressionInfo.getResharperSeverityId())).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext2);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
        AnActionEvent event = anActionEvent;
        BackendActionDelegationKt.backendActionPerformed(this.actionName, event);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return true;
    }

    public boolean isSuppressAll() {
        return true;
    }
}

