/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.model.RdFromTo;
import com.jetbrains.rider.model.RdOperationResult;
import com.jetbrains.rider.projectView.VfsBackendRequester;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H$J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/actions/FromToAction;", "Lcom/jetbrains/rider/projectView/VfsBackendRequester;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "execute", "Lcom/jetbrains/rider/model/RdOperationResult;", "fromTo", "Lcom/jetbrains/rider/model/RdFromTo;", "skipExisting", "", "existingFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "destinationParent", "name", "", "perform", "", "fromVirtualFile", "intellij.rider.rdclient.dotnet"})
public abstract class FromToAction
implements VfsBackendRequester {
    @NotNull
    private final Logger logger;

    public FromToAction(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final RdOperationResult execute(@NotNull RdFromTo fromTo) {
        Intrinsics.checkNotNullParameter((Object)fromTo, (String)"fromTo");
        VirtualFile fromVirtualFile = DocumentUtilKt.toVirtualFile(fromTo.getFrom(), true);
        if (fromVirtualFile == null) {
            this.logger.info("Cannot get 'From' virtual file. Cancelling...");
            return new RdOperationResult(false, "Cannot get 'From' virtual file");
        }
        File ioFile = new File(fromTo.getTo());
        String string = ioFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParent(...)");
        VirtualFile destinationParent = DocumentUtilKt.toVirtualFile(string, true);
        if (destinationParent == null) {
            this.logger.info("Cannot get destination parent " + ioFile.getParent());
            return new RdOperationResult(false, "Cannot get destination parent " + ioFile.getParent());
        }
        VirtualFile existingFile = destinationParent.findChild(ioFile.getName());
        if (existingFile != null) {
            String string2 = ioFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!this.skipExisting(existingFile, destinationParent, string2)) {
                if (fromTo.getOverwrite()) {
                    try {
                        ApplicationKt.getApplication().runWriteAction(() -> FromToAction.execute$lambda$0(existingFile, this));
                    }
                    catch (Throwable t) {
                        this.logger.error(t);
                        return new RdOperationResult(false, t.getMessage());
                    }
                } else {
                    this.logger.info("Destination file " + existingFile + " already exists");
                    return new RdOperationResult(false, "Destination file " + existingFile + " already exists");
                }
            }
        }
        try {
            ApplicationKt.getApplication().runWriteAction(() -> FromToAction.execute$lambda$1(this, fromVirtualFile, destinationParent, ioFile));
        }
        catch (Throwable t) {
            this.logger.warn(t);
            return new RdOperationResult(false, t.getMessage());
        }
        return new RdOperationResult(true, null);
    }

    protected abstract boolean skipExisting(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @NotNull String var3);

    protected abstract void perform(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @NotNull String var3);

    private static final void execute$lambda$0(VirtualFile $existingFile, FromToAction this$0) {
        $existingFile.delete((Object)this$0);
    }

    private static final void execute$lambda$1(FromToAction this$0, VirtualFile $fromVirtualFile, VirtualFile $destinationParent, File $ioFile) {
        String string = $ioFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this$0.perform($fromVirtualFile, $destinationParent, string);
    }
}

