/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "solutionDirectory", "Ljava/io/File;", "tempDirectory", "shouldWatch", "", "rootFile", "intellij.rider.rdclient.dotnet"})
public final class VfsWatchRootFilter {
    @NotNull
    private final File solutionDirectory;
    @NotNull
    private final File tempDirectory;

    public VfsWatchRootFilter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.solutionDirectory = SolutionHostExtensionsKt.getSolutionDirectory(project);
        this.tempDirectory = new File(FileUtil.getTempDirectory());
    }

    public final boolean shouldWatch(@NotNull File rootFile) {
        Intrinsics.checkNotNullParameter((Object)rootFile, (String)"rootFile");
        if (rootFile.getParentFile() == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.tempDirectory, (Object)rootFile) || Intrinsics.areEqual((Object)this.tempDirectory, (Object)rootFile.getParentFile())) {
            return false;
        }
        return !VfsUtil.isAncestor((File)this.solutionDirectory, (File)rootFile, (boolean)false);
    }
}

