/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.virtualFormat;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rider.editors.virtualFormat.FoldingArgs;
import com.jetbrains.rider.editors.virtualFormat.InlayArgs;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003JC\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/editors/virtualFormat/VirtualFormattingApplicationStrategy;", "", "highlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "foldingCreationArgs", "Lcom/jetbrains/rider/editors/virtualFormat/FoldingArgs;", "inlayCreationArgs", "Lcom/jetbrains/rider/editors/virtualFormat/InlayArgs;", "stamp", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;J)V", "getHighlighters", "()Ljava/util/List;", "getFoldingCreationArgs", "getInlayCreationArgs", "getStamp", "()J", "isEmpty", "", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nriderVirtualFormattingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 riderVirtualFormattingService.kt\ncom/jetbrains/rider/editors/virtualFormat/VirtualFormattingApplicationStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class VirtualFormattingApplicationStrategy {
    @NotNull
    private final List<RangeHighlighter> highlighters;
    @NotNull
    private final List<FoldingArgs> foldingCreationArgs;
    @NotNull
    private final List<InlayArgs> inlayCreationArgs;
    private final long stamp;

    public VirtualFormattingApplicationStrategy(@NotNull List<? extends RangeHighlighter> highlighters, @NotNull List<FoldingArgs> foldingCreationArgs, @NotNull List<InlayArgs> inlayCreationArgs, long stamp) {
        boolean bl;
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Intrinsics.checkNotNullParameter(foldingCreationArgs, (String)"foldingCreationArgs");
        Intrinsics.checkNotNullParameter(inlayCreationArgs, (String)"inlayCreationArgs");
        this.highlighters = highlighters;
        this.foldingCreationArgs = foldingCreationArgs;
        this.inlayCreationArgs = inlayCreationArgs;
        this.stamp = stamp;
        boolean bl2 = bl = this.foldingCreationArgs.size() == this.inlayCreationArgs.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Folding number should match the inlay number";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final List<RangeHighlighter> getHighlighters() {
        return this.highlighters;
    }

    @NotNull
    public final List<FoldingArgs> getFoldingCreationArgs() {
        return this.foldingCreationArgs;
    }

    @NotNull
    public final List<InlayArgs> getInlayCreationArgs() {
        return this.inlayCreationArgs;
    }

    public final long getStamp() {
        return this.stamp;
    }

    public final boolean isEmpty() {
        boolean bl;
        boolean bl2 = bl = this.foldingCreationArgs.size() == this.inlayCreationArgs.size() && this.inlayCreationArgs.size() == this.highlighters.size();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Inlays, foldings, and highlighters are zipable";
            throw new AssertionError((Object)string);
        }
        return this.foldingCreationArgs.isEmpty() || this.inlayCreationArgs.isEmpty() || this.highlighters.isEmpty();
    }

    @NotNull
    public final List<RangeHighlighter> component1() {
        return this.highlighters;
    }

    @NotNull
    public final List<FoldingArgs> component2() {
        return this.foldingCreationArgs;
    }

    @NotNull
    public final List<InlayArgs> component3() {
        return this.inlayCreationArgs;
    }

    public final long component4() {
        return this.stamp;
    }

    @NotNull
    public final VirtualFormattingApplicationStrategy copy(@NotNull List<? extends RangeHighlighter> highlighters, @NotNull List<FoldingArgs> foldingCreationArgs, @NotNull List<InlayArgs> inlayCreationArgs, long stamp) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Intrinsics.checkNotNullParameter(foldingCreationArgs, (String)"foldingCreationArgs");
        Intrinsics.checkNotNullParameter(inlayCreationArgs, (String)"inlayCreationArgs");
        return new VirtualFormattingApplicationStrategy(highlighters, foldingCreationArgs, inlayCreationArgs, stamp);
    }

    public static /* synthetic */ VirtualFormattingApplicationStrategy copy$default(VirtualFormattingApplicationStrategy virtualFormattingApplicationStrategy, List list2, List list3, List list4, long l, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = virtualFormattingApplicationStrategy.highlighters;
        }
        if ((n & 2) != 0) {
            list3 = virtualFormattingApplicationStrategy.foldingCreationArgs;
        }
        if ((n & 4) != 0) {
            list4 = virtualFormattingApplicationStrategy.inlayCreationArgs;
        }
        if ((n & 8) != 0) {
            l = virtualFormattingApplicationStrategy.stamp;
        }
        return virtualFormattingApplicationStrategy.copy(list2, list3, list4, l);
    }

    @NotNull
    public String toString() {
        return "VirtualFormattingApplicationStrategy(highlighters=" + this.highlighters + ", foldingCreationArgs=" + this.foldingCreationArgs + ", inlayCreationArgs=" + this.inlayCreationArgs + ", stamp=" + this.stamp + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.highlighters).hashCode();
        result2 = result2 * 31 + ((Object)this.foldingCreationArgs).hashCode();
        result2 = result2 * 31 + ((Object)this.inlayCreationArgs).hashCode();
        result2 = result2 * 31 + Long.hashCode(this.stamp);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VirtualFormattingApplicationStrategy)) {
            return false;
        }
        VirtualFormattingApplicationStrategy virtualFormattingApplicationStrategy = (VirtualFormattingApplicationStrategy)other;
        if (!Intrinsics.areEqual(this.highlighters, virtualFormattingApplicationStrategy.highlighters)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.foldingCreationArgs, virtualFormattingApplicationStrategy.foldingCreationArgs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inlayCreationArgs, virtualFormattingApplicationStrategy.inlayCreationArgs)) {
            return false;
        }
        return this.stamp == virtualFormattingApplicationStrategy.stamp;
    }
}

