/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.psi.PsiFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathUtil;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdOpenFileDescriptor;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcherKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.actions.RiderActionsSupport;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.daemon.RiderHighlightingSupport;
import com.jetbrains.rider.document.RiderDocumentBindingService;
import com.jetbrains.rider.document.RiderDocumentExKt;
import com.jetbrains.rider.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.rider.editors.DocCoordinates;
import com.jetbrains.rider.editors.RiderCustomLanguageFeatureProvider;
import com.jetbrains.rider.editors.RiderTextControlHost;
import com.jetbrains.rider.intentions.RiderAutoImportSupport;
import com.jetbrains.rider.intentions.altEnter.RiderAltEnterSupport;
import com.jetbrains.rider.model.RdFrontendDocumentId;
import com.jetbrains.rider.model.RdProjectFileDocumentId;
import com.jetbrains.rider.parameterInfo.RiderParameterInfoSupport;
import com.jetbrains.rider.platform.ProtocolLanguageFeatureProvider;
import com.jetbrains.rider.projectView.RiderOpenFileDescriptorKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.quickDoc.RiderQuickDocSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u000e*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0010\u001a\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u0010*\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f\u001a%\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$\"\u001e\u0010%\u001a\u0012\u0012\u0004\u0012\u00020'0&j\b\u0012\u0004\u0012\u00020'`(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006)"}, d2={"dumpAllIdeaEditors", "", "project", "Lcom/intellij/openapi/project/Project;", "precisePath", "", "pmIdToString", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "dumpIdeaFileEditors", "offsetToDocCoordinates", "Lcom/jetbrains/rider/editors/DocCoordinates;", "Lcom/intellij/openapi/editor/Document;", "offset", "", "getProjectModelId", "Lcom/intellij/openapi/editor/Editor;", "getProjectName", "tryGetEditor", "textControlHost", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;", "hasAnyBackendFeature", "psiFile", "Lcom/intellij/psi/PsiFile;", "assertCorrectContextForSharedFile", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "tryOpenTextEditorWithProjectModelId", "activate", "descriptor", "Lcom/jetbrains/rd/ide/model/RdOpenFileDescriptor;", "suspendProtocolProcessingCookie", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "allBackendProviders", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/platform/ProtocolLanguageFeatureProvider;", "Lkotlin/collections/ArrayList;", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextControlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextControlUtils.kt\ncom/jetbrains/rider/editors/TextControlUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n*L\n1#1,298:1\n261#1:307\n262#1:311\n270#1,12:313\n283#1:326\n6479#2:299\n1755#3,3:300\n774#3:303\n865#3,2:304\n1863#3:312\n1864#3:325\n1863#3,2:331\n1#4:306\n39#5,3:308\n43#5:327\n39#5,3:328\n43#5:333\n*S KotlinDebug\n*F\n+ 1 TextControlUtils.kt\ncom/jetbrains/rider/editors/TextControlUtilsKt\n*L\n243#1:307\n243#1:311\n243#1:313,12\n243#1:326\n120#1:299\n223#1:300,3\n234#1:303\n234#1:304,2\n243#1:312\n243#1:325\n262#1:331,2\n243#1:308,3\n243#1:327\n261#1:328,3\n261#1:333\n*E\n"})
public final class TextControlUtilsKt {
    @NotNull
    private static final ArrayList<ProtocolLanguageFeatureProvider> allBackendProviders;

    @NotNull
    public static final String dumpAllIdeaEditors(@NotNull Project project, boolean precisePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StringBuilder result2 = new StringBuilder();
        StringBuilder stringBuilder = result2.append("Idea editors:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
        Editor[] editors = editorArray;
        int i = 1;
        for (Editor editor : editors) {
            Document document;
            Object object;
            Object documentId;
            StringBuilder stringBuilder2 = result2.append("Editor #" + i);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = result2.append("ToString(): " + editor);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            if (editor == null) {
                StringBuilder stringBuilder4 = result2.append("no Editor associated with this FileEditor");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                continue;
            }
            TextControlId textControlId = DocumentExKt.getTextControlId(editor);
            if (textControlId != null) {
                String pmIdState = TextControlUtilsKt.pmIdToString(textControlId, precisePath);
                RdDocumentId rdDocumentId = textControlId.getDocumentId();
                documentId = rdDocumentId instanceof RdFileDocumentId ? (RdFileDocumentId)rdDocumentId : null;
                Object object2 = documentId;
                String name = object2 != null && (object2 = object2.getFilePath()) != null && (object2 = DocumentUtilKt.toVirtualFile((String)object2, true)) != null ? object2.getName() : null;
                object = "file=" + name + " projectModelId:" + pmIdState + " tabId:" + textControlId.getTabIndex();
            } else {
                object = "null";
            }
            String textControlIdDump = object;
            StringBuilder stringBuilder5 = result2.append("Model id: " + textControlIdDump);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            documentId = result2;
            Object object3 = virtualFile;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = "null file";
            }
            StringBuilder stringBuilder6 = ((StringBuilder)documentId).append("Virtual file: " + (String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument(), (String)"getDocument(...)");
            DocCoordinates pos = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getCaretModel().getCurrentCaret().getOffset());
            StringBuilder stringBuilder7 = result2.append("Current caret: (" + pos.getLine() + ", " + pos.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            DocCoordinates selectionStart = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getSelectionModel().getSelectionStart());
            DocCoordinates selectionEnd = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getSelectionModel().getSelectionEnd());
            StringBuilder stringBuilder8 = result2.append("Current selection:  startPosition = (" + selectionStart.getLine() + ", " + selectionStart.getColumn() + ") endPosition = (" + selectionEnd.getLine() + ", " + selectionEnd.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            ++i;
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String dumpAllIdeaEditors$default(Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return TextControlUtilsKt.dumpAllIdeaEditors(project, bl);
    }

    @NotNull
    public static final String pmIdToString(@NotNull TextControlId textControlId, boolean precisePath) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Integer projectModelId = RiderDocumentExKt.getProjectModelId(textControlId.getDocumentId());
        if (projectModelId != null) {
            String pmIdState = projectModelId.toString();
            if (!precisePath) {
                pmIdState = projectModelId != 0 ? "!=0" : "=0(Misc Files)";
            }
            return pmIdState;
        }
        return "<no model>";
    }

    @NotNull
    public static final String dumpIdeaFileEditors(@NotNull Project project, boolean precisePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        StringBuilder result2 = new StringBuilder();
        StringBuilder stringBuilder = result2.append("Idea editors:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        Object[] objectArray = FileEditorManager.getInstance((Project)project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllEditors(...)");
        Object[] fileEditors = objectArray;
        int i = 1;
        Object[] $this$sortedBy$iv = fileEditors;
        boolean $i$f$sortedBy = false;
        for (FileEditor fileEditor : ArraysKt.sortedWith((Object[])$this$sortedBy$iv, (Comparator)new Comparator(project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
            }

            public final int compare(T a, T b) {
                String string;
                String string2;
                boolean bl;
                CharSequence charSequence;
                FileEditor fileEditor = (FileEditor)a;
                boolean bl2 = false;
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                RdDocumentId documentId = textEditor != null && (textEditor = textEditor.getEditor()) != null && (textEditor = DocumentExKt.getTextControlId((Editor)textEditor)) != null ? textEditor.getDocumentId() : null;
                Object object = documentId;
                if (object != null && (object = RiderDocumentExKt.getPath(object, this.$project$inlined)) != null) {
                    CharSequence charSequence2;
                    charSequence = (CharSequence)object;
                    if (charSequence.length() == 0) {
                        bl = false;
                        charSequence2 = documentId.toString();
                    } else {
                        charSequence2 = charSequence;
                    }
                    string2 = (String)charSequence2;
                } else {
                    string2 = null;
                }
                fileEditor = (FileEditor)b;
                Comparable comparable = (Comparable)((Object)string2);
                bl2 = false;
                TextEditor textEditor2 = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                documentId = textEditor2 != null && (textEditor2 = textEditor2.getEditor()) != null && (textEditor2 = DocumentExKt.getTextControlId((Editor)textEditor2)) != null ? textEditor2.getDocumentId() : null;
                Object object2 = documentId;
                if (object2 != null && (object2 = RiderDocumentExKt.getPath(object2, this.$project$inlined)) != null) {
                    CharSequence charSequence3;
                    charSequence = (CharSequence)object2;
                    if (charSequence.length() == 0) {
                        bl = false;
                        charSequence3 = documentId.toString();
                    } else {
                        charSequence3 = charSequence;
                    }
                    string = (String)charSequence3;
                } else {
                    string = null;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        })) {
            Document document;
            Object object;
            CharSequence fileName;
            Editor editor;
            StringBuilder stringBuilder2 = result2.append("Editor #" + i);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            StringBuilder stringBuilder3 = result2.append("Name: " + fileEditor.getName());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            Object object2 = editor = textEditor != null ? textEditor.getEditor() : null;
            if (editor == null) {
                StringBuilder stringBuilder4 = result2.append("no Editor associated with this FileEditor");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
                continue;
            }
            TextControlId textControlId = DocumentExKt.getTextControlId(editor);
            if (textControlId != null) {
                RdDocumentId documentId = textControlId.getDocumentId();
                String string = PathUtil.getFileName((String)RiderDocumentExKt.getPath(documentId, project));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
                fileName = string;
                String projectModelIdString = TextControlUtilsKt.pmIdToString(textControlId, precisePath);
                object = "file=" + (String)fileName + " projectModelId" + projectModelIdString;
            } else {
                object = "null";
            }
            String textControlIdDump = object;
            StringBuilder stringBuilder5 = result2.append("Model id: " + textControlIdDump);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            fileName = result2;
            Object object3 = virtualFile;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = "null file";
            }
            StringBuilder stringBuilder6 = ((StringBuilder)fileName).append("Virtual file: " + (String)object3);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)editor.getDocument(), (String)"getDocument(...)");
            DocCoordinates pos = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getCaretModel().getCurrentCaret().getOffset());
            StringBuilder stringBuilder7 = result2.append("Current caret: (" + pos.getLine() + ", " + pos.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
            DocCoordinates selectionStart = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getSelectionModel().getSelectionStart());
            DocCoordinates selectionEnd = TextControlUtilsKt.offsetToDocCoordinates(document, editor.getSelectionModel().getSelectionEnd());
            StringBuilder stringBuilder8 = result2.append("Current selection:  startPosition = (" + selectionStart.getLine() + ", " + selectionStart.getColumn() + ") endPosition = (" + selectionEnd.getLine() + ", " + selectionEnd.getColumn() + ")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
            ++i;
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String dumpIdeaFileEditors$default(Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return TextControlUtilsKt.dumpIdeaFileEditors(project, bl);
    }

    @NotNull
    public static final DocCoordinates offsetToDocCoordinates(@NotNull Document $this$offsetToDocCoordinates, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$offsetToDocCoordinates, (String)"<this>");
        if (!(0 <= offset ? offset <= $this$offsetToDocCoordinates.getTextLength() : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int line = $this$offsetToDocCoordinates.getLineNumber(offset);
        int lineStartOffset = $this$offsetToDocCoordinates.getLineStartOffset(line);
        int column = offset - lineStartOffset;
        return new DocCoordinates(line, column);
    }

    public static final int getProjectModelId(@NotNull Editor $this$getProjectModelId) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectModelId, (String)"<this>");
        Project project = $this$getProjectModelId.getProject();
        if (project != null) {
            RdFrontendDocumentId id;
            Document document = $this$getProjectModelId.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId(document, project);
            RdFrontendDocumentId rdFrontendDocumentId = id = rdDocumentId instanceof RdFrontendDocumentId ? (RdFrontendDocumentId)rdDocumentId : null;
            if (id != null) {
                Integer n = RiderDocumentBindingService.Companion.getInstance(project).getProjectModelId(id);
                return n != null ? n : 0;
            }
        }
        Integer n = (Integer)$this$getProjectModelId.getUserData(RiderTextControlHost.Companion.getProjectModelIdKey());
        return n != null ? n : 0;
    }

    @NotNull
    public static final String getProjectName(@NotNull Editor $this$getProjectName) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectName, (String)"<this>");
        String miscProjectName = "Misc Files";
        Project project = $this$getProjectName.getProject();
        if (project == null) {
            return miscProjectName;
        }
        Project project2 = project;
        int projectModelId = TextControlUtilsKt.getProjectModelId($this$getProjectName);
        if (projectModelId == 0) {
            return miscProjectName;
        }
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getProjectModelEntity(WorkspaceModel.Companion.getInstance(project2), projectModelId);
        if (projectModelEntity == null) {
            return miscProjectName;
        }
        ProjectModelEntity entity = projectModelEntity;
        ProjectModelEntity projectModelEntity2 = ProjectModelEntityExtensionsKt.containingProjectEntity(entity);
        if (projectModelEntity2 == null) {
            return miscProjectName;
        }
        ProjectModelEntity containingProjectEntity = projectModelEntity2;
        return containingProjectEntity.getName();
    }

    @Nullable
    public static final Editor tryGetEditor(@NotNull TextControlId $this$tryGetEditor, @NotNull FrontendTextControlHost textControlHost) {
        Intrinsics.checkNotNullParameter((Object)$this$tryGetEditor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)textControlHost), (String)"textControlHost");
        return textControlHost.getEditor($this$tryGetEditor);
    }

    @Deprecated(message="to be removed")
    public static final boolean hasAnyBackendFeature(@NotNull PsiFile psiFile) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            if (ClientCompletionSupport.Companion.getInstance().backendCompletionEnabledInFile(psiFile)) {
                return true;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && RiderHighlightingSupport.isAvailable(virtualFile)) {
                return true;
            }
            List list2 = psiFile.getViewProvider().getAllFiles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllFiles(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block8: {
                        PsiFile file = (PsiFile)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = allBackendProviders;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                ProtocolLanguageFeatureProvider it = (ProtocolLanguageFeatureProvider)element$iv2;
                                boolean bl4 = false;
                                Intrinsics.checkNotNull((Object)file);
                                if (!it.isAvailable(file)) continue;
                                bl2 = true;
                                break block8;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertCorrectContextForSharedFile(@NotNull RdDocumentId documentId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RdProjectFileDocumentId rdProjectFileDocumentId = documentId instanceof RdProjectFileDocumentId ? (RdProjectFileDocumentId)documentId : null;
        if (rdProjectFileDocumentId == null) {
            return;
        }
        RdProjectFileDocumentId projectFileDocumentId = rdProjectFileDocumentId;
        int projectModelId = projectFileDocumentId.getProjectModelElementId();
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        if (ProjectModelEntityExtensionsKt.isFromSharedProject(workspaceModel, projectModelId)) {
            VirtualFile virtualFile = AppLevelIdeBackend.Companion.getInstance().findVirtualFile(documentId);
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile;
            List<ProjectModelEntity> entities = WorkspaceModelExtensionsKt.getProjectModelEntities(workspaceModel, file, project);
            if (CollectionsKt.any((Iterable)entities)) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = entities;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
                    boolean bl = false;
                    if (!(!ProjectModelEntityExtensionsKt.isFromSharedProject(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                int normalProjectsCount = ((Collection)((List)destination$iv$iv)).size();
                if (!(normalProjectsCount == 0)) {
                    boolean bl = false;
                    String string = "Request to sync shared projectFile when there are normal project contexts";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Editor tryOpenTextEditorWithProjectModelId(@NotNull TextControlId textControlId, boolean activate, @NotNull RdOpenFileDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        boolean $i$f$suspendProtocolProcessingCookie = false;
        Lifetime.Companion this_$iv$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv$iv = new LifetimeDefinition();
        try {
            VirtualFile file;
            Lifetime lifetime$iv = def$iv$iv.getLifetime();
            boolean bl = false;
            Iterable $this$forEach$iv$iv = FrontendSessionsUtilKt.getFrontendSessions(ApplicationKt.getApplication());
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                ClientAppSession it$iv = (ClientAppSession)element$iv$iv;
                boolean bl2 = false;
                IRdDispatcherKt.getAsRdDispatcher((IScheduler)FrontendSessionsUtilKt.getProtocol(it$iv).getScheduler()).suppressPumping(lifetime$iv);
                if (!PatchEngineRegistryKt.isPatchEngineEnabled()) continue;
                BuildersKt.launch((CoroutineScope)lifetime$iv.getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(it$iv, null){
                    int label;
                    final /* synthetic */ ClientAppSession $it;
                    {
                        this.$it = $it;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = FrontendAsyncRequestExecutor.Companion.getInstance(this.$it).synchronizeWithPatchEngine((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                                    int label;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = DelayKt.awaitCancellation((Continuation)((Continuation)this));
                                                if (object3 != object2) throw new KotlinNothingValueException();
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                throw new KotlinNothingValueException();
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation<? super Unit>)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            boolean bl3 = false;
            RdDocumentId documentId = textControlId.getDocumentId();
            VirtualFile virtualFile = file = AppLevelIdeBackend.Companion.getInstance().findVirtualFile(documentId);
            if (!(virtualFile != null ? virtualFile.exists() : false)) {
                Editor editor = null;
                return editor;
            }
            RdProjectId rdProjectId = textControlId.getProjectId();
            if (rdProjectId == null || (rdProjectId = ProjectUtilKt.toProject((RdProjectId)rdProjectId)) == null) {
                Editor editor = null;
                return editor;
            }
            RdProjectId project = rdProjectId;
            Integer projectModelId = RiderDocumentExKt.getProjectModelId(documentId);
            if (projectModelId == null || projectModelId == 0) {
                Integer n = descriptor.getDocOffset();
                Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor((Project)project, file, n != null ? n : -1), activate);
                return editor;
            }
            Editor editor = (Editor)RiderOpenFileDescriptorKt.withProjectModelId(projectModelId, () -> TextControlUtilsKt.tryOpenTextEditorWithProjectModelId$lambda$7$lambda$6((Project)project, file, descriptor, activate));
            return editor;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv$iv, (boolean)false, (int)1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T suspendProtocolProcessingCookie(@NotNull Function0<? extends T> action2) {
        Object object;
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$suspendProtocolProcessingCookie = false;
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lifetime = def$iv.getLifetime();
            boolean bl = false;
            Iterable $this$forEach$iv = FrontendSessionsUtilKt.getFrontendSessions(ApplicationKt.getApplication());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClientAppSession it = (ClientAppSession)element$iv;
                boolean bl2 = false;
                IRdDispatcherKt.getAsRdDispatcher((IScheduler)FrontendSessionsUtilKt.getProtocol(it).getScheduler()).suppressPumping(lifetime);
                if (!PatchEngineRegistryKt.isPatchEngineEnabled()) continue;
                BuildersKt.launch((CoroutineScope)lifetime.getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */));
            }
            object = action2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    private static final Editor tryOpenTextEditorWithProjectModelId$lambda$7$lambda$6(Project $project, VirtualFile $file, RdOpenFileDescriptor $descriptor, boolean $activate) {
        Integer n = $descriptor.getDocOffset();
        return FileEditorManager.getInstance((Project)$project).openTextEditor(new OpenFileDescriptor($project, $file, n != null ? n : -1), $activate);
    }

    static {
        Object[] objectArray = new ProtocolLanguageFeatureProvider[]{RiderTypedHandlersSupport.INSTANCE, RiderActionsSupport.INSTANCE, RiderAltEnterSupport.INSTANCE, RiderAutoImportSupport.INSTANCE, RiderParameterInfoSupport.INSTANCE, RiderQuickDocSupport.INSTANCE, RiderCustomLanguageFeatureProvider.INSTANCE};
        allBackendProviders = CollectionsKt.arrayListOf((Object[])objectArray);
    }
}

