/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionHandler;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.document.RiderDocumentExKt;
import com.jetbrains.rider.editorActions.CustomTypingSessionPolicy;
import com.jetbrains.rider.editorActions.FrontendEditorActionInProgress;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.ITypingSessions;
import com.jetbrains.rider.editorActions.RiderEditorActionHandler;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/editorActions/FrontendTypingEditorActionHandler;", "Lcom/jetbrains/rider/editorActions/RiderEditorActionHandler;", "frontendId", "", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "shouldSkip", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "shouldSkipSandboxAction", "sandboxInfo", "Lcom/jetbrains/rd/ide/model/AbstractSandboxInfo;", "doExecute", "", "isSynchronous", "isSimpleChar", "char", "", "intellij.rider.rdclient.dotnet"})
public abstract class FrontendTypingEditorActionHandler
extends RiderEditorActionHandler {
    public FrontendTypingEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super(frontendId, baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (CustomTypingSessionPolicy.Companion.forceDisable(project2)) {
            return false;
        }
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project2);
        RiderDefaultBackend riderDefaultBackend = ideBackend instanceof RiderDefaultBackend ? (RiderDefaultBackend)ideBackend : null;
        if (riderDefaultBackend == null) {
            return false;
        }
        RiderDefaultBackend backend = riderDefaultBackend;
        if (this.shouldSkip(backend, editor)) {
            return false;
        }
        Caret caret2 = caret;
        if (backend.getTypedHandler(editor, caret2 != null ? caret2.getOffset() : editor.getCaretModel().getOffset()) == null) {
            return false;
        }
        return super.backendIsEnabledForCaret(editor, caret, dataContext);
    }

    protected boolean shouldSkip(@NotNull IdeBackend backend, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)backend.getSolution().getSolutionLifecycle().isReadyForTyping()))) {
            return true;
        }
        if (EditorUtilKt.hasMultipleEditPoints(editor)) {
            return true;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        AbstractSandboxInfo sandboxInfo = RiderDocumentExKt.getSandBoxInfo(document);
        return sandboxInfo != null && this.shouldSkipSandboxAction(sandboxInfo);
    }

    protected boolean shouldSkipSandboxAction(@NotNull AbstractSandboxInfo sandboxInfo) {
        Intrinsics.checkNotNullParameter((Object)sandboxInfo, (String)"sandboxInfo");
        return sandboxInfo.getDisableTypingActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        FrontendEditorActionInProgress.Companion.getThreadLocalCookie().set(new FrontendEditorActionInProgress(this, null, editor, dataContext));
        try {
            boolean ret = this.backendIsEnabledForCaret(editor, caret, dataContext);
            Project project = DataContextKt.getProject((DataContext)dataContext);
            if (ret && project != null && TypingSessions.Companion.isEnabled(project)) {
                IdeBackend backend = IdeBackend.Companion.getInstance(project);
                ITypingSessions typingSessions = TypingSessions.Companion.getInstance(project);
                if (!this.isSynchronous(backend, editor, caret)) {
                    typingSessions.executeTypedAction(this.getFrontendId(), editor, dataContext, (Function0<Unit>)((Function0)() -> FrontendTypingEditorActionHandler.doExecute$lambda$0(this, editor, caret, dataContext)));
                    return;
                }
                typingSessions.waitForSessionTermination("sync typed action '" + this.getFrontendId() + "'");
            }
            super.doExecute(editor, caret, dataContext);
            return;
        }
        finally {
            FrontendEditorActionInProgress.Companion.getThreadLocalCookie().set(null);
        }
    }

    protected boolean isSynchronous(@NotNull IdeBackend backend, @NotNull Editor editor, @Nullable Caret caret) {
        Intrinsics.checkNotNullParameter((Object)((Object)backend), (String)"backend");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        RiderDefaultBackend cfr_ignored_0 = (RiderDefaultBackend)backend;
        Caret caret2 = caret;
        FrontendTypedHandler frontendTypedHandler = ((RiderDefaultBackend)backend).getTypedHandler(editor, caret2 != null ? caret2.getOffset() : editor.getCaretModel().getOffset());
        if (frontendTypedHandler == null) {
            throw new IllegalStateException("typedHandler".toString());
        }
        FrontendTypedHandler typedHandler = frontendTypedHandler;
        return typedHandler.isBackendTypedActionSync(this.getFrontendId(), backend.getProject());
    }

    protected boolean isSimpleChar(char c) {
        return Character.isLetterOrDigit(c) || CharsKt.isWhitespace((char)c) || c == '.';
    }

    private static final Unit doExecute$lambda$0(FrontendTypingEditorActionHandler this$0, Editor $editor, Caret $caret, DataContext $dataContext) {
        FrontendEditorActionHandler.getLogger().info("Executing frontend editor base handler '" + this$0.getFrontendId() + "'");
        this$0.executeOnFrontend($editor, $caret, $dataContext);
        return Unit.INSTANCE;
    }
}

