/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.services.IdeBackend;
import com.jetbrains.rider.document.RiderDocumentExKt;
import com.jetbrains.rider.editorActions.AsynchronousFrontendTypedHandlerStrategy;
import com.jetbrains.rider.editorActions.CustomTypingSessionPolicy;
import com.jetbrains.rider.editorActions.FrontendTypedHandler;
import com.jetbrains.rider.editorActions.IFrontendTypingListener;
import com.jetbrains.rider.editorActions.SynchronousFrontendTypedHandlerStrategy;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.services.RiderDefaultBackend;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@RiderOnly
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/editorActions/FrontendTypedHandlerManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "shouldSkip", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "c", "", "typeCharOnBackend", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.rider.rdclient.dotnet"})
public final class FrontendTypedHandlerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Topic<IFrontendTypingListener> BEFORE_TYPING_SENT = new Topic("Before the typing signals are sent to backend", IFrontendTypingListener.class);
    @NotNull
    public static final String syncAllSymbolsKey = "rider.typing.syncAllSymbols";

    public FrontendTypedHandlerManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final boolean shouldSkip(Editor editor, IdeBackend backend, char c) {
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)backend.getSolution().getSolutionLifecycle().isReadyForTyping()))) {
            return true;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        AbstractSandboxInfo sandboxInfo = RiderDocumentExKt.getSandBoxInfo(document);
        if (FileDocumentManager.getInstance().getFile(editor.getDocument()) == null && sandboxInfo == null) {
            return true;
        }
        return sandboxInfo != null && sandboxInfo.getDisableTypingAssists().contains(Character.valueOf(c));
    }

    @NotNull
    public final TypedHandlerDelegate.Result typeCharOnBackend(char c, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (CustomTypingSessionPolicy.Companion.forceDisable(this.project)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        IdeBackend ideBackend = IdeBackend.Companion.tryGetInstance(project);
        RiderDefaultBackend riderDefaultBackend = ideBackend instanceof RiderDefaultBackend ? (RiderDefaultBackend)ideBackend : null;
        if (riderDefaultBackend == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        RiderDefaultBackend backend = riderDefaultBackend;
        if (this.shouldSkip(editor, backend, c)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        FrontendTypedHandler frontendTypedHandler = backend.getTypedHandler(editor, editor.getCaretModel().getOffset());
        if (frontendTypedHandler == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        FrontendTypedHandler typeHandler = frontendTypedHandler;
        return TypingSessions.Companion.isEnabled(this.project) ? AsynchronousFrontendTypedHandlerStrategy.INSTANCE.typeChar(c, typeHandler, editor, backend) : SynchronousFrontendTypedHandlerStrategy.INSTANCE.typeChar(c, typeHandler, editor, backend);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/editorActions/FrontendTypedHandlerManager$Companion;", "", "<init>", "()V", "BEFORE_TYPING_SENT", "Lcom/intellij/util/messages/Topic;", "Lcom/jetbrains/rider/editorActions/IFrontendTypingListener;", "kotlin.jvm.PlatformType", "getBEFORE_TYPING_SENT", "()Lcom/intellij/util/messages/Topic;", "syncAllSymbolsKey", "", "getInstance", "Lcom/jetbrains/rider/editorActions/FrontendTypedHandlerManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nFrontendTypedHandlerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTypedHandlerManager.kt\ncom/jetbrains/rider/editorActions/FrontendTypedHandlerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,56:1\n31#2,2:57\n*S KotlinDebug\n*F\n+ 1 FrontendTypedHandlerManager.kt\ncom/jetbrains/rider/editorActions/FrontendTypedHandlerManager$Companion\n*L\n29#1:57,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<IFrontendTypingListener> getBEFORE_TYPING_SENT() {
            return BEFORE_TYPING_SENT;
        }

        @NotNull
        public final FrontendTypedHandlerManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FrontendTypedHandlerManager> serviceClass$iv = FrontendTypedHandlerManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FrontendTypedHandlerManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

