/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.actions.RdDataContextManager;
import com.jetbrains.rd.ide.model.ClipboardHandlerRequest;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionHandler;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.editorActions.RiderEditorActionHandler;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.services.RiderDefaultBackend;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/editorActions/CopyOrCutHandler;", "Lcom/jetbrains/rider/editorActions/RiderEditorActionHandler;", "isCopyAction", "", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(ZLcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "callClipboardHandler", "Companion", "intellij.rider.rdclient.dotnet"})
public class CopyOrCutHandler
extends RiderEditorActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean isNestedExecution;

    public CopyOrCutHandler(boolean isCopyAction, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super(isCopyAction ? "EditorCopy" : "EditorCut", baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return false;
        }
        return super.backendIsEnabledForCaret(editor, caret, dataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean ret = this.backendIsEnabledForCaret(editor, caret, dataContext);
        if (ret && !isNestedExecution) {
            this.callClipboardHandler(dataContext);
            try {
                isNestedExecution = true;
                FrontendEditorActionHandler.getLogger().debug("Executing frontend editor base handler '" + this.getFrontendId() + "'");
                this.executeOnFrontend(editor, caret, dataContext);
            }
            finally {
                isNestedExecution = false;
            }
        } else {
            FrontendEditorActionHandler.getLogger().debug("Executing frontend editor base handler '" + this.getFrontendId() + "'");
            this.executeOnFrontend(editor, caret, dataContext);
        }
    }

    private final void callClipboardHandler(DataContext dataContext) {
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            FrontendEditorActionHandler.getLogger().error("project is null");
            return;
        }
        List modelDataContext = RdDataContextManager.Companion.createDataContextModel(dataContext);
        RiderDefaultBackend backend = RiderDefaultBackend.Companion.getInstance(project);
        String backendId = backend.getBackendActionId(this.getFrontendId());
        FrontendEditorActionHandler.getLogger().debug("Executing read-only clipboard editor handler '" + this.getFrontendId() + "'");
        LastFocusedEditorSuppressor.Companion.getInstance(project).forceReleaseSuppressionForLastFocusedEditor("Release all frontend changes before executing " + this.getFrontendId());
        backend.getActionsModel().getCopyOrCutHandler().fire((Object)new ClipboardHandlerRequest(backendId, modelDataContext));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/editorActions/CopyOrCutHandler$Companion;", "", "<init>", "()V", "isNestedExecution", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

