/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.RdCommandProcessor;
import com.jetbrains.rd.ide.model.RdCommandProcessor_GeneratedKt;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0017J\b\u0010\t\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/document/RiderReloadVetoer;", "Lcom/intellij/openapi/fileEditor/FileDocumentSynchronizationVetoer;", "<init>", "()V", "maySaveDocument", "", "document", "Lcom/intellij/openapi/editor/Document;", "isSaveExplicit", "isUnderBackendCommand", "mayReloadFileContent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSyncingFromBackend", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderReloadVetoer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n1863#2,2:128\n13#3:130\n14#4:131\n*S KotlinDebug\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer\n*L\n74#1:128,2\n22#1:130\n22#1:131\n*E\n"})
public final class RiderReloadVetoer
extends FileDocumentSynchronizationVetoer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    private static boolean isDocumentLoading;
    @NotNull
    private static final Set<Document> documentsToReload;

    @RequiresEdt
    public boolean maySaveDocument(@NotNull Document document, boolean isSaveExplicit) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        String string = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        logger.debug("maySaveDocument for " + StringsKt.take((String)string, (int)15));
        if (ApplicationManager.getApplication().isDisposed() || isSaveExplicit) {
            return true;
        }
        boolean isSyncingFromBackend = this.isSyncingFromBackend();
        return !isSyncingFromBackend;
    }

    private final boolean isUnderBackendCommand() {
        Iterable $this$forEach$iv = ClientSessionsManager.Companion.getAppSessions(ClientKind.FRONTEND);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClientAppSession it = (ClientAppSession)element$iv;
            boolean bl = false;
            RdCommandProcessor commandProcessor = RdCommandProcessor_GeneratedKt.getRdCommandProcessor((DocumentsOperationModel)DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)FrontendSessionsUtilKt.getProtocol(it)));
            if (commandProcessor.getCurrentCommand().getValue() == null) continue;
            return true;
        }
        return false;
    }

    @RequiresEdt
    public boolean mayReloadFileContent(@NotNull VirtualFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        logger.debug("mayReloadFileContent for " + file);
        boolean isSyncingFromBackend = this.isSyncingFromBackend();
        if (isSyncingFromBackend) {
            return false;
        }
        if (file.getUserData(UndoConstants.FORCE_RECORD_UNDO) != null) {
            return false;
        }
        boolean underBackendCommand = this.isUnderBackendCommand();
        logger.debug("isUnderBackendCommand = " + underBackendCommand);
        if (underBackendCommand) {
            return false;
        }
        logger.debug("isDocumentLoading = " + isDocumentLoading);
        if (isDocumentLoading) {
            Companion.rememberReloadRequest(document);
            return false;
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return true;
        }
        return true;
    }

    private final boolean isSyncingFromBackend() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            if (!project2.isInitialized() || project2.isDisposed() || !RiderBackendInteractionHelper.Companion.getInstance(project2).isAnyGatewaySyncing()) continue;
            return true;
        }
        return false;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderReloadVetoer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderReloadVetoer.logger = logger;
        documentsToReload = new LinkedHashSet();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nJ\b\u0010\u0013\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/document/RiderReloadVetoer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isDocumentLoading", "", "documentsToReload", "", "Lcom/intellij/openapi/editor/Document;", "runWithReloadSuppress", "", "createdFilePath", "", "action", "Lkotlin/Function0;", "rememberReloadRequest", "document", "runSuppressedReloads", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nRiderReloadVetoer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1863#2,2:128\n*S KotlinDebug\n*F\n+ 1 RiderReloadVetoer.kt\ncom/jetbrains/rider/document/RiderReloadVetoer$Companion\n*L\n47#1:128,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        public final void runWithReloadSuppress(@NotNull String createdFilePath, @NotNull Function0<Unit> action2) {
            Intrinsics.checkNotNullParameter((Object)createdFilePath, (String)"createdFilePath");
            Intrinsics.checkNotNullParameter(action2, (String)"action");
            try {
                logger.debug("runWithReloadSuppress: Add suppression for: " + createdFilePath);
                isDocumentLoading = true;
                action2.invoke();
                logger.debug("runWithReloadSuppress: Remove suppression for: " + createdFilePath);
            }
            finally {
                isDocumentLoading = false;
                this.runSuppressedReloads();
            }
        }

        public final void rememberReloadRequest(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            documentsToReload.add(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void runSuppressedReloads() {
            try {
                Iterable $this$forEach$iv = documentsToReload;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Document document = (Document)element$iv;
                    boolean bl = false;
                    FileDocumentManager.getInstance().reloadFromDisk(document);
                }
            }
            finally {
                documentsToReload.clear();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

