/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.document;

import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.editors.EditorSynchronizerWithTypingSession;
import com.jetbrains.rider.editors.RiderBackendInteractionHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "recoveringQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "documentsToRecover", "Ljava/util/HashSet;", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "Lkotlin/collections/HashSet;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "operationModel", "Lcom/jetbrains/rd/ide/model/RiderProjectDocumentOperationModel;", "getOperationModel", "()Lcom/jetbrains/rd/ide/model/RiderProjectDocumentOperationModel;", "bindModel", "", "saveDocument", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "saveDocumentForceUndo", "processBeforeSaving", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "ProtocolListener", "BeforeDocumentSavedListener", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDocumentHostHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,209:1\n13#2:210\n14#3:211\n68#3,4:212\n68#3,4:216\n68#3,4:220\n68#3,4:224\n68#3,4:228\n*S KotlinDebug\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper\n*L\n51#1:210\n51#1:211\n178#1:212,4\n74#1:216,4\n130#1:220,4\n148#1:224,4\n151#1:228,4\n*E\n"})
public final class DocumentHostHelper
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final MergingUpdateQueue recoveringQueue;
    @NotNull
    private final HashSet<RdDocumentId> documentsToRecover;
    @NotNull
    private final Logger logger;

    public DocumentHostHelper(@NotNull ClientProjectSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.getServiceLifetime(), null, (int)1, null);
        this.recoveringQueue = new MergingUpdateQueue("recoverQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, this.disposable, null, true).setRestartTimerOnAdd(true);
        this.documentsToRecover = new HashSet();
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DocumentHostHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.disposable;
    }

    private final RiderProjectDocumentOperationModel getOperationModel() {
        return RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel(FrontendSessionsUtilKt.getProtocolModel(this.session));
    }

    private final void bindModel() {
        this.getOperationModel().getDoNotStripFiles().view(this.getServiceLifetime(), DocumentHostHelper::bindModel$lambda$1);
        this.getOperationModel().getNeedRecover().advise(this.getServiceLifetime(), arg_0 -> DocumentHostHelper.bindModel$lambda$3(this, arg_0));
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveAll()), null, null, (arg_0, arg_1) -> DocumentHostHelper.bindModel$lambda$4(this, arg_0, arg_1), (int)3, null);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveAllEditorsAfterBackendSync()), null, null, (arg_0, arg_1) -> DocumentHostHelper.bindModel$lambda$7(this, fileDocumentManager2, arg_0, arg_1), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getReloadFileAfterBackendChange()), null, null, arg_0 -> DocumentHostHelper.bindModel$lambda$8(fileDocumentManager2, arg_0), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveFileAfterBackendSync()), null, null, arg_0 -> DocumentHostHelper.bindModel$lambda$11(this, fileDocumentManager2, arg_0), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.getOperationModel().getSaveFiles()), null, null, arg_0 -> DocumentHostHelper.bindModel$lambda$14(this, fileDocumentManager2, arg_0), (int)3, null);
    }

    private final void saveDocument(VirtualFile virtualFile, Document document) {
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Syncing from backend is finished, no editors found for this document -> do save file " + virtualFile.getPath());
        }
        this.saveDocumentForceUndo(document, virtualFile);
    }

    private final void saveDocumentForceUndo(Document document, VirtualFile virtualFile) {
        UndoUtil.forceUndoIn((VirtualFile)virtualFile, () -> DocumentHostHelper.saveDocumentForceUndo$lambda$16(document));
    }

    private final void processBeforeSaving(Project project, Document document) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        ApplicationKt.getApplication().invokeLater(() -> DocumentHostHelper.processBeforeSaving$lambda$17(project, document, this, file));
    }

    private static final Unit bindModel$lambda$1$lambda$0(VirtualFile $vf) {
        TrailingSpacesStripper.setEnabled((VirtualFile)$vf, (boolean)true);
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$1(Lifetime doNotStripLifetime, int n, String path) {
        Intrinsics.checkNotNullParameter((Object)doNotStripLifetime, (String)"doNotStripLifetime");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile = DocumentUtilKt.toVirtualFile(path, false);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile vf = virtualFile;
        TrailingSpacesStripper.setEnabled((VirtualFile)vf, (boolean)false);
        doNotStripLifetime.onTermination(() -> DocumentHostHelper.bindModel$lambda$1$lambda$0(vf));
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$3(DocumentHostHelper this$0, RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        ApplicationKt.getApplication().assertIsDispatchThread();
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Received needRecover command for " + DocumentExKt.toDebugString((RdDocumentId)documentId) + " document...");
        }
        this$0.documentsToRecover.add(documentId);
        String string = "queue recover " + DocumentExKt.toDebugString((RdDocumentId)documentId);
        this$0.recoveringQueue.queue(new Update(this$0, string){
            final /* synthetic */ DocumentHostHelper this$0;
            {
                this.this$0 = $receiver;
                super((Object)$super_call_param$1, false, 0, 6, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                try {
                    void $this$forEach$iv;
                    ApplicationKt.getApplication().assertIsDispatchThread();
                    Iterable iterable = DocumentHostHelper.access$getDocumentsToRecover$p(this.this$0);
                    DocumentHostHelper documentHostHelper = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        RdDocumentId entityId = (RdDocumentId)element$iv;
                        boolean bl = false;
                        TypingSessions.Companion.getInstance(DocumentHostHelper.access$getSession$p(documentHostHelper)).forceCloseActiveSession("recovering");
                        EditorSynchronizerWithTypingSession.Companion.recoverEditorsSynchronization(entityId, DocumentHostHelper.access$getSession$p(documentHostHelper).getAppSession());
                    }
                }
                catch (Throwable t) {
                    DocumentHostHelper.access$getLogger$p(this.this$0).warn("Exception while recovering document:\n", t);
                }
                finally {
                    DocumentHostHelper.access$getDocumentsToRecover$p(this.this$0).clear();
                }
            }
        });
        return Unit.INSTANCE;
    }

    private static final RdTask bindModel$lambda$4(DocumentHostHelper this$0, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        this$0.logger.info("saveAll command received...");
        ApplicationKt.getApplication().saveAll();
        this$0.logger.info("saveAll command has finished");
        RdTask result2 = new RdTask();
        result2.set((Object)true);
        return result2;
    }

    private static final Unit bindModel$lambda$7$lambda$6(FileDocumentManager $fileDocumentManager, RdTask $task) {
        $fileDocumentManager.saveAllDocuments();
        $task.set((Object)true);
        return Unit.INSTANCE;
    }

    private static final RdTask bindModel$lambda$7(DocumentHostHelper this$0, FileDocumentManager $fileDocumentManager, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        if (!(CommandProcessor.getInstance().getCurrentCommand() == null)) {
            boolean bl2 = false;
            String string = "Cannot call 'save all files' inside " + CommandProcessor.getInstance().getCurrentCommandName() + " command. This can potentially break the undo stack.";
            throw new IllegalArgumentException(string.toString());
        }
        RdTask task = new RdTask();
        RiderBackendInteractionHelper.Companion.getInstance(this$0.session.getAppSession()).onSyncFromBackendFinished(this$0.getServiceLifetime(), (Function0<Unit>)((Function0)() -> DocumentHostHelper.bindModel$lambda$7$lambda$6($fileDocumentManager, task)));
        return task;
    }

    private static final boolean bindModel$lambda$8(FileDocumentManager $fileDocumentManager, String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        VirtualFile virtualFile = DocumentUtilKt.toVirtualFile(filePath, true);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        virtualFile2.refresh(false, false);
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile2};
        $fileDocumentManager.reloadFiles(virtualFileArray);
        return true;
    }

    private static final Unit bindModel$lambda$11$lambda$10(DocumentHostHelper this$0, VirtualFile $virtualFile, Document $document) {
        this$0.saveDocument($virtualFile, $document);
        return Unit.INSTANCE;
    }

    private static final boolean bindModel$lambda$11(DocumentHostHelper this$0, FileDocumentManager $fileDocumentManager, String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            Logger $this$trace$iv = this$0.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Got saveFileAfterBackendSync command for the file " + filePath + "...");
            }
            VirtualFile virtualFile = DocumentUtilKt.toVirtualFile(filePath, true);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile virtualFile2 = virtualFile;
            Document document = $fileDocumentManager.getDocument(virtualFile2);
            if (document == null) {
                return false;
            }
            Document document2 = document;
            RiderBackendInteractionHelper.Companion.getInstance(this$0.session.getAppSession()).onSyncFromBackendFinished(this$0.getServiceLifetime(), (Function0<Unit>)((Function0)() -> DocumentHostHelper.bindModel$lambda$11$lambda$10(this$0, virtualFile2, document2)));
            return true;
        }
        catch (Throwable t) {
            this$0.logger.error(t);
            return false;
        }
    }

    private static final boolean bindModel$lambda$14(DocumentHostHelper this$0, FileDocumentManager $fileDocumentManager, List filePaths) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)filePaths, (String)"filePaths");
        boolean result2 = true;
        Logger $this$trace$iv = this$0.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Got saveFiles command for " + ((Collection)filePaths).size() + " files");
        }
        for (String filePath : filePaths) {
            try {
                Logger $this$trace$iv2 = this$0.logger;
                boolean $i$f$trace2 = false;
                if ($this$trace$iv2.isTraceEnabled()) {
                    logger = $this$trace$iv2;
                    boolean bl = false;
                    logger.trace("Saving file " + filePath + " right away...");
                }
                VirtualFile virtualFile = DocumentUtilKt.toVirtualFile(filePath, true);
                if (virtualFile == null) {
                    this$0.logger.trace("Couldn't find vf by path " + filePath);
                    continue;
                }
                Document document = $fileDocumentManager.getDocument(virtualFile);
                if (document == null) {
                    this$0.logger.trace("Couldn't find document for vf " + virtualFile);
                    continue;
                }
                this$0.saveDocument(virtualFile, document);
            }
            catch (Throwable t) {
                this$0.logger.error("error while saving document " + filePath + ". Exception:\n" + t);
                result2 = false;
            }
        }
        return result2;
    }

    private static final void saveDocumentForceUndo$lambda$16(Document $document) {
        FileDocumentManager.getInstance().saveDocumentAsIs($document);
    }

    private static final void processBeforeSaving$lambda$17(Project $project, Document $document, DocumentHostHelper this$0, VirtualFile $file) {
        if ($project.isDisposed()) {
            return;
        }
        if (LookupManagerImpl.Companion.getInstance($project).getActiveLookup() == null) {
            Editor[] editorArray = EditorFactory.getInstance().getEditors($document, $project);
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
            for (Editor openedEditor : editorArray) {
                PreemptiveCompletionHost preemptiveCompletionHost = PreemptiveCompletionHost.Companion.getInstance($project);
                Intrinsics.checkNotNull((Object)openedEditor);
                preemptiveCompletionHost.terminateCurrentCompletion(openedEditor, "Save document on disk");
            }
        }
        ISignal<String> iSignal = this$0.getOperationModel().getAfterDocumentInEditorSaved();
        String string = $file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        iSignal.fire((Object)string);
    }

    public static final /* synthetic */ HashSet access$getDocumentsToRecover$p(DocumentHostHelper $this) {
        return $this.documentsToRecover;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DocumentHostHelper $this) {
        return $this.logger;
    }

    public static final /* synthetic */ ClientProjectSession access$getSession$p(DocumentHostHelper $this) {
        return $this.session;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper$BeforeDocumentSavedListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "beforeDocumentSaving", "", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rider.rdclient.dotnet"})
    public static final class BeforeDocumentSavedListener
    implements FileDocumentManagerListener {
        @NotNull
        private final Project project;

        public BeforeDocumentSavedListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void beforeDocumentSaving(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Companion.getInstance(this.project).processBeforeSaving(this.project, document);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/document/DocumentHostHelper;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nDocumentHostHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,209:1\n23#2:210\n*S KotlinDebug\n*F\n+ 1 DocumentHostHelper.kt\ncom/jetbrains/rider/document/DocumentHostHelper$Companion\n*L\n42#1:210\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentHostHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project));
        }

        @NotNull
        public final DocumentHostHelper getInstance(@NotNull ClientProjectSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session2;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(DocumentHostHelper.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (DocumentHostHelper)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/document/DocumentHostHelper$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/RiderProjectDocumentOperationModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.rdclient.dotnet"})
    public static final class ProtocolListener
    implements SolutionExtListener<RiderProjectDocumentOperationModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session2, @NotNull RiderProjectDocumentOperationModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model2), (String)"model");
            Companion.getInstance(session2).bindModel();
        }
    }
}

