/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AppUIUtil;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.diagnostics.SpecialPathEntry;
import com.jetbrains.rider.diagnostics.SpecialPathsProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/diagnostics/ApplicationSpecialPathsProvider;", "Lcom/jetbrains/rider/diagnostics/SpecialPathsProvider;", "<init>", "()V", "collectPaths", "", "Lcom/jetbrains/rider/diagnostics/SpecialPathEntry;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
public final class ApplicationSpecialPathsProvider
implements SpecialPathsProvider {
    @Override
    @NotNull
    public List<SpecialPathEntry> collectPaths(@Nullable Project project) {
        Object[] objectArray = new SpecialPathEntry[15];
        String string = PathManager.getHomePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHomePath(...)");
        objectArray[0] = new SpecialPathEntry("Installation home directory", string, SpecialPathEntry.Kind.Folder);
        String string2 = PathManager.getSystemPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSystemPath(...)");
        objectArray[1] = new SpecialPathEntry("System directory", string2, SpecialPathEntry.Kind.Folder);
        String string3 = PathManager.getConfigPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getConfigPath(...)");
        objectArray[2] = new SpecialPathEntry("Config directory", string3, SpecialPathEntry.Kind.Folder);
        String string4 = PathManager.getBinPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getBinPath(...)");
        objectArray[3] = new SpecialPathEntry("Bin directory", string4, SpecialPathEntry.Kind.Folder);
        String string5 = PathManager.getLibPath();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getLibPath(...)");
        objectArray[4] = new SpecialPathEntry("Lib directory", string5, SpecialPathEntry.Kind.Folder);
        String string6 = PathManager.getOptionsPath();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getOptionsPath(...)");
        objectArray[5] = new SpecialPathEntry("Options directory", string6, SpecialPathEntry.Kind.Folder);
        String string7 = PathManager.getPluginsPath();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPluginsPath(...)");
        objectArray[6] = new SpecialPathEntry("PLUGINS Main directory", string7, SpecialPathEntry.Kind.Folder);
        String string8 = PathManager.getPluginTempPath();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getPluginTempPath(...)");
        objectArray[7] = new SpecialPathEntry("PLUGINS Temp directory", string8, SpecialPathEntry.Kind.Folder);
        String string9 = PathManager.getPreInstalledPluginsPath();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getPreInstalledPluginsPath(...)");
        objectArray[8] = new SpecialPathEntry("PLUGINS PreInstalled directory", string9, SpecialPathEntry.Kind.Folder);
        String string10 = PathManager.getScratchPath();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getScratchPath(...)");
        objectArray[9] = new SpecialPathEntry("MISC Scratch directory", string10, SpecialPathEntry.Kind.Folder);
        String string11 = PathManager.getTempPath();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getTempPath(...)");
        objectArray[10] = new SpecialPathEntry("MISC Temp directory", string11, SpecialPathEntry.Kind.Folder);
        String string12 = PathManager.getLogPath();
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getLogPath(...)");
        objectArray[11] = new SpecialPathEntry("LOGS folder", string12, SpecialPathEntry.Kind.Folder);
        objectArray[12] = new SpecialPathEntry("LOGS frontend.log", PathManager.getLogPath() + "/frontend.log", SpecialPathEntry.Kind.File);
        objectArray[13] = new SpecialPathEntry("LOGS backend.log", PathManager.getLogPath() + "/backend.log", SpecialPathEntry.Kind.File);
        objectArray[14] = new SpecialPathEntry("LOG CONF backend", RiderEnvironment.INSTANCE.getLogBackendConf(), SpecialPathEntry.Kind.File);
        List allOsPaths = CollectionsKt.listOf((Object[])objectArray);
        if (SystemInfo.isLinux) {
            File userDesktopEntry = new File(System.getProperty("user.home"), ".local/share/applications/" + AppUIUtil.INSTANCE.getFrameClass() + ".desktop");
            File systemDesktopEntry = new File("/usr/share/applications/" + AppUIUtil.INSTANCE.getFrameClass() + ".desktop");
            List desktopEntries = new ArrayList();
            if (userDesktopEntry.exists()) {
                String string13 = userDesktopEntry.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getPath(...)");
                desktopEntries.add(new SpecialPathEntry("User desktop entry", string13, SpecialPathEntry.Kind.File));
            }
            if (systemDesktopEntry.exists()) {
                String string14 = systemDesktopEntry.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"getPath(...)");
                desktopEntries.add(new SpecialPathEntry("System desktop entry", string14, SpecialPathEntry.Kind.File));
            }
            return CollectionsKt.plus((Collection)allOsPaths, (Iterable)desktopEntries);
        }
        return allOsPaths;
    }
}

