/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.DocumentVersion;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.rdtext.impl.RdTextBuffer;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rd.rdtext.intrinsics.RdTextChangeKt;
import com.jetbrains.rd.rdtext.intrinsics.TextBufferVersion;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\nH\u0002J2\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter;", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "textBuffer", "Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/rdtext/impl/RdTextBuffer;)V", "history", "Ljava/util/LinkedHashMap;", "Lcom/jetbrains/rd/rdtext/intrinsics/TextBufferVersion;", "Lcom/jetbrains/rd/rdtext/intrinsics/RdTextChange;", "Lkotlin/collections/LinkedHashMap;", "latestKnownSlaveVersion", "shrinkHistory", "", "clearHistoryBefore", "bufferVersion", "shiftRange", "Lcom/intellij/openapi/util/TextRange;", "v", "Lcom/jetbrains/rd/ide/model/AbstractDocumentVersion;", "range", "isVerifiable", "", "isGreedyToLeft", "isGreedyToRight", "shiftOnePoint", "", "offset", "isStickingToRight", "checkVersions", "version", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nTextBufferDocumentRangeShifter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextBufferDocumentRangeShifter.kt\ncom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n1#2:148\n68#3,4:149\n68#3,4:153\n68#3,4:157\n14#3:161\n*S KotlinDebug\n*F\n+ 1 TextBufferDocumentRangeShifter.kt\ncom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter\n*L\n42#1:149,4\n32#1:153,4\n36#1:157,4\n23#1:161\n*E\n"})
public final class TextBufferDocumentRangeShifter
implements IDocumentRangeShifter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RdTextBuffer textBuffer;
    @NotNull
    private final LinkedHashMap<TextBufferVersion, RdTextChange> history;
    @NotNull
    private TextBufferVersion latestKnownSlaveVersion;
    @NotNull
    private static final Logger LOG;

    public TextBufferDocumentRangeShifter(@NotNull Lifetime lifetime, @NotNull RdTextBuffer textBuffer) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)textBuffer, (String)"textBuffer");
        this.textBuffer = textBuffer;
        this.history = new LinkedHashMap(20, 0.75f, false);
        this.latestKnownSlaveVersion = this.textBuffer.getBufferVersion();
        boolean bl = this.textBuffer.isMaster();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "DocumentRangeShifter works only on the master side";
            throw new AssertionError((Object)string);
        }
        ((Map)this.history).put(this.textBuffer.getBufferVersion(), new RdTextChange(RdTextChangeKind.Insert, 0, "", "", 0));
        this.textBuffer.getHistoryChanged().advise(lifetime, arg_0 -> TextBufferDocumentRangeShifter._init_$lambda$2(this, arg_0));
        this.textBuffer.getDiscardedBufferVersion().advise(lifetime, arg_0 -> TextBufferDocumentRangeShifter._init_$lambda$4(this, arg_0));
    }

    public void shrinkHistory() {
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Clearing change history before " + this.latestKnownSlaveVersion);
        }
        this.clearHistoryBefore(this.latestKnownSlaveVersion);
    }

    private final void clearHistoryBefore(TextBufferVersion bufferVersion) {
        Iterator<TextBufferVersion> iterator2 = this.history.keySet().iterator();
        while (iterator2.hasNext()) {
            TextBufferVersion key;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (key.compareTo(bufferVersion) >= 0) break;
            iterator2.remove();
        }
    }

    @Nullable
    public TextRange shiftRange(@NotNull AbstractDocumentVersion v, @NotNull TextRange range, boolean isVerifiable, boolean isGreedyToLeft, boolean isGreedyToRight) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl2 = bl = range.getStartOffset() <= range.getEndOffset();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-TextBufferDocumentRangeShifter$shiftRange$22 = false;
            String $i$a$-assert-TextBufferDocumentRangeShifter$shiftRange$22 = "Range: " + range + " is not normalized";
            throw new AssertionError((Object)$i$a$-assert-TextBufferDocumentRangeShifter$shiftRange$22);
        }
        TextBufferVersion initialVersion = ((DocumentVersion)v).getValue();
        if (!this.checkVersions(initialVersion)) {
            return null;
        }
        int resultStart = range.getStartOffset();
        int resultEnd = range.getEndOffset();
        for (Map.Entry entry2 : ((Map)this.history).entrySet()) {
            TextBufferVersion version = (TextBufferVersion)entry2.getKey();
            RdTextChange change = (RdTextChange)entry2.getValue();
            if (version.compareTo(initialVersion) <= 0 || change.getKind() == RdTextChangeKind.PromoteVersion) continue;
            if (change.getKind() == RdTextChangeKind.Reset) {
                return null;
            }
            int oldLength = change.getOld().length();
            int start2 = change.getStartOffset();
            int end = start2 + oldLength;
            int delta = RdTextChangeKt.delta((RdTextChange)change);
            if (resultStart == end && (change.getKind() == RdTextChangeKind.InsertRightSide || isGreedyToRight)) {
                resultEnd += delta;
                continue;
            }
            if (resultEnd <= start2) continue;
            if (resultStart == end && (change.getKind() == RdTextChangeKind.InsertLeftSide || isGreedyToLeft)) {
                resultEnd += delta;
                continue;
            }
            if (resultStart >= end) {
                resultStart += delta;
                resultEnd += delta;
                continue;
            }
            if (resultStart <= start2 && end <= resultEnd && !isVerifiable) {
                resultEnd += delta;
                continue;
            }
            return null;
        }
        return new TextRange(resultStart, resultEnd);
    }

    public int shiftOnePoint(@NotNull AbstractDocumentVersion v, int offset, boolean isStickingToRight) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        TextBufferVersion initialVersion = ((DocumentVersion)v).getValue();
        if (!this.checkVersions(initialVersion)) {
            return -1;
        }
        int resultOffset = offset;
        for (Map.Entry entry2 : ((Map)this.history).entrySet()) {
            TextBufferVersion version = (TextBufferVersion)entry2.getKey();
            RdTextChange change = (RdTextChange)entry2.getValue();
            if (version.compareTo(initialVersion) <= 0 || change.getKind() == RdTextChangeKind.PromoteVersion) continue;
            if (change.getKind() == RdTextChangeKind.Reset) {
                return -1;
            }
            int oldLength = change.getOld().length();
            int start2 = change.getStartOffset();
            int end = start2 + oldLength;
            int delta = RdTextChangeKt.delta((RdTextChange)change);
            if (resultOffset < start2) continue;
            if (resultOffset > end || isStickingToRight && oldLength == 0) {
                resultOffset += delta;
                continue;
            }
            return -1;
        }
        return resultOffset;
    }

    private final boolean checkVersions(TextBufferVersion version) {
        if (!this.history.containsKey(version)) {
            LOG.error("Change " + version + " cannot be found in history. ");
            return false;
        }
        if (this.latestKnownSlaveVersion.compareTo(version) < 0) {
            this.latestKnownSlaveVersion = version;
        }
        return true;
    }

    private static final Unit _init_$lambda$2(TextBufferDocumentRangeShifter this$0, RdTextChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((Map)this$0.history).put(this$0.textBuffer.getBufferVersion(), it);
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Adding change " + it + " to version " + this$0.textBuffer.getBufferVersion());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(TextBufferDocumentRangeShifter this$0, TextBufferVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Discarding change with version " + it);
        }
        this$0.history.remove(it);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TextBufferDocumentRangeShifter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/daemon/TextBufferDocumentRangeShifter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

