/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.fileType;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.cpp.fileType.CppHeaderFileType;
import com.jetbrains.rider.cpp.fileType.lexer.CppLexer;
import com.jetbrains.rider.cpp.fileType.lexer.CppTokenTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/cpp/fileType/CppHeaderFileTypeDetector;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry$FileTypeDetector;", "<init>", "()V", "detect", "Lcom/intellij/openapi/fileTypes/FileType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstBytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "firstCharsIfText", "", "getDesiredContentPrefixLength", "", "intellij.rider.cpp.core"})
public final class CppHeaderFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    @Nullable
    public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        IElementType tt;
        IElementType iElementType;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)firstBytes, (String)"firstBytes");
        if (firstCharsIfText == null) {
            return null;
        }
        if (file.getExtension() != null) {
            return null;
        }
        CppLexer lexer = new CppLexer();
        lexer.start(firstCharsIfText);
        boolean atNewLine = true;
        boolean wasDirective = false;
        int identsInSequence = 0;
        while ((iElementType = (tt = lexer.getTokenType())) != null) {
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)CppTokenTypes.UNKNOWN_DIRECTIVE)) || Intrinsics.areEqual((Object)iElementType, (Object)TokenType.BAD_CHARACTER)) {
                lexer.advance();
                if (lexer.getTokenType() == null) break;
                return null;
            }
            if (CppTokenTypes.COMMENTS.contains(iElementType)) {
                identsInSequence = 0;
            } else if (CppTokenTypes.WHITESPACES.contains(iElementType)) {
                String string = lexer.getTokenText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                    atNewLine = true;
                }
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)CppTokenTypes.IDENTIFIER))) {
                if (++identsInSequence > 7) {
                    return null;
                }
                atNewLine = false;
            } else if (CppTokenTypes.DIRECTIVES.contains(iElementType)) {
                if (atNewLine) {
                    wasDirective = true;
                    break;
                }
                identsInSequence = 0;
            } else {
                atNewLine = false;
                identsInSequence = 0;
            }
            lexer.advance();
        }
        return wasDirective ? (FileType)CppHeaderFileType.INSTANCE : null;
    }

    public int getDesiredContentPrefixLength() {
        return 8192;
    }
}

