/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.completion;

import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.jetbrains.rider.completion.RiderCodeCompletionExtraSettings;
import com.jetbrains.rider.cpp.completion.CppCompletionHelperBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/cpp/completion/CppCharFilterBase;", "Lcom/intellij/codeInsight/lookup/CharFilter;", "<init>", "()V", "isApplicable", "", "language", "Lcom/intellij/lang/Language;", "acceptChar", "Lcom/intellij/codeInsight/lookup/CharFilter$Result;", "c", "", "prefixLength", "", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "intellij.rider.cpp.core"})
public abstract class CppCharFilterBase
extends CharFilter {
    public abstract boolean isApplicable(@NotNull Language var1);

    @Nullable
    public CharFilter.Result acceptChar(char c, int prefixLength, @NotNull Lookup lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        PsiFile psiFile = lookup.getPsiFile();
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        Language language = psiFile2.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        if (this.isApplicable(language)) {
            if (c == '(' || c == ':') {
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (c == ' ') {
                if (RiderCodeCompletionExtraSettings.Companion.getInstance().getAllowToCompleteWithWhitespace()) {
                    return CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
                return CharFilter.Result.HIDE_LOOKUP;
            }
            if (c == '.') {
                PsiFile psiFile3 = lookup.getPsiFile();
                if (psiFile3 == null || (psiFile3 = psiFile3.getViewProvider()) == null || (psiFile3 = psiFile3.getDocument()) == null) {
                    return null;
                }
                PsiFile document = psiFile3;
                if (CppCompletionHelperBase.Companion.isInFileNameContext((Document)document, lookup.getLookupStart())) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
            } else if (c == '=' && 8 == prefixLength) {
                FileViewProvider fileViewProvider = psiFile2.getViewProvider();
                if (fileViewProvider == null || (fileViewProvider = fileViewProvider.getDocument()) == null) {
                    return null;
                }
                FileViewProvider document = fileViewProvider;
                CharSequence prefix = document.getCharsSequence().subSequence(lookup.getLookupStart(), lookup.getLookupStart() + prefixLength);
                if ("operator".contentEquals(prefix)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
            }
            return null;
        }
        return null;
    }
}

