/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.BaseCompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeigherExtensionPoint;
import com.intellij.util.ProcessingContext;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.CompletionItemType;
import com.jetbrains.rd.ide.model.ScoringHint;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.completion.ProtocolLookupItemBase;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.util.idea.EditorUtilKt;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.ModelUtilKt;
import com.jetbrains.rider.completion.ProtocolCompletionContributor;
import com.jetbrains.rider.completion.ProtocolCompletionContributorKt;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@RiderOnly
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J8\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J,\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00190\"H\u0014J>\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/completion/ProtocolCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "owner", "Lcom/jetbrains/rider/completion/ProtocolCompletionContributor;", "<init>", "(Lcom/jetbrains/rider/completion/ProtocolCompletionContributor;)V", "mlCompletionWeigher", "Lcom/intellij/psi/Weigher;", "", "getMlCompletionWeigher", "()Lcom/intellij/psi/Weigher;", "mlCompletionWeigher$delegate", "Lkotlin/Lazy;", "addCompletions", "", "params", "context", "Lcom/intellij/util/ProcessingContext;", "initialResultSet", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "createCompletionConsumer", "prefix", "", "allSmallLetters", "", "onlyFirstLetterIsCapital", "casingIsDescendant", "forceMiddleMatch", "Ljava/lang/Object;", "processItem", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "customFilter", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase;", "groupByPrefixAndHints", "", "degree", "", "element", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProtocolCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolCompletionProvider.kt\ncom/jetbrains/rider/completion/ProtocolCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,332:1\n68#2,4:333\n68#2,4:339\n68#2,4:343\n68#2,4:347\n295#3,2:337\n*S KotlinDebug\n*F\n+ 1 ProtocolCompletionProvider.kt\ncom/jetbrains/rider/completion/ProtocolCompletionProvider\n*L\n46#1:333,4\n96#1:339,4\n102#1:343,4\n116#1:347,4\n40#1:337,2\n*E\n"})
public class ProtocolCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProtocolCompletionContributor owner;
    @NotNull
    private final Lazy mlCompletionWeigher$delegate;
    @NotNull
    private final Object forceMiddleMatch;
    @NotNull
    private static final Key<Integer> CachedScore = new Key("CachedItemScore");
    @NotNull
    private static final String MlCompletionWeigherId = "ml_weigh";
    @NotNull
    private static final Key<Boolean> LookupStringEqualsPrefixKey = new Key("ML_feature_lookupStringEqualsPrefix");
    @NotNull
    private static final Key<Boolean> LookupStringStartsWithPrefixKey = new Key("ML_feature_lookupStringStartsWithPrefixKey");

    public ProtocolCompletionProvider(@NotNull ProtocolCompletionContributor owner) {
        Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
        this.owner = owner;
        this.mlCompletionWeigher$delegate = LazyKt.lazy(ProtocolCompletionProvider::mlCompletionWeigher_delegate$lambda$1);
        this.forceMiddleMatch = new Object();
    }

    private final Weigher<Object, Object> getMlCompletionWeigher() {
        Lazy lazy = this.mlCompletionWeigher$delegate;
        return (Weigher)lazy.getValue();
    }

    protected void addCompletions(@NotNull CompletionParameters params, @NotNull ProcessingContext context2, @NotNull CompletionResultSet initialResultSet) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)initialResultSet, (String)"initialResultSet");
        if (!UtilsKt.isTypingSessionCompletionEnabled()) {
            return;
        }
        Logger $this$trace$iv = this.owner.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("start contributor #" + this.owner.getCompletionId().incrementAndGet() + " for editor " + params.getEditor());
        }
        Project project = params.getEditor().getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.tryGetInstance(project2);
        if (frontendCompletionHost == null) {
            return;
        }
        FrontendCompletionHost completionHost = frontendCompletionHost;
        PsiFile psiFile = params.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile psiFile2 = psiFile;
        CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
        CompletionProcessEx completionProcessEx = completionProcess instanceof CompletionProcessEx ? (CompletionProcessEx)completionProcess : null;
        if (completionProcessEx == null) {
            return;
        }
        CompletionProcessEx currentCompletion = completionProcessEx;
        Disposable disposable = Disposer.newDisposable((String)"Protocol completion contributor");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        currentCompletion.registerChildDisposable(() -> ProtocolCompletionProvider.addCompletions$lambda$3(disposable2));
        if (Disposer.isDisposed((Disposable)disposable2)) {
            return;
        }
        LifetimeDisposableExKt.doIfAlive((Disposable)disposable2, arg_0 -> ProtocolCompletionProvider.addCompletions$lambda$9(disposable2, params, psiFile2, this, initialResultSet, completionHost, arg_0));
    }

    @NotNull
    protected CompletionResultSet createCompletionConsumer(@NotNull CompletionResultSet initialResultSet, @NotNull String prefix, boolean allSmallLetters, boolean onlyFirstLetterIsCapital, boolean casingIsDescendant, @NotNull CompletionParameters params) {
        CompletionSorter completionSorter;
        Intrinsics.checkNotNullParameter((Object)initialResultSet, (String)"initialResultSet");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LookupElementWeigher[] lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            public Double weigh(LookupElement element) {
                double d;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PrioritizedLookupElement) {
                    d = -((PrioritizedLookupElement)element).getPriority();
                } else if (element instanceof LookupElementDecorator && ((LookupElementDecorator)element).getDelegate() instanceof PrioritizedLookupElement) {
                    LookupElement lookupElement = ((LookupElementDecorator)element).getDelegate();
                    Intrinsics.checkNotNull((Object)lookupElement, (String)"null cannot be cast to non-null type com.intellij.codeInsight.completion.PrioritizedLookupElement<*>");
                    d = -((PrioritizedLookupElement)lookupElement).getPriority();
                } else {
                    d = -0.0;
                }
                return d;
            }
        }};
        CompletionSorter completionSorter2 = CompletionSorter.emptySorter().weigh(new LookupElementWeigher(this, allSmallLetters, onlyFirstLetterIsCapital, casingIsDescendant){
            final /* synthetic */ ProtocolCompletionProvider this$0;
            final /* synthetic */ boolean $allSmallLetters;
            final /* synthetic */ boolean $onlyFirstLetterIsCapital;
            final /* synthetic */ boolean $casingIsDescendant;
            {
                this.this$0 = $receiver;
                this.$allSmallLetters = $allSmallLetters;
                this.$onlyFirstLetterIsCapital = $onlyFirstLetterIsCapital;
                this.$casingIsDescendant = $casingIsDescendant;
                super("mostRelevantItems");
            }

            public Double weigh(LookupElement element, WeighingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                ProtocolLookupItemBase protocolLookupItemBase = com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem(element);
                if (protocolLookupItemBase == null || (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) == null) {
                    return -1.0;
                }
                ProtocolLookupItemBase completionItem = protocolLookupItemBase;
                String string = context2.itemPattern(element);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPattern(...)");
                String itemPattern = string;
                PrefixMatcher prefixMatcher = context2.itemMatcher(element).cloneWithPrefix(itemPattern);
                Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
                PrefixMatcher itemMatcher = prefixMatcher;
                int degree = ProtocolCompletionContributorKt.getBestMatchingDegree(element, itemMatcher, (CompletionItem)completionItem);
                element.putUserData(ProtocolCompletionProvider.access$getCachedScore$cp(), (Object)degree);
                return this.this$0.groupByPrefixAndHints(degree, element, this.$allSmallLetters, this.$onlyFirstLetterIsCapital, itemPattern, (CompletionItem)completionItem, this.$casingIsDescendant);
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }).weighAfter("mostRelevantItems", lookupElementWeigherArray);
        lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            public Integer weigh(LookupElement element, WeighingContext context2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Integer cachedDegree = (Integer)element.getUserData(ProtocolCompletionProvider.access$getCachedScore$cp());
                if (cachedDegree != null) {
                    return cachedDegree;
                }
                ProtocolLookupItemBase protocolLookupItemBase = com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem(element);
                if (protocolLookupItemBase == null || (protocolLookupItemBase = protocolLookupItemBase.getCompletionItem()) == null) {
                    return -1;
                }
                ProtocolLookupItemBase completionItem = protocolLookupItemBase;
                PrefixMatcher prefixMatcher = context2.itemMatcher(element).cloneWithPrefix(context2.itemPattern(element));
                Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
                PrefixMatcher itemMatcher = prefixMatcher;
                return ProtocolCompletionContributorKt.getBestMatchingDegree(element, itemMatcher, (CompletionItem)completionItem);
            }

            public boolean isPrefixDependent() {
                return true;
            }
        }};
        CompletionSorter completionSorter3 = completionSorter2.weighAfter("backendPriority", lookupElementWeigherArray);
        lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            public Integer weigh(LookupElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String string = element.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                CharSequence $this$count$iv = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!Character.isUpperCase(c)) continue;
                    ++count$iv;
                }
                return count$iv;
            }

            public boolean isPrefixDependent() {
                return false;
            }
        }};
        CompletionSorter completionSorter4 = completionSorter3.weighAfter("matcherPriority", lookupElementWeigherArray);
        lookupElementWeigherArray = new LookupElementWeigher[]{new LookupElementWeigher(){

            public Integer weigh(LookupElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                String string = element.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                if (StringsKt.startsWith$default((String)string, (String)"(", (boolean)false, (int)2, null)) {
                    return 0;
                }
                return -1;
            }

            public boolean isPrefixDependent() {
                return false;
            }
        }};
        CompletionSorter completionSorter5 = completionSorter4.weighAfter("lessHumpsPriority", lookupElementWeigherArray);
        CompletionResultSet completionResultSet = initialResultSet.withPrefixMatcher(prefix);
        boolean bl = false;
        Weigher<Object, Object> mlWeigher = this.getMlCompletionWeigher();
        if (mlWeigher != null) {
            LookupElementWeigher[] lookupElementWeigherArray2 = new LookupElementWeigher[]{new LookupElementWeigher(params, mlWeigher){
                final /* synthetic */ CompletionParameters $params;
                final /* synthetic */ Weigher<Object, Object> $mlWeigher;
                {
                    this.$params = $params;
                    this.$mlWeigher = $mlWeigher;
                    super("ml_weigh");
                }

                public Comparable<Object> weigh(LookupElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    CompletionLocation location = new CompletionLocation(this.$params);
                    return this.$mlWeigher.weigh((Object)element, (Object)location);
                }
            }};
            completionSorter = sorter.weighAfter("shorterLambdas", lookupElementWeigherArray2);
        } else {
            completionSorter = sorter;
        }
        CompletionResultSet completionResultSet2 = completionResultSet.withRelevanceSorter(completionSorter);
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet2, (String)"withRelevanceSorter(...)");
        CompletionResultSet consumer2 = completionResultSet2;
        return consumer2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean processItem(@NotNull LookupElement lookupElement, @NotNull String prefix, @NotNull Function1<? super ProtocolLookupItemBase, Boolean> customFilter) {
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter(customFilter, (String)"customFilter");
        lookupElement.putUserData(BaseCompletionLookupArranger.FORCE_MIDDLE_MATCH, this.forceMiddleMatch);
        ProtocolLookupItemBase protocolLookupItemBase = com.jetbrains.rdclient.completion.UtilsKt.tryGetProtocolItem(lookupElement);
        if (protocolLookupItemBase == null) {
            return true;
        }
        ProtocolLookupItemBase protocolItem = protocolLookupItemBase;
        if (!((Boolean)customFilter.invoke((Object)protocolItem)).booleanValue()) {
            return false;
        }
        boolean isTemplateItem = protocolItem.getCompletionItem().getItemType() == CompletionItemType.TemplateItem;
        if (((CharSequence)prefix).length() == 0) {
            String string = lookupElement.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'#', (boolean)false, (int)2, null)) return false;
            if (isTemplateItem) {
                return false;
            }
        }
        if (!isTemplateItem) return true;
        String string = lookupElement.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        if (StringsKt.startsWith((String)string, (String)prefix, (boolean)true)) return true;
        return false;
    }

    public final double groupByPrefixAndHints(int degree, @NotNull LookupElement element, boolean allSmallLetters, boolean onlyFirstLetterIsCapital, @NotNull String prefix, @NotNull CompletionItem completionItem, boolean casingIsDescendant) {
        boolean typingHint;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        boolean lookupStringEqualsPrefixIgnoreCase = StringsKt.equals((String)element.getLookupString(), (String)prefix, (boolean)true);
        element.putUserData(LookupStringEqualsPrefixKey, (Object)lookupStringEqualsPrefixIgnoreCase);
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        boolean lookupStartsWithPrefixIgnoreCase = StringsKt.startsWith((String)string, (String)prefix, (boolean)true);
        element.putUserData(LookupStringStartsWithPrefixKey, (Object)lookupStartsWithPrefixIgnoreCase);
        String string2 = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
        boolean lookupStartsWithPrefix = StringsKt.startsWith((String)string2, (String)prefix, (boolean)false);
        List scoringHints = completionItem.getScoringHints();
        if (scoringHints.contains(ScoringHint.Obsolete)) {
            return -0.2;
        }
        if (degree <= -1052 && scoringHints.contains(ScoringHint.FieldsParamsLocals)) {
            return -5.0 + (double)(degree + 1052) / 100.0;
        }
        if (degree <= -1000 && scoringHints.contains(ScoringHint.Blessed)) {
            return -5.0;
        }
        if ((degree <= -1150 || lookupStartsWithPrefixIgnoreCase && degree <= -1000) && completionItem.getStatsScore() > 0) {
            return -4.0 - (double)((float)completionItem.getStatsScore() / (float)50);
        }
        if (degree < -1001 && lookupStringEqualsPrefixIgnoreCase) {
            return -3.5;
        }
        if (degree <= -1100 && lookupStartsWithPrefixIgnoreCase && casingIsDescendant) {
            return -3.3;
        }
        if (degree <= -1100 && scoringHints.contains(ScoringHint.LightItem) && lookupStartsWithPrefix && prefix.length() >= 3) {
            return -3.2;
        }
        if (degree <= -1100 && scoringHints.contains(ScoringHint.LightItem)) {
            String string3 = element.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLookupString(...)");
            if (!StringsKt.contains$default((CharSequence)string3, (char)' ', (boolean)false, (int)2, null)) {
                return -3.0;
            }
        }
        if (degree <= -1000 && scoringHints.contains(ScoringHint.FieldsParamsLocals) && allSmallLetters) {
            return -2.5;
        }
        if (degree <= -1000 && lookupStartsWithPrefixIgnoreCase && allSmallLetters && scoringHints.contains(ScoringHint.LightItem)) {
            return -2.0;
        }
        boolean bl = typingHint = lookupStartsWithPrefix && onlyFirstLetterIsCapital;
        if (degree <= -1000 && typingHint) {
            return -2.0;
        }
        if (completionItem.getItemType() == CompletionItemType.PostfixTemplate && ((CharSequence)prefix).length() == 0) {
            return -0.5;
        }
        return -1.0;
    }

    private static final Weigher mlCompletionWeigher_delegate$lambda$1() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = WeigherExtensionPoint.EP.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WeigherExtensionPoint it = (WeigherExtensionPoint)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)"completion", (Object)it.getKey()) && Intrinsics.areEqual((Object)MlCompletionWeigherId, (Object)it.id))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        WeigherExtensionPoint weigherExtensionPoint = v0;
        return weigherExtensionPoint != null ? (Weigher)weigherExtensionPoint.getInstance() : null;
    }

    private static final Disposable addCompletions$lambda$3(Disposable $disposable) {
        return $disposable;
    }

    private static final boolean addCompletions$lambda$9$lambda$4(ProtocolLookupItemBase it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return true;
    }

    private static final boolean addCompletions$lambda$9$lambda$7(ProtocolCompletionProvider this$0, String $prefix, Function1 $customFilter, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
        return this$0.processItem(lookupElement, $prefix, (Function1<? super ProtocolLookupItemBase, Boolean>)$customFilter);
    }

    private static final Unit addCompletions$lambda$9(Disposable $disposable, CompletionParameters $params, PsiFile $psiFile, ProtocolCompletionProvider this$0, CompletionResultSet $initialResultSet, FrontendCompletionHost $completionHost, Lifetime it) {
        Logger logger;
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Lifetime popupLifetime = LifetimeDisposableExKt.createLifetime((Disposable)$disposable);
        int prefixOffset = $params.getOffset();
        Editor editor = $params.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        if (EditorUtilKt.hasMultipleEditPoints(editor) || $params.getEditor().getSelectionModel().hasSelection()) {
            Editor editor2 = $params.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            prefixOffset = PlatformTextControlUtilsKt.getStartOffset(editor2);
        }
        if ((function1 = (Function1)$params.getEditor().getUserData(ProtocolCompletionContributor.Companion.getPassesCustomFilter())) == null) {
            function1 = ProtocolCompletionProvider::addCompletions$lambda$9$lambda$4;
        }
        Function1 customFilter = function1;
        boolean mayTrustLookup = $params.getInvocationCount() == 0;
        Project project = $psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(project);
        Document document = $params.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Editor editor3 = $params.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"getEditor(...)");
        String prefix = frontendCompletionHost.getCompletionPrefix(prefixOffset, document, $psiFile, ModelUtilKt.getCurrentOffsetSafe(DocumentExKt.getTextControlModel(editor3)), $params.getEditor(), mayTrustLookup);
        if (this$0.owner.shouldStopOnPrefix(prefix, $params.isAutoPopup())) {
            return Unit.INSTANCE;
        }
        boolean allSmallLetters = true;
        boolean onlyFirstLetterIsCapital = false;
        boolean hasSmallLetters = false;
        boolean casingIsDescendant = false;
        int n = prefix.length();
        for (int i = 0; i < n; ++i) {
            char c = prefix.charAt(i);
            if (Character.isUpperCase(c)) {
                allSmallLetters = false;
                boolean bl = onlyFirstLetterIsCapital = i == 0;
                if (i == 0) {
                    casingIsDescendant = true;
                    continue;
                }
                if (!hasSmallLetters) continue;
                casingIsDescendant = false;
                continue;
            }
            hasSmallLetters = true;
        }
        casingIsDescendant = casingIsDescendant && hasSmallLetters;
        Logger $this$trace$iv = this$0.owner.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("prefix is '" + prefix + "'");
        }
        CompletionResultSet consumer2 = this$0.createCompletionConsumer($initialResultSet, prefix, allSmallLetters, onlyFirstLetterIsCapital, casingIsDescendant, $params);
        CompletionProcess completionProcess = CompletionService.getCompletionService().getCurrentCompletion();
        if (completionProcess == null) {
            return Unit.INSTANCE;
        }
        CompletionProcess indicator = completionProcess;
        LookupEx lookupEx = LookupManagerImpl.Companion.getActiveLookup($params.getEditor());
        LookupImpl lookup = lookupEx instanceof LookupImpl ? (LookupImpl)lookupEx : null;
        Logger $this$trace$iv2 = this$0.owner.getLogger();
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            LookupImpl lookupImpl = lookup;
            logger.trace("isAutopopupCompletion: " + indicator.isAutopopupCompletion() + ". lookup: " + (lookupImpl != null ? lookupImpl.hashCode() : 0));
        }
        Ref cursor = new Ref((Object)0);
        while (true) {
            Editor editor4 = $params.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor4, (String)"getEditor(...)");
            boolean itemsConsumed = $completionHost.consumeItems(editor4, consumer2, popupLifetime, (Ref<Integer>)cursor, (Function1<? super LookupElement, Boolean>)((Function1)arg_0 -> ProtocolCompletionProvider.addCompletions$lambda$9$lambda$7(this$0, prefix, customFilter, arg_0)));
            if (!itemsConsumed) break;
            this$0.owner.getLogger().trace("Items have passed to lookup engine.");
        }
        if (((CharSequence)prefix).length() == 0) {
            $initialResultSet.restartCompletionOnAnyPrefixChange();
        }
        Logger $this$trace$iv3 = this$0.owner.getLogger();
        boolean $i$f$trace3 = false;
        if ($this$trace$iv3.isTraceEnabled()) {
            logger = $this$trace$iv3;
            boolean bl = false;
            logger.trace("contributor has finished its job. " + consumer2);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Key access$getCachedScore$cp() {
        return CachedScore;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/completion/ProtocolCompletionProvider$Companion;", "", "<init>", "()V", "CachedScore", "Lcom/intellij/openapi/util/Key;", "", "MlCompletionWeigherId", "", "LookupStringEqualsPrefixKey", "", "getLookupStringEqualsPrefixKey", "()Lcom/intellij/openapi/util/Key;", "LookupStringStartsWithPrefixKey", "getLookupStringStartsWithPrefixKey", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getLookupStringEqualsPrefixKey() {
            return LookupStringEqualsPrefixKey;
        }

        @NotNull
        public final Key<Boolean> getLookupStringStartsWithPrefixKey() {
            return LookupStringStartsWithPrefixKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

