/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.model.CompletionMode;
import com.jetbrains.rd.ide.model.CompletionModel_GeneratedKt;
import com.jetbrains.rd.ide.model.CompletionParameters;
import com.jetbrains.rd.ide.model.CompletionTuple;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.completion.ClientCompletionSupport;
import com.jetbrains.rider.completion.CompletionSessionParameters;
import com.jetbrains.rider.completion.CompletionSessionState;
import com.jetbrains.rider.completion.CompletionSessionStrategy;
import com.jetbrains.rider.completion.CompletionStateData;
import com.jetbrains.rider.completion.FrontendCompletionHost;
import com.jetbrains.rider.completion.FrontendCompletionHostKt;
import com.jetbrains.rider.completion.PreemptiveCompletionHost;
import com.jetbrains.rider.completion.PreemptiveCompletionHostKt;
import com.jetbrains.rider.completion.UtilsKt;
import com.jetbrains.rider.editorActions.TypingSessions;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0016\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u000bH\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0014H\u0014J4\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0012H\u0014J \u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u0017H\u0014J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0016J:\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020\u001aH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/completion/PreemptiveCompletionHost;", "Lcom/jetbrains/rider/completion/FrontendCompletionHost;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "preemptiveCompletionQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getPreemptiveCompletionQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "restartRightAway", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "completionParameters", "Lcom/jetbrains/rider/completion/CompletionSessionParameters;", "tryScheduleCompletion", "reason", "", "adjustCompletionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "completionType", "invocationCount", "", "flushSessionQueue", "shouldBeTriggered", "", "type", "shouldRestartCompletionSession", "isAutoPopup", "customPrefix", "customHost", "completionStarted", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "offset", "beforeCompletionItemInserted", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "getCompletionPrefix", "documentOffset", "document", "Lcom/intellij/openapi/editor/Document;", "psiFile", "Lcom/intellij/psi/PsiFile;", "completionOffset", "mayTrustLookup", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nPreemptiveCompletionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreemptiveCompletionHost.kt\ncom/jetbrains/rider/completion/PreemptiveCompletionHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,222:1\n68#2,4:223\n61#2,5:227\n68#2,4:232\n68#2,4:236\n14#2:242\n1#3:240\n13#4:241\n*S KotlinDebug\n*F\n+ 1 PreemptiveCompletionHost.kt\ncom/jetbrains/rider/completion/PreemptiveCompletionHost\n*L\n52#1:223,4\n80#1:227,5\n89#1:232,4\n114#1:236,4\n181#1:242\n181#1:241\n*E\n"})
public abstract class PreemptiveCompletionHost
extends FrontendCompletionHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MergingUpdateQueue preemptiveCompletionQueue;
    @NotNull
    private static final Logger logger;

    public PreemptiveCompletionHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.preemptiveCompletionQueue = new MergingUpdateQueue("preemptiveCompletionQueue", 10, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, true).setRestartTimerOnAdd(true);
        if (UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            this.preemptiveCompletionQueue.setPassThrough(false);
            UISettings.Companion.getInstance().setMaxLookupWidth(1000);
        }
    }

    @NotNull
    protected final MergingUpdateQueue getPreemptiveCompletionQueue() {
        return this.preemptiveCompletionQueue;
    }

    @Override
    protected void restartRightAway(@NotNull Editor editor, @NotNull CompletionSessionParameters completionParameters) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completionParameters, (String)"completionParameters");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        if (!LastFocusedEditorSuppressor.Companion.getInstance(this.getProject()).getMaySuppress()) {
            return;
        }
        this.preemptiveCompletionQueue.cancelAllUpdates();
        super.restartRightAway(editor, completionParameters);
    }

    public final void tryScheduleCompletion(@NotNull Editor editor, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        if (completionStateData.getSaveSession()) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("trying to terminate current session while it's frozen");
            }
            return;
        }
        this.terminateCurrentCompletion(editor, reason);
        logger.trace("queueing preemptive background completion...");
        this.preemptiveCompletionQueue.queue(new Update(this, editor){
            final /* synthetic */ PreemptiveCompletionHost this$0;
            final /* synthetic */ Editor $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                super((Object)"perform preemptive completion", false, 0, 6, null);
            }

            public void run() {
                ApplicationManager.getApplication().runWriteIntentReadAction(() -> tryScheduleCompletion.2.run$lambda$0(this.this$0, this.$editor));
            }

            private static final Unit run$lambda$0(PreemptiveCompletionHost this$0, Editor $editor) {
                this$0.restartRightAway($editor, new CompletionSessionParameters(CompletionType.BASIC, 0, null, null, 12, null));
                return Unit.INSTANCE;
            }
        });
    }

    @Override
    @NotNull
    protected CompletionType adjustCompletionType(@NotNull CompletionType completionType, int invocationCount) {
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        return completionType;
    }

    @TestOnly
    public final void flushSessionQueue() {
        this.preemptiveCompletionQueue.flush();
    }

    @Override
    protected boolean shouldBeTriggered(@NotNull Editor editor, @NotNull CompletionType type) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!super.shouldBeTriggered(editor, type)) {
            return false;
        }
        if (!TypingSessions.Companion.getInstance(this.getProject()).isTypingSessionSynced()) {
            Logger $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("trying to restart current session while typing session is not synced", e$iv);
            }
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        List list2 = CompletionSessionStrategy.Companion.getExtensions().allForLanguage(psiFile2.getLanguage());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"allForLanguage(...)");
        List strategies = list2;
        for (CompletionSessionStrategy strategy2 : strategies) {
            try {
                if (!strategy2.shouldForbidCompletion(editor, type)) continue;
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("Completion session was forbidden by '" + strategy2.getClass().getName() + "'");
                }
                return false;
            }
            catch (Throwable throwable) {
                logger.error("Error while calling shouldForbidCompletion API for '" + strategy2.getClass().getName() + "' for type '" + type + "'");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean shouldRestartCompletionSession(@NotNull Editor editor, @NotNull CompletionType completionType, boolean isAutoPopup, @Nullable String customPrefix, @Nullable String customHost) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)completionType, (String)"completionType");
        TextControlModel textControlModel = DocumentExKt.getTextControlModel(editor);
        TextControlModel textControlModel2 = textControlModel;
        IProperty completionSession = textControlModel2 != null && (textControlModel2 = CompletionModel_GeneratedKt.getCompletionModel((TextControlModel)textControlModel2)) != null ? textControlModel2.getCompletionSession() : null;
        IProperty iProperty = completionSession;
        CompletionParameters currentCompletionMode = iProperty != null && (iProperty = (CompletionTuple)iProperty.getValue()) != null ? iProperty.getParameters() : null;
        CompletionStateData completionStateData = FrontendCompletionHostKt.getCompletionStateData(editor);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            CompletionParameters completionParameters = currentCompletionMode;
            CompletionParameters completionParameters2 = currentCompletionMode;
            CompletionParameters completionParameters3 = currentCompletionMode;
            CompletionParameters completionParameters4 = currentCompletionMode;
            logger.trace(StringsKt.trimIndent((String)("\n        shouldRestartCompletionSession state\n        currentCompletionMode : " + (CompletionMode)(completionParameters != null ? completionParameters.getMode() : null) + "\n        currentCompletionMode.isAutoCompletion : " + (completionParameters2 != null ? Boolean.valueOf(completionParameters2.isAutoCompletion()) : null) + "\n        isAutoPopup : " + isAutoPopup + "\n        customPrefix : " + customPrefix + "\n        currentCompletionMode : " + (completionParameters3 != null ? completionParameters3.getPrefix() : null) + "\n        currentCompletionMode.customBackendParams : " + (completionParameters4 != null ? completionParameters4.getCustomBackendParams() : null) + "\n      ")));
        }
        Object object = completionStateData.getLock();
        synchronized (object) {
            String string;
            String string2;
            boolean bl = false;
            if (completionStateData.getState().getValue() == CompletionSessionState.Inactive) return true;
            if (currentCompletionMode == null) return true;
            if (currentCompletionMode.getMode() != UtilsKt.toModel(completionType)) return true;
            if (currentCompletionMode.isAutoCompletion()) {
                if (!isAutoPopup) return true;
            }
            if (customPrefix != null) {
                if (!Intrinsics.areEqual((Object)customPrefix, (Object)currentCompletionMode.getPrefix())) return true;
            }
            if ((string2 = customHost) == null) {
                string2 = "";
            }
            if ((string = currentCompletionMode.getCustomBackendParams()) == null) {
                string = "";
            }
            if (Intrinsics.areEqual((Object)string2, (Object)string)) return false;
            return true;
        }
    }

    @Override
    protected void completionStarted(@NotNull Lifetime sessionLifetime, @NotNull Editor editor, int offset) {
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        if (PowerSaveMode.isEnabled()) {
            logger.info("Skipping suppressing, because PowerSave mode is on.");
            return;
        }
        LastFocusedEditorSuppressor.Companion.getInstance(this.getProject()).suppressForLastFocusedEditorChanges(editor, sessionLifetime, "Suppression for completion synced offset " + offset + " for editor " + editor);
    }

    @Override
    public void beforeCompletionItemInserted(@NotNull ClientProjectSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (!UtilsKt.isTypingSessionCompletionPreemptivenessEnabled()) {
            return;
        }
        LastFocusedEditorSuppressor.Companion.getInstance(session2.getProject()).forceReleaseSuppressionForLastFocusedEditor("Completion lookup item");
    }

    @Override
    @NotNull
    public String getCompletionPrefix(int documentOffset, @NotNull Document document, @NotNull PsiFile psiFile, int completionOffset, @Nullable Editor editor, boolean mayTrustLookup) {
        String withPreprocessorDirectives;
        String string;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (mayTrustLookup && (string = this.tryGetCompletionPrefixFromLookup(editor)) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        PsiFile psiFile2 = psiFile.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        String string2 = withPreprocessorDirectives = PreemptiveCompletionHostKt.access$tryFindPrefixWithPreprocess(documentOffset, psiFile2);
        if (string2 != null) {
            return string2;
        }
        String string3 = CompletionUtil.findIdentifierPrefix((Document)document, (int)documentOffset, ClientCompletionSupport.Companion.getInstance().getIdentifierPart((PsiElement)psiFile, documentOffset, document, completionOffset), ClientCompletionSupport.Companion.getInstance().getIdentifierStart((PsiElement)psiFile, documentOffset, document, completionOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"findIdentifierPrefix(...)");
        return string3;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PreemptiveCompletionHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PreemptiveCompletionHost.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/completion/PreemptiveCompletionHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/completion/PreemptiveCompletionHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final PreemptiveCompletionHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FrontendCompletionHost frontendCompletionHost = FrontendCompletionHost.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)((Object)frontendCompletionHost), (String)"null cannot be cast to non-null type com.jetbrains.rider.completion.PreemptiveCompletionHost");
            return (PreemptiveCompletionHost)frontendCompletionHost;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

