/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.command;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.IdeFocusManager;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.PerformanceOutput;
import java.awt.Component;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/command/CheckFocusedEditorCommand;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "Companion", "intellij.rider.plugins.rdclient.performance"})
@SourceDebugExtension(value={"SMAP\nCheckFocusedEditorCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckFocusedEditorCommand.kt\ncom/jetbrains/rider/command/CheckFocusedEditorCommand\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n13#2:79\n14#3:80\n*S KotlinDebug\n*F\n+ 1 CheckFocusedEditorCommand.kt\ncom/jetbrains/rider/command/CheckFocusedEditorCommand\n*L\n32#1:79\n32#1:80\n*E\n"})
public final class CheckFocusedEditorCommand
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%checkFocusedEditor";
    @NotNull
    private static final Logger logger;

    public CheckFocusedEditorCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        logger.info("Start checking focused editor");
        ActionCallback callback = new ActionCallback("Check focused editor");
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 19;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String argumentString = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        char[] cArray = new char[]{' '};
        List arguments = StringsKt.split$default((CharSequence)argumentString, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (arguments.size() < 2) {
            String message = "Expected 2 arguments for command <expected editor, timeout>, but got: <" + argumentString + ">";
            logger.error(message);
            ActionCallback actionCallback = callback.reject(message);
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"reject(...)");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        String expectedEditor = (String)arguments.get(0);
        Long timeoutMs = StringsKt.toLongOrNull((String)((String)arguments.get(1)));
        if (timeoutMs == null) {
            String message = "Unable to parse 'timeout' command argument: <" + arguments.get(1) + ">";
            logger.error(message);
            ActionCallback actionCallback = callback.reject(message);
            Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"reject(...)");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)context2.getProject());
        Ref.ObjectRef editorName = new Ref.ObjectRef();
        editorName.element = "-";
        Duration duration = Duration.ofMillis(timeoutMs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        ExtensionsKt.pumpMessages(duration, (Function0<Boolean>)((Function0)() -> CheckFocusedEditorCommand._execute$lambda$0(focusManager, editorName, expectedEditor)));
        logger.info("Focused editor name: '" + editorName.element + "'");
        if (!Intrinsics.areEqual((Object)expectedEditor, (Object)editorName.element)) {
            String message = "Expected focus name: '" + expectedEditor + "', but found: '" + editorName.element + "'";
            PerformanceOutput.INSTANCE.reportAssertion(message);
            return Promises.rejectedPromise((String)message);
        }
        callback.setDone();
        return Promises.toPromise((ActionCallback)callback);
    }

    private static final boolean _execute$lambda$0(IdeFocusManager $focusManager, Ref.ObjectRef $editorName, String $expectedEditor) {
        IdeEventQueue.Companion.getInstance().flushQueue();
        Component component = $focusManager.getFocusOwner();
        EditorComponentImpl editorComponentImpl = component instanceof EditorComponentImpl ? (EditorComponentImpl)component : null;
        if (editorComponentImpl == null) {
            return false;
        }
        EditorComponentImpl focusOwner = editorComponentImpl;
        Object object = FileDocumentManager.getInstance().getFile((Document)focusOwner.getEditor().getDocument());
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        $editorName.element = object;
        return Intrinsics.areEqual((Object)$expectedEditor, (Object)$editorName.element);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CheckFocusedEditorCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CheckFocusedEditorCommand.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/command/CheckFocusedEditorCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.rdclient.performance"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

