/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.CpuArch;
import com.jetbrains.rider.CPUArch;
import com.jetbrains.rider.util.OSKind;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0086\u0081\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001 B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001e\u001a\u00020\u0003J\u0006\u0010\u001f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fj\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/CPUKind;", "", "directoryName", "", "cpuArch", "Lcom/jetbrains/rider/CPUArch;", "osKind", "Lcom/jetbrains/rider/util/OSKind;", "downloadKey", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lcom/jetbrains/rider/CPUArch;Lcom/jetbrains/rider/util/OSKind;Ljava/lang/String;)V", "getDirectoryName", "()Ljava/lang/String;", "getCpuArch", "()Lcom/jetbrains/rider/CPUArch;", "getOsKind", "()Lcom/jetbrains/rider/util/OSKind;", "getDownloadKey", "Win32", "Win64", "WinArm64", "Linux32", "Linux64", "LinuxArm32", "LinuxArm64", "LinuxMuslArm32", "LinuxMuslArm64", "LinuxMusl64", "MacOs64", "MacOsArm", "getDotnetDir", "getDotnetExecutable", "Companion", "intellij.rider.rdclient.dotnet"})
public final class CPUKind
extends Enum<CPUKind> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String directoryName;
    @NotNull
    private final CPUArch cpuArch;
    @NotNull
    private final OSKind osKind;
    @NotNull
    private final String downloadKey;
    public static final /* enum */ CPUKind Win32;
    public static final /* enum */ CPUKind Win64;
    public static final /* enum */ CPUKind WinArm64;
    public static final /* enum */ CPUKind Linux32;
    public static final /* enum */ CPUKind Linux64;
    public static final /* enum */ CPUKind LinuxArm32;
    public static final /* enum */ CPUKind LinuxArm64;
    public static final /* enum */ CPUKind LinuxMuslArm32;
    public static final /* enum */ CPUKind LinuxMuslArm64;
    public static final /* enum */ CPUKind LinuxMusl64;
    public static final /* enum */ CPUKind MacOs64;
    public static final /* enum */ CPUKind MacOsArm;
    private static final /* synthetic */ CPUKind[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private CPUKind(String directoryName, CPUArch cpuArch, OSKind osKind, String downloadKey) {
        this.directoryName = directoryName;
        this.cpuArch = cpuArch;
        this.osKind = osKind;
        this.downloadKey = downloadKey;
    }

    @NotNull
    public final String getDirectoryName() {
        return this.directoryName;
    }

    @NotNull
    public final CPUArch getCpuArch() {
        return this.cpuArch;
    }

    @NotNull
    public final OSKind getOsKind() {
        return this.osKind;
    }

    @NotNull
    public final String getDownloadKey() {
        return this.downloadKey;
    }

    @NotNull
    public final String getDotnetDir() {
        return this.directoryName + this.osKind.getPlatform().fileSeparator + "dotnet";
    }

    @NotNull
    public final String getDotnetExecutable() {
        return this.getDotnetDir() + this.osKind.getPlatform().fileSeparator + "dotnet" + (this.osKind == OSKind.Windows ? ".exe" : "");
    }

    public static CPUKind[] values() {
        return (CPUKind[])$VALUES.clone();
    }

    public static CPUKind valueOf(String value) {
        return Enum.valueOf(CPUKind.class, value);
    }

    @NotNull
    public static EnumEntries<CPUKind> getEntries() {
        return $ENTRIES;
    }

    static {
        Win32 = new CPUKind("windows-x86", CPUArch.X86, OSKind.Windows, "windows32");
        Win64 = new CPUKind("windows-x64", CPUArch.X64, OSKind.Windows, "windows64");
        WinArm64 = new CPUKind("windows-arm64", CPUArch.ARM64, OSKind.Windows, "windowsARM64");
        Linux32 = new CPUKind("linux-x86", CPUArch.X86, OSKind.Linux, "linux32");
        Linux64 = new CPUKind("linux-x64", CPUArch.X64, OSKind.Linux, "linux64");
        LinuxArm32 = new CPUKind("linux-arm", CPUArch.ARM32, OSKind.Linux, "linuxARM32");
        LinuxArm64 = new CPUKind("linux-arm64", CPUArch.ARM64, OSKind.Linux, "linuxARM64");
        LinuxMuslArm32 = new CPUKind("linux-musl-arm", CPUArch.ARM32, OSKind.Linux, "linuxMuslARM32");
        LinuxMuslArm64 = new CPUKind("linux-musl-arm64", CPUArch.ARM64, OSKind.Linux, "linuxMuslARM64");
        LinuxMusl64 = new CPUKind("linux-musl-x64", CPUArch.X64, OSKind.Linux, "linuxMuslX64");
        MacOs64 = new CPUKind("macos-x64", CPUArch.X64, OSKind.MacOS, "mac64");
        MacOsArm = new CPUKind("macos-arm64", CPUArch.ARM64, OSKind.MacOS, "macARM64");
        $VALUES = cPUKindArray = new CPUKind[]{CPUKind.Win32, CPUKind.Win64, CPUKind.WinArm64, CPUKind.Linux32, CPUKind.Linux64, CPUKind.LinuxArm32, CPUKind.LinuxArm64, CPUKind.LinuxMuslArm32, CPUKind.LinuxMuslArm64, CPUKind.LinuxMusl64, CPUKind.MacOs64, CPUKind.MacOsArm};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/CPUKind$Companion;", "", "<init>", "()V", "RIDER_CPU_KIND", "Lcom/jetbrains/rider/CPUKind;", "getRIDER_CPU_KIND", "()Lcom/jetbrains/rider/CPUKind;", "SYSTEM_CPU_KIND", "getSYSTEM_CPU_KIND", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CPUKind getRIDER_CPU_KIND() {
            if (SystemInfo.isWindows) {
                return CpuArch.isArm64() ? WinArm64 : Win64;
            }
            if (SystemInfo.isMac) {
                return CpuArch.isArm64() ? MacOsArm : MacOs64;
            }
            if (SystemInfo.isLinux) {
                return CpuArch.isArm64() ? LinuxArm64 : Linux64;
            }
            throw new IllegalStateException("Unknown OS: " + SystemInfo.getOsName());
        }

        @NotNull
        public final CPUKind getSYSTEM_CPU_KIND() {
            return CpuArch.isArm64() || CpuArch.isEmulated() ? (SystemInfo.isWindows ? WinArm64 : (SystemInfo.isMac ? MacOsArm : LinuxArm64)) : (SystemInfo.isWindows ? Win64 : (SystemInfo.isMac ? MacOs64 : Linux64));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

